/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.BufferedWriter;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Logger;
import uk.ac.starlink.fits.FitsConstants;
import uk.ac.starlink.fits.FitsTableSerializer;
import uk.ac.starlink.fits.FitsTableWriter;
import uk.ac.starlink.fits.StandardFitsTableSerializer;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.util.Base64OutputStream;
import uk.ac.starlink.votable.DataFormat;
import uk.ac.starlink.votable.Encoder;
import uk.ac.starlink.votable.VOStarTable;

public abstract class VOSerializer {
    private final StarTable table_;
    private final DataFormat format_;
    private final List paramList_;
    private final String ucd_;
    private final String utype_;
    private final String description_;
    static final Logger logger = Logger.getLogger("uk.ac.starlink.votable");
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;

    private VOSerializer(StarTable table, DataFormat format) {
        this.table_ = table;
        this.format_ = format;
        this.paramList_ = new ArrayList();
        String description = null;
        String ucd = null;
        String utype = null;
        Iterator it = table.getParameters().iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof DescribedValue)) continue;
            DescribedValue dval = (DescribedValue)obj;
            ValueInfo pinfo = dval.getInfo();
            String pname = pinfo.getName();
            Class pclazz = pinfo.getContentClass();
            Object value = dval.getValue();
            if (pname == null || pclazz == null) continue;
            if (pname.equalsIgnoreCase("description") && pclazz == (class$java$lang$String == null ? VOSerializer.class$("java.lang.String") : class$java$lang$String)) {
                description = (String)value;
                continue;
            }
            if (pname.equals(VOStarTable.UCD_INFO.getName()) && pclazz == (class$java$lang$String == null ? VOSerializer.class$("java.lang.String") : class$java$lang$String)) {
                ucd = (String)value;
                continue;
            }
            if (pname.equals(VOStarTable.UTYPE_INFO.getName()) && pclazz == (class$java$lang$String == null ? VOSerializer.class$("java.lang.String") : class$java$lang$String)) {
                utype = (String)value;
                continue;
            }
            this.paramList_.add(dval);
        }
        this.description_ = description;
        this.ucd_ = ucd;
        this.utype_ = utype;
    }

    public DataFormat getFormat() {
        return this.format_;
    }

    public StarTable getTable() {
        return this.table_;
    }

    public abstract void writeFields(BufferedWriter var1) throws IOException;

    public abstract void writeInlineDataElement(BufferedWriter var1) throws IOException;

    public abstract void writeHrefDataElement(BufferedWriter var1, String var2, DataOutput var3) throws IOException;

    public void writeInlineTableElement(BufferedWriter writer) throws IOException {
        this.writePreDataXML(writer);
        this.writeInlineDataElement(writer);
        this.writePostDataXML(writer);
    }

    public void writeHrefTableElement(BufferedWriter xmlwriter, String href, DataOutput streamout) throws IOException {
        this.writePreDataXML(xmlwriter);
        this.writeHrefDataElement(xmlwriter, href, streamout);
        this.writePostDataXML(xmlwriter);
    }

    public void writeParams(BufferedWriter writer) throws IOException {
        Iterator it = this.paramList_.iterator();
        while (it.hasNext()) {
            DescribedValue param = (DescribedValue)it.next();
            ValueInfo pinfo = param.getInfo();
            Encoder encoder = Encoder.getEncoder(pinfo);
            if (encoder != null) {
                String valtext = encoder.encodeAsText(param.getValue());
                String content = encoder.getFieldContent();
                writer.write("<PARAM");
                writer.write(VOSerializer.formatAttributes(encoder.getFieldAttributes()));
                writer.write(VOSerializer.formatAttribute("value", valtext));
                if (content.length() > 0) {
                    writer.write(">");
                    writer.write(content);
                    writer.newLine();
                    writer.write("</PARAM>");
                } else {
                    writer.write("/>");
                }
                writer.newLine();
                continue;
            }
            if (param.getValue() instanceof URL) {
                writer.write("<LINK" + VOSerializer.formatAttribute("title", pinfo.getName()) + VOSerializer.formatAttribute("href", param.getValue().toString()) + "/>");
                writer.newLine();
                continue;
            }
            Object value = param.getValue();
            writer.write("<INFO");
            writer.write(VOSerializer.formatAttribute("name", pinfo.getName()));
            if (value != null) {
                writer.write(VOSerializer.formatAttribute("value", value.toString()));
            }
            writer.write("/>");
            writer.newLine();
        }
    }

    public void writeDescription(BufferedWriter writer) throws IOException {
        if (this.description_ != null && this.description_.trim().length() > 0) {
            writer.write("<DESCRIPTION>");
            writer.newLine();
            writer.write(VOSerializer.formatText(this.description_.trim()));
            writer.newLine();
            writer.write("</DESCRIPTION>");
            writer.newLine();
        }
    }

    public void writePreDataXML(BufferedWriter writer) throws IOException {
        long nrow;
        writer.write("<TABLE");
        String tname = this.getTable().getName();
        if (tname != null && tname.trim().length() > 0) {
            writer.write(VOSerializer.formatAttribute("name", tname.trim()));
        }
        if ((nrow = this.getTable().getRowCount()) > 0L) {
            writer.write(VOSerializer.formatAttribute("nrows", Long.toString(nrow)));
        }
        if (this.ucd_ != null) {
            writer.write(VOSerializer.formatAttribute("ucd", this.ucd_));
        }
        if (this.utype_ != null) {
            writer.write(VOSerializer.formatAttribute("utype", this.utype_));
        }
        writer.write(">");
        writer.newLine();
        this.writeDescription(writer);
        this.writeParams(writer);
        this.writeFields(writer);
    }

    public void writePostDataXML(BufferedWriter writer) throws IOException {
        writer.write("</TABLE>");
        writer.newLine();
    }

    public static String formatAttribute(String name, String value) {
        return ' ' + name + '=' + '\"' + value.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;") + '\"';
    }

    public static String formatText(String text) {
        int leng = text.length();
        StringBuffer sbuf = new StringBuffer(leng);
        block5: for (int i = 0; i < leng; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    sbuf.append("&lt;");
                    continue block5;
                }
                case '>': {
                    sbuf.append("&gt;");
                    continue block5;
                }
                case '&': {
                    sbuf.append("&amp;");
                    continue block5;
                }
                default: {
                    sbuf.append(c);
                }
            }
        }
        return sbuf.toString();
    }

    private static String formatAttributes(Map atts) {
        StringBuffer sbuf = new StringBuffer();
        Iterator it = new TreeSet(atts.keySet()).iterator();
        while (it.hasNext()) {
            String attname = (String)it.next();
            String attval = (String)atts.get(attname);
            sbuf.append(VOSerializer.formatAttribute(attname, attval));
        }
        return sbuf.toString();
    }

    private static void writeFieldElement(BufferedWriter writer, String content, Map attributes) throws IOException {
        writer.write("<FIELD" + VOSerializer.formatAttributes(attributes));
        if (content != null && content.length() > 0) {
            writer.write(62);
            writer.write(content);
            writer.newLine();
            writer.write("</FIELD>");
        } else {
            writer.write("/>");
        }
        writer.newLine();
    }

    private static StarTable prepareForSerializer(StarTable table) {
        ValueInfo badKey = Tables.NULL_VALUE_INFO;
        int ncol = table.getColumnCount();
        final ColumnInfo[] colInfos = new ColumnInfo[ncol];
        int modified = 0;
        for (int icol = 0; icol < ncol; ++icol) {
            Number badValue;
            ColumnInfo cinfo = new ColumnInfo(table.getColumnInfo(icol));
            Class clazz = cinfo.getContentClass();
            if (cinfo.isNullable() && (class$java$lang$Number == null ? VOSerializer.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom(clazz) && cinfo.getAuxDatum(badKey) == null && (badValue = clazz == (class$java$lang$Byte == null ? VOSerializer.class$("java.lang.Byte") : class$java$lang$Byte) || clazz == (class$java$lang$Short == null ? VOSerializer.class$("java.lang.Short") : class$java$lang$Short) ? (Number)new Short(Short.MIN_VALUE) : (Number)(clazz == (class$java$lang$Integer == null ? VOSerializer.class$("java.lang.Integer") : class$java$lang$Integer) ? (Number)new Integer(Integer.MIN_VALUE) : (Number)(clazz == (class$java$lang$Long == null ? VOSerializer.class$("java.lang.Long") : class$java$lang$Long) ? new Long(Long.MIN_VALUE) : null))) != null) {
                ++modified;
                cinfo.getAuxData().add(new DescribedValue(badKey, badValue));
            }
            colInfos[icol] = cinfo;
        }
        if (modified > 0) {
            table = new WrapperStarTable(table){

                public ColumnInfo getColumnInfo(int icol) {
                    return colInfos[icol];
                }
            };
        }
        return table;
    }

    public static VOSerializer makeSerializer(DataFormat dataFormat, StarTable table) throws IOException {
        table = VOSerializer.prepareForSerializer(table);
        if (dataFormat == DataFormat.TABLEDATA) {
            return new TabledataVOSerializer(table);
        }
        if (dataFormat == DataFormat.FITS) {
            return new FITSVOSerializer(table, (FitsTableSerializer)new StandardFitsTableSerializer(table));
        }
        if (dataFormat == DataFormat.BINARY) {
            return new BinaryVOSerializer(table);
        }
        throw new AssertionError((Object)("No such format " + dataFormat.toString()));
    }

    public static VOSerializer makeFitsSerializer(StarTable table, FitsTableSerializer fitser) throws IOException {
        table = VOSerializer.prepareForSerializer(table);
        return new FITSVOSerializer(table, fitser);
    }

    private static Encoder[] getEncoders(StarTable table) {
        int ncol = table.getColumnCount();
        Encoder[] encoders = new Encoder[ncol];
        for (int icol = 0; icol < ncol; ++icol) {
            ColumnInfo info = table.getColumnInfo(icol);
            encoders[icol] = Encoder.getEncoder(info);
            if (encoders[icol] != null) continue;
            logger.warning("Can't serialize column " + info + " of type " + info.getContentClass().getName());
        }
        return encoders;
    }

    private static void outputFields(Encoder[] encoders, StarTable table, BufferedWriter writer) throws IOException {
        int ncol = encoders.length;
        for (int icol = 0; icol < ncol; ++icol) {
            Encoder encoder = encoders[icol];
            if (encoder != null) {
                String content = encoder.getFieldContent();
                Map atts = encoder.getFieldAttributes();
                VOSerializer.writeFieldElement(writer, content, atts);
                continue;
            }
            writer.write("<!-- Omitted column " + table.getColumnInfo(icol) + " -->");
            writer.newLine();
        }
    }

    private static class WriterOutputStream
    extends OutputStream {
        Writer writer;
        static final int BUFLENG = 10240;
        char[] mainBuf = new char[10240];

        WriterOutputStream(Writer writer) {
            this.writer = writer;
        }

        public void close() throws IOException {
            this.writer.close();
        }

        public void flush() throws IOException {
            this.writer.flush();
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            char[] buf = len <= 10240 ? this.mainBuf : new char[len];
            for (int i = 0; i < len; ++i) {
                buf[i] = (char)b[off++];
            }
            this.writer.write(buf, 0, len);
        }

        public void write(int b) throws IOException {
            this.writer.write(b);
        }
    }

    private static class FITSVOSerializer
    extends StreamableVOSerializer {
        private final FitsTableSerializer fitser;

        FITSVOSerializer(StarTable table, FitsTableSerializer fitser) throws IOException {
            super(table, DataFormat.FITS, "FITS");
            this.fitser = fitser;
        }

        /*
         * WARNING - void declaration
         */
        public void writeFields(BufferedWriter writer) throws IOException {
            int ncol = this.getTable().getColumnCount();
            for (int icol = 0; icol < ncol; ++icol) {
                char tform = this.fitser.getFormatChar(icol);
                int[] dims = this.fitser.getDimensions(icol);
                String badval = this.fitser.getBadValue(icol);
                if (dims != null) {
                    void var10_10;
                    Encoder encoder = Encoder.getEncoder(this.getTable().getColumnInfo(icol));
                    String content = encoder.getFieldContent();
                    Map atts = encoder.getFieldAttributes();
                    switch (tform) {
                        case 'L': {
                            String datatype = "boolean";
                            break;
                        }
                        case 'X': {
                            String datatype = "bit";
                            break;
                        }
                        case 'B': {
                            String datatype = "unsignedByte";
                            break;
                        }
                        case 'I': {
                            String datatype = "short";
                            break;
                        }
                        case 'J': {
                            String datatype = "int";
                            break;
                        }
                        case 'K': {
                            String datatype = "long";
                            break;
                        }
                        case 'A': {
                            String datatype = "char";
                            break;
                        }
                        case 'E': {
                            String datatype = "float";
                            break;
                        }
                        case 'D': {
                            String datatype = "double";
                            break;
                        }
                        case 'C': {
                            String datatype = "floatComplex";
                            break;
                        }
                        case 'M': {
                            String datatype = "doubleComplex";
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("Unknown format letter " + tform));
                        }
                    }
                    atts.put("datatype", var10_10);
                    if (dims.length == 0) {
                        if (!"1".equals(atts.get("arraysize"))) {
                            atts.remove("arraysize");
                        }
                    } else {
                        StringBuffer arraysize = new StringBuffer();
                        for (int i = 0; i < dims.length; ++i) {
                            if (i > 0) {
                                arraysize.append('x');
                            }
                            arraysize.append(dims[i]);
                        }
                        atts.put("arraysize", arraysize.toString());
                    }
                    encoder.setNullString(badval);
                    VOSerializer.writeFieldElement(writer, content, atts);
                    continue;
                }
                writer.write("<!-- Omitted column " + this.getTable().getColumnInfo(icol) + " -->");
                writer.newLine();
            }
        }

        public void streamData(DataOutput out) throws IOException {
            FitsConstants.writeEmptyPrimary((DataOutput)out);
            new FitsTableWriter().writeTableHDU(this.getTable(), this.fitser, out);
        }
    }

    private static class BinaryVOSerializer
    extends StreamableVOSerializer {
        private final Encoder[] encoders;

        BinaryVOSerializer(StarTable table) {
            super(table, DataFormat.BINARY, "BINARY");
            this.encoders = VOSerializer.getEncoders(table);
        }

        public void writeFields(BufferedWriter writer) throws IOException {
            VOSerializer.outputFields(this.encoders, this.getTable(), writer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void streamData(DataOutput out) throws IOException {
            int ncol = this.encoders.length;
            RowSequence rseq = this.getTable().getRowSequence();
            try {
                while (rseq.next()) {
                    Object[] row = rseq.getRow();
                    for (int icol = 0; icol < ncol; ++icol) {
                        Encoder encoder = this.encoders[icol];
                        if (encoder == null) continue;
                        encoder.encodeToStream(row[icol], out);
                    }
                }
            }
            finally {
                rseq.close();
            }
        }
    }

    static abstract class StreamableVOSerializer
    extends VOSerializer {
        private final String tagname;

        private StreamableVOSerializer(StarTable table, DataFormat format, String tagname) {
            super(table, format);
            this.tagname = tagname;
        }

        public abstract void streamData(DataOutput var1) throws IOException;

        public void writeInlineDataElement(BufferedWriter writer) throws IOException {
            writer.write("<DATA>");
            writer.newLine();
            writer.write("<" + this.tagname + ">");
            writer.newLine();
            writer.write("<STREAM encoding='base64'>");
            writer.newLine();
            Base64OutputStream b64out = new Base64OutputStream(new WriterOutputStream(writer), 16);
            DataOutputStream dataout = new DataOutputStream(b64out);
            this.streamData(dataout);
            dataout.flush();
            b64out.endBase64();
            writer.write("</STREAM>");
            writer.newLine();
            writer.write("</" + this.tagname + ">");
            writer.newLine();
            writer.write("</DATA>");
            writer.newLine();
        }

        public void writeHrefDataElement(BufferedWriter xmlwriter, String href, DataOutput streamout) throws IOException {
            xmlwriter.write("<DATA>");
            xmlwriter.newLine();
            xmlwriter.write('<' + this.tagname + '>');
            xmlwriter.newLine();
            xmlwriter.write("<STREAM" + StreamableVOSerializer.formatAttribute("href", href) + "/>");
            xmlwriter.newLine();
            xmlwriter.write("</" + this.tagname + ">");
            xmlwriter.newLine();
            xmlwriter.write("</DATA>");
            xmlwriter.newLine();
            this.streamData(streamout);
        }
    }

    private static class TabledataVOSerializer
    extends VOSerializer {
        private final Encoder[] encoders;

        TabledataVOSerializer(StarTable table) {
            super(table, DataFormat.TABLEDATA);
            this.encoders = VOSerializer.getEncoders(table);
        }

        public void writeFields(BufferedWriter writer) throws IOException {
            VOSerializer.outputFields(this.encoders, this.getTable(), writer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeInlineDataElement(BufferedWriter writer) throws IOException {
            writer.write("<DATA>");
            writer.newLine();
            writer.write("<TABLEDATA>");
            writer.newLine();
            int ncol = this.encoders.length;
            RowSequence rseq = this.getTable().getRowSequence();
            try {
                while (rseq.next()) {
                    writer.write("  <TR>");
                    writer.newLine();
                    Object[] rowdata = rseq.getRow();
                    for (int icol = 0; icol < ncol; ++icol) {
                        Encoder encoder = this.encoders[icol];
                        if (encoder == null) continue;
                        String text = encoder.encodeAsText(rowdata[icol]);
                        writer.write("    <TD>");
                        writer.write(TabledataVOSerializer.formatText(text));
                        writer.write("</TD>");
                        writer.newLine();
                    }
                    writer.write("  </TR>");
                    writer.newLine();
                }
            }
            finally {
                rseq.close();
            }
            writer.write("</TABLEDATA>");
            writer.newLine();
            writer.write("</DATA>");
            writer.newLine();
            writer.flush();
        }

        public void writeHrefDataElement(BufferedWriter writer, String href, DataOutput streamout) {
            throw new UnsupportedOperationException("TABLEDATA only supports inline output");
        }
    }
}

