/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.IOException;
import java.net.URL;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import uk.ac.starlink.fits.FitsTableBuilder;
import uk.ac.starlink.table.RowStore;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.votable.Decoder;
import uk.ac.starlink.votable.SkeletonDOMBuilder;
import uk.ac.starlink.votable.TableBodies;
import uk.ac.starlink.votable.TableElement;
import uk.ac.starlink.votable.TableHandler;

class VOTableDOMBuilder
extends SkeletonDOMBuilder
implements TableHandler {
    private final StoragePolicy storagePolicy_;
    private RowStore rowStore_;

    public VOTableDOMBuilder(StoragePolicy storagePolicy, boolean strict) {
        super(strict);
        this.storagePolicy_ = storagePolicy;
        this.setTableHandler(this);
    }

    public Document getDocument() {
        return super.getDocument();
    }

    protected void processBinaryHref(URL url, Attributes atts) {
        TableElement tableEl = this.getTableElement();
        if (tableEl != null) {
            String encoding = this.getAttribute(atts, "encoding");
            Decoder[] decoders = SkeletonDOMBuilder.getDecoders(tableEl.getFields());
            TableBodies.HrefBinaryTabularData tdata = new TableBodies.HrefBinaryTabularData(decoders, url, encoding);
            tableEl.setData(tdata);
        }
    }

    protected void processFitsHref(URL url, String extnum, Attributes atts) throws SAXException {
        TableElement tableEl = this.getTableElement();
        if (tableEl != null) {
            try {
                DataSource datsrc = DataSource.makeDataSource(url);
                datsrc.setPosition(extnum);
                StarTable startab = new FitsTableBuilder().makeStarTable(datsrc, false, this.storagePolicy_);
                TableBodies.StarTableTabularData tdata = new TableBodies.StarTableTabularData(startab);
                tableEl.setData(tdata);
            }
            catch (IOException e) {
                throw (SAXException)new SAXParseException(e.getMessage(), this.getLocator()).initCause(e);
            }
        }
    }

    public void startTable(StarTable meta) throws SAXException {
        this.rowStore_ = this.storagePolicy_.makeConfiguredRowStore(meta);
    }

    public void rowData(Object[] row) throws SAXException {
        try {
            this.rowStore_.acceptRow(row);
        }
        catch (IOException e) {
            throw (SAXException)new SAXParseException(e.getMessage(), this.getLocator()).initCause(e);
        }
    }

    public void endTable() throws SAXException {
        try {
            this.rowStore_.endRows();
            TableElement tableEl = this.getTableElement();
            if (tableEl != null) {
                StarTable st = this.rowStore_.getStarTable();
                tableEl.setData(new TableBodies.StarTableTabularData(st));
            }
        }
        catch (IOException e) {
            throw (SAXException)new SAXParseException(e.getMessage(), this.getLocator()).initCause(e);
        }
        this.rowStore_ = null;
    }
}

