/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardException;
import nom.tam.util.Cursor;
import uk.ac.starlink.fits.AbstractFitsTableWriter;
import uk.ac.starlink.fits.FitsConstants;
import uk.ac.starlink.fits.FitsTableSerializer;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.votable.VOSerializer;

public abstract class VOTableFitsTableWriter
extends AbstractFitsTableWriter {
    private static String XML_ENCODING;
    private static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected VOTableFitsTableWriter(String formatName) {
        super(formatName);
    }

    public void writePrimaryHDU(StarTable table, FitsTableSerializer fitser, DataOutput strm) throws IOException {
        Exception thrown = null;
        try {
            this.writeVOTablePrimary(table, fitser, strm);
            return;
        }
        catch (IOException e) {
            thrown = e;
        }
        catch (FitsException e) {
            thrown = e;
        }
        if (!$assertionsDisabled && thrown == null) {
            throw new AssertionError();
        }
        logger.log(Level.WARNING, "Failed to write VOTable metadata to primary HDU", thrown);
        FitsConstants.writeEmptyPrimary((DataOutput)strm);
    }

    private void writeVOTablePrimary(StarTable table, FitsTableSerializer fitser, DataOutput out) throws IOException, FitsException {
        long nrow;
        VOSerializer voser = VOSerializer.makeFitsSerializer(table, fitser);
        StringWriter textWriter = new StringWriter();
        BufferedWriter writer = new BufferedWriter(textWriter);
        writer.write("<?xml version='1.0' encoding='" + XML_ENCODING + "'?>");
        writer.newLine();
        writer.write("<VOTABLE version='1.1'>");
        writer.newLine();
        writer.write("<!--");
        writer.newLine();
        writer.write(" !  VOTable written by " + VOSerializer.formatText(((Object)((Object)this)).getClass().getName()));
        writer.newLine();
        writer.write(" !  Describes BINTABLE extension in following HDU");
        writer.newLine();
        writer.write(" !-->");
        writer.newLine();
        writer.write("<RESOURCE>");
        writer.newLine();
        voser.writeDescription(writer);
        voser.writeParams(writer);
        writer.write("<TABLE");
        String tname = table.getName();
        if (tname != null && tname.trim().length() > 0) {
            writer.write(VOSerializer.formatAttribute("name", tname.trim()));
        }
        if ((nrow = fitser.getRowCount()) > 0L) {
            writer.write(VOSerializer.formatAttribute("nrows", Long.toString(nrow)));
        }
        writer.write(">");
        writer.newLine();
        voser.writeFields(writer);
        writer.write("<!-- Dummy VOTable - no DATA element -->");
        writer.newLine();
        writer.write("</TABLE>");
        writer.newLine();
        writer.write("</RESOURCE>");
        writer.newLine();
        writer.write("</VOTABLE>");
        writer.flush();
        byte[] textBytes = textWriter.getBuffer().toString().getBytes(XML_ENCODING);
        int nbyte = textBytes.length;
        Header hdr = new Header();
        hdr.addValue("SIMPLE", true, "Standard FITS format");
        hdr.addValue("BITPIX", 8L, "Character data");
        hdr.addValue("NAXIS", 1L, "Text string");
        hdr.addValue("NAXIS1", nbyte, "Number of characters");
        this.customisePrimaryHeader(hdr);
        hdr.addValue("EXTEND", true, "There are standard extensions");
        String[] comments = new String[]{" ", "The data in this primary HDU consists of bytes which", "comprise a VOTABLE document.", "The VOTable describes the metadata of the table contained", "in the following BINTABLE extension.", "The BINTABLE extension can be used on its own as a perfectly", "good table, but the information from this HDU may provide some", "useful additional metadata."};
        for (int i = 0; i < comments.length; ++i) {
            hdr.insertComment(comments[i]);
        }
        hdr.insertCommentStyle("END", "");
        if (!$assertionsDisabled && !this.primaryHeaderOK(hdr)) {
            throw new AssertionError();
        }
        FitsConstants.writeHeader((DataOutput)out, (Header)hdr);
        out.write(textBytes);
        int partial = textBytes.length % 2880;
        if (partial > 0) {
            int pad = 2880 - partial;
            out.write(new byte[pad]);
        }
    }

    protected abstract void customisePrimaryHeader(Header var1) throws HeaderCardException;

    private boolean primaryHeaderOK(Header hdr) {
        boolean ok = true;
        ByteArrayOutputStream bstrm = new ByteArrayOutputStream();
        Cursor it = hdr.iterator();
        while (it.hasNext()) {
            String card = ((HeaderCard)it.next()).toString();
            ok = ok && card.length() == 80;
            for (int i = 0; i < card.length(); ++i) {
                bstrm.write((byte)card.charAt(i));
            }
        }
        return ok && this.isMagic(bstrm.toByteArray());
    }

    public boolean isMagic(byte[] buffer) {
        int ntest = 36;
        int pos = 0;
        boolean ncard = false;
        for (int il = 0; il < 36 && buffer.length > pos + 80; ++il) {
            char[] cbuf = new char[80];
            for (int ic = 0; ic < 80; ++ic) {
                cbuf[ic] = (char)(buffer[pos++] & 0xFF);
            }
            HeaderCard card = new HeaderCard(new String(cbuf));
            if (this.isMagic(il, card.getKey(), card.getValue())) continue;
            return false;
        }
        return true;
    }

    protected boolean isMagic(int icard, String key, String value) {
        switch (icard) {
            case 0: {
                return "SIMPLE".equals(key) && "T".equals(value);
            }
            case 1: {
                return "BITPIX".equals(key) && "8".equals(value);
            }
            case 2: {
                return "NAXIS".equals(key) && "1".equals(value);
            }
            case 3: {
                return "NAXIS1".equals(key);
            }
        }
        return true;
    }

    static {
        $assertionsDisabled = !VOTableFitsTableWriter.class.desiredAssertionStatus();
        XML_ENCODING = "UTF-8";
        logger = Logger.getLogger("uk.ac.starlink.votable");
    }
}

