/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import uk.ac.starlink.fits.FitsTableBuilder;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.votable.BinaryRowSequence;
import uk.ac.starlink.votable.Decoder;
import uk.ac.starlink.votable.SkeletonDOMBuilder;
import uk.ac.starlink.votable.TableElement;
import uk.ac.starlink.votable.TableHandler;
import uk.ac.starlink.votable.TableHandlerSink;

class VOTableParser
extends SkeletonDOMBuilder {
    private boolean readHrefs_;

    public VOTableParser(boolean strict) {
        super(strict);
    }

    public void setReadHrefTables(boolean readHrefs) {
        this.readHrefs_ = readHrefs;
    }

    public boolean getReadHrefTables() {
        return this.readHrefs_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processBinaryHref(URL url, Attributes atts) throws SAXException {
        TableHandler tableHandler = this.getTableHandler();
        TableElement tableEl = this.getTableElement();
        if (!this.getReadHrefTables()) return;
        if (tableHandler == null) return;
        if (tableEl == null) return;
        InputStream in = null;
        try {
            try {
                in = url.openStream();
                tableHandler.startTable(tableEl.getMetadataTable());
                Decoder[] decoders = VOTableParser.getDecoders(tableEl.getFields());
                String encoding = this.getAttribute(atts, "encoding");
                BinaryRowSequence rseq = new BinaryRowSequence(decoders, in, encoding);
                try {
                    while (rseq.next()) {
                        tableHandler.rowData(rseq.getRow());
                    }
                }
                finally {
                    rseq.close();
                }
                tableHandler.endTable();
            }
            catch (IOException e) {
                if (!(e.getCause() instanceof SAXException)) throw (SAXException)new SAXParseException(e.getMessage(), this.getLocator()).initCause(e);
                throw (SAXException)e.getCause();
            }
            Object var11_11 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        in.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processFitsHref(URL url, String extnum, Attributes atts) throws SAXException {
        TableHandler tableHandler = this.getTableHandler();
        TableElement tableEl = this.getTableElement();
        if (!this.getReadHrefTables()) return;
        if (tableHandler == null) return;
        if (tableEl == null) return;
        InputStream in = null;
        try {
            try {
                TableHandlerSink sink = new TableHandlerSink(tableHandler, tableEl.getMetadataTable());
                in = url.openStream();
                new FitsTableBuilder().streamStarTable(in, (TableSink)sink, extnum);
            }
            catch (IOException e) {
                if (!(e.getCause() instanceof SAXException)) throw (SAXException)new SAXParseException(e.getMessage(), this.getLocator()).initCause(e);
                throw (SAXException)e.getCause();
            }
            Object var9_9 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        in.close();
        return;
    }
}

