/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet;

import JSci.maths.ArrayMath;
import JSci.maths.EngineerMath;
import JSci.maths.NumericalConstants;
import JSci.maths.wavelet.FWTCoef;
import JSci.maths.wavelet.Filter;
import JSci.maths.wavelet.Signal;

public final class FWTPacketCoef
implements NumericalConstants,
Cloneable {
    protected double[][] coefs;
    protected boolean[] StandardChoice;
    static final double normalisation = 0.7071067811865475;

    public FWTPacketCoef() {
    }

    public FWTPacketCoef(double[][] dArray, boolean[] blArray) {
        this.coefs = dArray;
        this.StandardChoice = blArray;
        if (blArray.length != dArray.length - 1) {
            throw new IllegalArgumentException("boolean[].length must be exactly double[][].length -1: boolean[].length=" + blArray.length + " and double[][].length=" + dArray.length);
        }
    }

    public Object clone() {
        try {
            FWTPacketCoef fWTPacketCoef = (FWTPacketCoef)super.clone();
            if (this.coefs != null) {
                fWTPacketCoef.coefs = ArrayMath.copy((double[][])this.coefs);
            }
            if (this.StandardChoice != null) {
                fWTPacketCoef.StandardChoice = new boolean[this.StandardChoice.length];
                System.arraycopy(this.StandardChoice, 0, fWTPacketCoef.StandardChoice, 0, this.StandardChoice.length);
            }
            return fWTPacketCoef;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public int getJ() {
        return this.coefs.length;
    }

    public int dimension(int n) {
        if (n < 0 || n >= this.coefs.length) {
            throw new IllegalArgumentException("This scale doesn't exist : " + n + ", " + this.coefs.length);
        }
        return this.coefs[n].length;
    }

    public double[][] getCoefs() {
        return this.coefs;
    }

    public double[] norm() {
        double[] dArray = new double[this.coefs.length];
        int n = 0;
        while (n < this.coefs.length) {
            dArray[n] = ArrayMath.norm((double[])this.coefs[n]);
            ++n;
        }
        return dArray;
    }

    public double norm(int n) {
        if (n < 0 || n >= this.coefs.length) {
            throw new IllegalArgumentException("The integer parameter " + n + " should be between 0 and " + (this.coefs.length - 1));
        }
        double d = ArrayMath.norm((double[])this.coefs[n]);
        return d;
    }

    private double[] sumSquares() {
        double[] dArray = new double[this.coefs.length];
        int n = 0;
        while (n < this.coefs.length) {
            dArray[n] = ArrayMath.sumSquares((double[])this.coefs[n]);
            ++n;
        }
        return dArray;
    }

    public double sumSquares(int n) {
        if (n < 0 || n >= this.coefs.length) {
            throw new IllegalArgumentException("The integer parameter " + n + " must be between 0 et " + (this.coefs.length - 1));
        }
        double d = ArrayMath.sumSquares((double[])this.coefs[n]);
        return d;
    }

    public double mass(int n) {
        if (n < 0 || n >= this.coefs.length) {
            throw new IllegalArgumentException("The integer parameter " + n + " should be between 0 and " + (this.coefs.length - 1));
        }
        double d = ArrayMath.mass((double[])this.coefs[n]);
        return d;
    }

    private double[] variance() {
        double[] dArray = new double[this.coefs.length];
        int n = 0;
        while (n < this.coefs.length) {
            dArray[n] = ArrayMath.variance((double[])this.coefs[n]);
            ++n;
        }
        return dArray;
    }

    public double variance(int n) {
        if (n < 0 || n >= this.coefs.length) {
            throw new IllegalArgumentException("The integer parameter " + n + " should be between 0 and " + (this.coefs.length - 1));
        }
        double d = ArrayMath.variance((double[])this.coefs[n]);
        return d;
    }

    public double sumEnergies() {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        double[] dArray = this.sumSquares();
        double d = 0.0;
        int n = 0;
        while (n < dArray.length) {
            d += dArray[n];
            ++n;
        }
        return d;
    }

    public double entropy() {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        double d = this.sumEnergies();
        int n = 0;
        int n2 = 0;
        while (n2 < this.coefs.length) {
            n += this.coefs[n2].length;
            ++n2;
        }
        double[] dArray = new double[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.coefs.length) {
            int n5 = 0;
            while (n5 < this.coefs[n4].length) {
                dArray[n3] = this.coefs[n4][n5] * this.coefs[n4][n5] / d;
                ++n3;
                ++n5;
            }
            ++n4;
        }
        return EngineerMath.icf((double[])dArray);
    }

    public double sumVariance() {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        double[] dArray = this.variance();
        double d = 0.0;
        int n = 0;
        while (n < dArray.length) {
            d += dArray[n];
            ++n;
        }
        return d;
    }

    public double energyRatio(int n) {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        if (n < 0 || n >= this.coefs.length) {
            throw new IllegalArgumentException("The integer parameter " + n + " should be between 0 and " + (this.coefs.length - 1));
        }
        if (this.sumEnergies() == 0.0) {
            if (this.coefs.length != 0) {
                return 1 / this.coefs.length;
            }
            throw new IllegalArgumentException("No energy!");
        }
        return this.sumSquares(n) / this.sumEnergies();
    }

    public double varianceRatio(int n) {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        if (n < 0 || n >= this.coefs.length) {
            throw new IllegalArgumentException("The integer parament " + n + " should be between 0 and " + (this.coefs.length - 1));
        }
        if (this.sumVariance() == 0.0) {
            if (this.coefs.length != 0) {
                return 1 / this.coefs.length;
            }
            throw new IllegalArgumentException("No variance!");
        }
        return this.variance(n) / this.sumVariance();
    }

    public double icf() {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        double[] dArray = new double[this.coefs.length - 1];
        int n = 0;
        while (n < this.coefs.length) {
            dArray[n] = this.energyRatio(n);
            ++n;
        }
        return EngineerMath.icf((double[])dArray);
    }

    public double varianceICF() {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        double[] dArray = new double[this.coefs.length - 1];
        int n = 0;
        while (n < this.coefs.length) {
            dArray[n] = this.varianceRatio(n);
            ++n;
        }
        return EngineerMath.icf((double[])dArray);
    }

    public void setCoefs(double[][] dArray) {
        this.coefs = dArray;
    }

    public void setPacket(boolean[] blArray) {
        this.StandardChoice = blArray;
    }

    public void setCoefs(double[] dArray, int n) {
        if (n < 0 || n >= this.coefs.length) {
            throw new IllegalArgumentException("The integer parameter " + n + " should be between 0 and " + (this.coefs.length - 1));
        }
        this.coefs[n] = dArray;
    }

    public void synthesize(Filter filter, double[] dArray) {
        double[] dArray2;
        double[] dArray3;
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No synthesis left to do: " + this.coefs.length);
        }
        if (this.StandardChoice[this.StandardChoice.length - 1]) {
            dArray3 = filter.lowpass(this.coefs[this.coefs.length - 1], dArray);
            dArray3 = ArrayMath.scalarMultiply((double)0.7071067811865475, (double[])dArray3);
            dArray2 = filter.highpass(this.coefs[this.coefs.length - 2], dArray);
        } else {
            dArray3 = filter.lowpass(this.coefs[this.coefs.length - 2], dArray);
            dArray3 = ArrayMath.scalarMultiply((double)0.7071067811865475, (double[])dArray3);
            dArray2 = filter.highpass(this.coefs[this.coefs.length - 1], dArray);
        }
        if (dArray3.length != dArray2.length) {
            throw new IllegalArgumentException("Synthesis is impossible : bad data/multiresolution? " + this.coefs[0].length + ", " + this.coefs[this.coefs.length - 1].length + ", " + dArray3.length + ", " + dArray2.length);
        }
        dArray3 = ArrayMath.add((double[])dArray3, (double[])dArray2);
        double[][] dArrayArray = new double[this.coefs.length - 1][];
        int n = 0;
        while (n < this.coefs.length - 2) {
            dArrayArray[n] = this.coefs[n];
            ++n;
        }
        dArrayArray[this.coefs.length - 1] = dArray3;
        this.coefs = dArrayArray;
        boolean[] blArray = new boolean[dArrayArray.length - 1];
        int n2 = 0;
        while (n2 < blArray.length) {
            blArray[n2] = this.StandardChoice[n2];
            ++n2;
        }
        this.StandardChoice = blArray;
    }

    public void synthesize(Filter filter, double[] dArray, int n) {
        if (n < 0 || n > this.coefs.length - 1) {
            throw new IllegalArgumentException("The integer parameter " + n + " must be between 0 and " + (this.coefs.length - 1));
        }
        int n2 = 0;
        while (n2 < n) {
            this.synthesize(filter, dArray);
            ++n2;
        }
    }

    public void synthesizeTout(Filter filter, double[] dArray) {
        this.synthesize(filter, dArray, this.coefs.length - 1);
    }

    public void synthesize(Filter filter) {
        double[] dArray;
        double[] dArray2;
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No synthesis left to do: " + this.coefs.length);
        }
        if (this.StandardChoice[this.StandardChoice.length - 1]) {
            dArray2 = filter.lowpass(this.coefs[this.coefs.length - 1]);
            dArray2 = ArrayMath.scalarMultiply((double)0.7071067811865475, (double[])dArray2);
            dArray = filter.highpass(this.coefs[this.coefs.length - 2]);
        } else {
            dArray2 = filter.lowpass(this.coefs[this.coefs.length - 2]);
            dArray2 = ArrayMath.scalarMultiply((double)0.7071067811865475, (double[])dArray2);
            dArray = filter.highpass(this.coefs[this.coefs.length - 1]);
        }
        if (dArray2.length != dArray.length) {
            throw new IllegalArgumentException("Synthesis is impossible : bad data/multiresolution? " + this.coefs[0].length + ", " + this.coefs[this.coefs.length - 1].length + ", " + dArray2.length + ", " + dArray.length);
        }
        dArray2 = ArrayMath.add((double[])dArray2, (double[])dArray);
        double[][] dArrayArray = new double[this.coefs.length - 1][];
        int n = 0;
        while (n < this.coefs.length - 2) {
            dArrayArray[n] = this.coefs[n];
            ++n;
        }
        dArrayArray[this.coefs.length - 1] = dArray2;
        this.coefs = dArrayArray;
        boolean[] blArray = new boolean[dArrayArray.length - 1];
        int n2 = 0;
        while (n2 < blArray.length) {
            blArray[n2] = this.StandardChoice[n2];
            ++n2;
        }
        this.StandardChoice = blArray;
    }

    public void synthesize(Filter filter, int n) {
        if (n < 0 || n > this.coefs.length - 1) {
            throw new IllegalArgumentException("The integer parameter " + n + " must be between 0 and " + (this.coefs.length - 1));
        }
        int n2 = 0;
        while (n2 < n) {
            this.synthesize(filter);
            ++n2;
        }
    }

    public void synthesizeAll(Filter filter) {
        this.synthesize(filter, this.coefs.length - 1);
    }

    public Signal rebuildSignal(Filter filter) {
        FWTCoef fWTCoef = new FWTCoef(this.coefs);
        fWTCoef.synthesizeAll(filter);
        return new Signal(fWTCoef.getCoefs()[0]);
    }

    public Signal rebuildSignal(Filter filter, double[] dArray) {
        FWTCoef fWTCoef = new FWTCoef(this.coefs);
        fWTCoef.synthesizeAll(filter, dArray);
        return new Signal(fWTCoef.getCoefs()[0]);
    }

    public void denoise(double d) {
        int n = 1;
        while (n < this.coefs.length) {
            this.coefs[n] = FWTPacketCoef.denoise(this.coefs[n], d);
            ++n;
        }
    }

    public void denoise(double d, int n) {
        this.coefs[n] = FWTPacketCoef.denoise(this.coefs[n], d);
    }

    public static double[] denoise(double[] dArray, double d) {
        if (d == 0.0) {
            return dArray;
        }
        double[] dArray2 = dArray;
        double d2 = ArrayMath.percentile((double[])ArrayMath.abs((double[])dArray2), (double)(1.0 - d));
        int n = 0;
        while (n < dArray2.length) {
            if (Math.abs(dArray2[n]) >= d2) {
                dArray2[n] = 0.0;
            }
            ++n;
        }
        return dArray2;
    }

    public void compress(double d) {
        int n = 0;
        while (n < this.coefs.length) {
            this.coefs[n] = FWTPacketCoef.compress(this.coefs[n], d);
            ++n;
        }
    }

    public void compress(double d, int n) {
        this.coefs[n] = FWTPacketCoef.compress(this.coefs[n], d);
    }

    public static double[] compress(double[] dArray, double d) {
        if (d == 0.0) {
            return dArray;
        }
        double[] dArray2 = dArray;
        double d2 = ArrayMath.percentile((double[])ArrayMath.abs((double[])dArray2), (double)d);
        int n = 0;
        while (n < dArray2.length) {
            if (Math.abs(dArray2[n]) <= d2) {
                dArray2[n] = 0.0;
            }
            ++n;
        }
        return dArray2;
    }

    public void denoiseHard(double d) {
        int n = 0;
        while (n < this.coefs.length) {
            this.coefs[n] = FWTPacketCoef.denoiseHard(this.coefs[n], d);
            ++n;
        }
    }

    public void denoiseHard(double d, int n) {
        this.coefs[n] = FWTPacketCoef.denoiseHard(this.coefs[n], d);
    }

    public static double[] denoiseHard(double[] dArray, double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("The cutoff value must be positive.");
        }
        double[] dArray2 = dArray;
        int n = 0;
        while (n < dArray2.length) {
            if (Math.abs(dArray2[n]) >= d) {
                dArray2[n] = 0.0;
            }
            ++n;
        }
        return dArray2;
    }

    public void compressHard(double d) {
        int n = 0;
        while (n < this.coefs.length) {
            this.coefs[n] = FWTPacketCoef.compressHard(this.coefs[n], d);
            ++n;
        }
    }

    public void compressHard(double d, int n) {
        this.coefs[n] = FWTPacketCoef.compressHard(this.coefs[n], d);
    }

    public static double[] compressHard(double[] dArray, double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("The cutoff value must be positive.");
        }
        double[] dArray2 = dArray;
        int n = 0;
        while (n < dArray2.length) {
            if (Math.abs(dArray2[n]) <= d) {
                dArray2[n] = 0.0;
            }
            ++n;
        }
        return dArray2;
    }
}

