/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.cdf2_4;

import JSci.maths.wavelet.FWT;

public class FastCDF2_4
extends FWT {
    static int FilterType = 1;
    static final float[] scale = new float[]{0.03314563f, -0.06629126f, -0.17677669f, 0.41984466f, 0.9943689f, 0.41984466f, -0.17677669f, -0.06629126f, 0.03314563f};
    static final float[] wavelet = new float[]{-0.5f, 1.0f, -0.5f};
    static final float[][] scaleLeft = new float[][]{{1.0275146f, 0.77339804f, -0.22097087f, -0.3314563f, 0.16572815f}, {-0.22189158f, 0.44378316f, 0.90229774f, 0.58004856f, -0.25687864f, -0.06629126f, 0.03314563f}, {0.07549838f, -0.15099676f, -0.09575404f, 0.34250486f, 1.0330389f, 0.41984466f, -0.17677669f, -0.06629126f, 0.03314563f}, {-0.013810679f, 0.027621359f, 0.011048543f, -0.049718447f, -0.18506311f, 0.41984466f, 0.9943689f, 0.41984466f, -0.17677669f, -0.06629126f, 0.03314563f}};
    static final float[][] scaleRight = new float[][]{{0.03314563f, -0.06629126f, -0.17677669f, 0.41984466f, 0.9943689f, 0.41984466f, -0.18506311f, -0.049718447f, 0.011048543f, 0.027621359f, -0.013810679f}, {0.03314563f, -0.06629126f, -0.17677669f, 0.41984466f, 1.0330389f, 0.34250486f, -0.09575404f, -0.15099676f, 0.07549838f}, {0.03314563f, -0.06629126f, -0.25687864f, 0.58004856f, 0.90229774f, 0.44378316f, -0.22189158f}, {0.16572815f, -0.3314563f, -0.22097087f, 0.77339804f, 1.0275146f}};
    static final float[] scalePrimary = new float[]{0.35355338f, 0.70710677f, 0.35355338f};
    static final float[] waveletPrimary = new float[]{0.0234375f, 0.046875f, -0.125f, -0.296875f, 0.703125f, -0.296875f, -0.125f, 0.046875f, 0.0234375f};
    static final float[][] scalePrimaryLeft = new float[][]{{0.70710677f, 0.35355338f}};
    static final float[][] scalePrimaryRight = new float[][]{{0.35355338f, 0.70710677f}};
    static final float[][] waveletPrimaryLeft = new float[][]{{-0.546875f, 0.56966144f, -0.3138021f, -0.103515625f, 0.106770836f, 0.043619793f, -0.01953125f, -0.009765625f}, {0.234375f, -0.087890625f, -0.41015625f, 0.6738281f, -0.2421875f, -0.103515625f, 0.03515625f, 0.017578125f}};
    static final float[][] waveletPrimaryRight = new float[][]{{0.017578125f, 0.03515625f, -0.103515625f, -0.2421875f, 0.6738281f, -0.41015625f, -0.087890625f, 0.234375f}, {-0.009765625f, -0.01953125f, 0.043619793f, 0.106770836f, -0.103515625f, -0.3138021f, 0.56966144f, -0.546875f}};

    public void transform(float[] fArray) {
        int n = fArray.length;
        while (n >= 15) {
            FastCDF2_4.transform(fArray, n);
            n = (n + FilterType) / 2;
        }
    }

    public void invTransform(float[] fArray) {
        int n = fArray.length;
        while (n >= 15) {
            n = n / 2 + FilterType;
        }
        while (2 * n - FilterType <= fArray.length) {
            FastCDF2_4.invTransform(fArray, n);
            n = 2 * n - FilterType;
        }
    }

    public static void transform(float[] fArray, int n) {
        int n2;
        int n3;
        int n4;
        float[] fArray2 = new float[n];
        int n5 = (n + FilterType) / 2;
        if (2 * n5 - FilterType != n) {
            throw new IllegalArgumentException("Illegal subband : " + n + " within array of length " + fArray.length);
        }
        int n6 = 0;
        while (n6 < scaleLeft.length) {
            n4 = 0;
            while (n4 < scaleLeft[n6].length) {
                int n7 = n6;
                fArray2[n7] = fArray2[n7] + scaleLeft[n6][n4] * fArray[n4];
                ++n4;
            }
            ++n6;
        }
        n4 = scaleLeft.length;
        while (n4 < n5 - scaleRight.length) {
            n3 = 0;
            while (n3 < scale.length) {
                int n8 = n4;
                fArray2[n8] = fArray2[n8] + scale[n3] * fArray[2 * n4 + n3 - scaleLeft.length];
                ++n3;
            }
            ++n4;
        }
        n3 = 0;
        while (n3 < scaleRight.length) {
            n2 = 0;
            while (n2 < scaleRight[n3].length) {
                int n9 = n3 + n5 - scaleRight.length;
                fArray2[n9] = fArray2[n9] + scaleRight[n3][n2] * fArray[fArray.length - scaleRight[n3].length + n2];
                ++n2;
            }
            ++n3;
        }
        n2 = 0;
        while (n2 < n5 - FilterType) {
            int n10 = 0;
            while (n10 < wavelet.length) {
                int n11 = n2 + n5;
                fArray2[n11] = fArray2[n11] + wavelet[n10] * fArray[2 * n2 + n10];
                ++n10;
            }
            ++n2;
        }
        System.arraycopy(fArray2, 0, fArray, 0, n);
    }

    public static void invTransform(float[] fArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        float[] fArray2 = new float[2 * n - FilterType];
        int n7 = 0;
        while (n7 < scalePrimaryLeft.length) {
            n6 = 0;
            while (n6 < scalePrimaryLeft[n7].length) {
                int n8 = n6;
                fArray2[n8] = fArray2[n8] + scalePrimaryLeft[n7][n6] * fArray[n7];
                ++n6;
            }
            ++n7;
        }
        n6 = scalePrimaryLeft.length;
        while (n6 < n - scalePrimaryRight.length) {
            n5 = 0;
            while (n5 < scalePrimary.length) {
                int n9 = 2 * n6 - FilterType + n5;
                fArray2[n9] = fArray2[n9] + scalePrimary[n5] * fArray[n6];
                ++n5;
            }
            ++n6;
        }
        n5 = 0;
        while (n5 < scalePrimaryRight.length) {
            n4 = 0;
            while (n4 < scalePrimaryRight[n5].length) {
                int n10 = n4 - scalePrimaryRight[n5].length + fArray2.length;
                fArray2[n10] = fArray2[n10] + scalePrimaryRight[n5][n4] * fArray[n5 + n - scalePrimaryRight.length];
                ++n4;
            }
            ++n5;
        }
        n4 = 0;
        while (n4 < waveletPrimaryLeft.length) {
            n3 = 0;
            while (n3 < waveletPrimaryLeft[n4].length) {
                int n11 = n3;
                fArray2[n11] = fArray2[n11] + waveletPrimaryLeft[n4][n3] * fArray[n4 + n];
                ++n3;
            }
            ++n4;
        }
        n3 = waveletPrimaryLeft.length;
        while (n3 < n - FilterType - waveletPrimaryRight.length) {
            n2 = 0;
            while (n2 < waveletPrimary.length) {
                int n12 = 2 * (n3 - FilterType) - 1 + n2;
                fArray2[n12] = fArray2[n12] + waveletPrimary[n2] * fArray[n3 + n];
                ++n2;
            }
            ++n3;
        }
        n2 = 0;
        while (n2 < waveletPrimaryRight.length) {
            int n13 = 0;
            while (n13 < waveletPrimaryRight[n2].length) {
                int n14 = n13 - waveletPrimaryRight[n2].length + fArray2.length;
                fArray2[n14] = fArray2[n14] + waveletPrimaryRight[n2][n13] * fArray[n2 + 2 * n - FilterType - waveletPrimaryRight.length];
                ++n13;
            }
            ++n2;
        }
        System.arraycopy(fArray2, 0, fArray, 0, fArray2.length);
    }
}

