/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.daubechies2;

import JSci.maths.ArrayMath;
import JSci.maths.NumericalConstants;
import JSci.maths.WaveletMath;
import JSci.maths.wavelet.Cascades;
import JSci.maths.wavelet.Filter;
import JSci.maths.wavelet.IllegalScalingException;
import JSci.maths.wavelet.Multiresolution;
import JSci.maths.wavelet.MultiscaleFunction;
import JSci.maths.wavelet.daubechies2.Scaling2;
import JSci.maths.wavelet.daubechies2.Wavelet2;

public final class Daubechies2
extends Multiresolution
implements Filter,
NumericalConstants {
    protected static final int filtretype = 2;
    protected static final int minlength = 4;
    static final double[] vgtemp = new double[]{0.482962913145, 0.836516303738, 0.224143868042, -0.129409522551};
    static final double[] v0temp = new double[]{0.848528137424, -0.529150262213};
    static final double[] v1temp = new double[]{0.132287565553, 0.212132034356, 0.838525491562, -0.484122918276};
    static final double[] vd0temp = new double[]{0.848528137424, 0.529150262213};
    static final double[] vd1temp = new double[]{-0.132287565553, 0.212132034356, 0.838525491562, 0.484122918276};
    static final double[] vg = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])vgtemp);
    static final double[] vd0 = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])ArrayMath.invert((double[])vd0temp));
    static final double[] vd1 = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])ArrayMath.invert((double[])vd1temp));
    static final double[] v0 = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])v0temp);
    static final double[] v1 = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])v1temp);
    static final double[] phvg = WaveletMath.lowToHigh((double[])vgtemp);
    static final double[] phv0 = new double[]{-0.512347538298, -0.821583836258, 0.216506350947, -0.125};
    static final double[] phvd0temp = new double[]{0.512347538298, -0.821583836258, 0.216506350946, 0.125};
    static final double[] phvd0 = ArrayMath.invert((double[])phvd0temp);

    public int getFilterType() {
        return 2;
    }

    public MultiscaleFunction primaryScaling(int n, int n2) {
        return new Scaling2(n, n2);
    }

    public MultiscaleFunction dualScaling(int n, int n2) {
        return new Scaling2(n, n2);
    }

    public MultiscaleFunction primaryWavelet(int n, int n2) {
        return new Wavelet2(n, n2);
    }

    public MultiscaleFunction dualWavelet(int n, int n2) {
        return new Wavelet2(n, n2);
    }

    public int previousDimension(int n) {
        return Cascades.previousDimension(2, n);
    }

    public double[] lowpass(double[] dArray, double[] dArray2) {
        return this.lowpass(dArray);
    }

    public double[] highpass(double[] dArray, double[] dArray2) {
        return this.highpass(dArray);
    }

    public double[] lowpass(double[] dArray) {
        int n;
        if (dArray.length < 4) {
            throw new IllegalScalingException("The array is not long enough: " + dArray.length + " < " + 4);
        }
        double[] dArray2 = new double[2 * dArray.length - 2];
        int n2 = dArray.length - 1;
        int n3 = 2;
        while (n3 <= n2 - 2) {
            n = -2;
            while (n < 2) {
                int n4 = 2 * n3 + n;
                dArray2[n4] = dArray2[n4] + vg[n + 2] * dArray[n3];
                ++n;
            }
            ++n3;
        }
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[0], (double[])v0, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[1], (double[])v1, (int)0);
        n = dArray2.length - vd0.length;
        int n5 = dArray2.length - vd1.length;
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n2], (double[])vd0, (int)n);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n2 - 1], (double[])vd1, (int)n5);
        return dArray2;
    }

    public double[] highpass(double[] dArray) {
        int n;
        double[] dArray2 = new double[2 * dArray.length + 2];
        int n2 = dArray.length - 1;
        int n3 = 1;
        while (n3 <= n2 - 1) {
            n = -2;
            while (n < 2) {
                int n4 = 2 * n3 + n + 2;
                dArray2[n4] = dArray2[n4] + phvg[n + 2] * dArray[n3];
                ++n;
            }
            ++n3;
        }
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[0], (double[])phv0, (int)0);
        n = dArray2.length - phvd0.length;
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n2], (double[])phvd0, (int)n);
        return dArray2;
    }

    public double[] evalScaling(int n, int n2, int n3) {
        return Cascades.evalScaling(this, n, n3, n2);
    }

    public double[] evalWavelet(int n, int n2, int n3) {
        return Cascades.evalWavelet(this, 2, n, n3, n2);
    }
}

