/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.daubechies6;

import JSci.maths.ArrayMath;
import JSci.maths.NumericalConstants;
import JSci.maths.WaveletMath;
import JSci.maths.wavelet.Cascades;
import JSci.maths.wavelet.Filter;
import JSci.maths.wavelet.IllegalScalingException;
import JSci.maths.wavelet.Multiresolution;
import JSci.maths.wavelet.MultiscaleFunction;
import JSci.maths.wavelet.daubechies6.Scaling6;
import JSci.maths.wavelet.daubechies6.Wavelet6;

public final class Daubechies6
extends Multiresolution
implements Filter,
NumericalConstants {
    protected static final int filtretype = 10;
    protected static final int minlength = 20;
    static final double[] vg = new double[]{0.0217847003266, 0.00493661237185, -0.166863215412, -0.0683231215866, 0.694457972958, 1.11389278393, 0.477904371333, -0.102724969862, -0.0297837512985, 0.06325056266, 0.00249992209279, -0.0110318675094};
    static final double[] v0temp = new double[]{0.8035811728, -0.5951951771};
    static final double[] v1temp = new double[]{0.2409444375, 0.3253023901, 0.8139624945, -0.4166403612};
    static final double[] v2temp = new double[]{-0.1713726513, -0.2313725672, 0.2850349985, 0.2770986033, 0.5575844464, -0.6694543662};
    static final double[] v3temp = new double[]{-0.002876454491, -0.003883540664, -0.05655242446, -0.1151783354, 0.5730520088, 0.4076173301, -0.4430745754, -0.5409776766};
    static final double[] v4temp = new double[]{0.09214100804, 0.1244008388, 0.07306532844, 0.2931573652, -0.1321263657, -0.02417688989, -0.3632781234, 0.06792063579, 0.1887648043, -0.8333645213};
    static final double[] v5temp = new double[]{-0.1061491551, -0.1433134304, -0.26228795, -0.6856964195, 0.2766563635, -0.08836692218, 0.3328884755, 0.1288342707, 0.05008585553, -0.4619028205, 0.00882861031, -0.03895963779};
    static final double[] v6temp = new double[]{-0.02023876977, -0.02732464068, 0.04220601869, 0.04941654301, 0.03803171587, 0.08472554296, 0.1946516826, -0.06992838718, 0.9438761468, 0.1295249721, -0.07015973081, 0.1735085659, 0.004990121912, -0.02202083175};
    static final double[] v7temp = new double[]{0.05456011297, 0.07366235691, -0.1344279366, -0.1735568822, 0.003102530241, -0.1659152277, -0.3869255752, 0.245359629, 0.2217987487, 0.1874151629, 0.7052410111, -0.3333463173, -0.04413043778, 0.104785237, 0.003298337216, -0.01455518125};
    static final double[] v8temp = new double[]{-0.004678407876, -0.006316382647, 3.592640703E-4, -0.006935341643, 0.004493043023, 0.004405183141, 0.02315284183, -0.009374856771, -0.1151952189, -0.04165806865, 0.4741171777, 0.7976083337, 0.3391664841, -0.07534748748, -0.02114679112, 0.04508434214, 0.001768528334, -0.007804311311};
    static final double[] v9temp = new double[]{4.182788817E-5, 5.647240556E-5, -3.442465609E-5, 1.028288644E-6, 1.389588842E-4, 7.12814778E-5, -1.053053091E-4, 2.899067329E-4, 0.01541349274, 0.003547130473, -0.1181216165, -0.04823069885, 0.4910659254, 0.7876202163, 0.3379287356, -0.07263467678, -0.02106028481, 0.04472486618, 0.001767711923, -0.007800708584};
    static final double[] vd0temp = new double[]{0.6512594203, 0.7588551689};
    static final double[] vd1temp = new double[]{-0.06896282953, 0.0591848013, -0.9848250307, 0.1478544768};
    static final double[] vd2temp = new double[]{-0.01667727153, 0.01431265231, 0.1090239805, 0.7126760308, -0.1719730277, 0.6709313982};
    static final double[] vd3temp = new double[]{0.09785571254, -0.08398105097, 0.006834310191, 0.1247808574, 0.07236789907, -0.1108818957, 0.1804007431, 0.9579551851};
    static final double[] vd4temp = new double[]{-0.5378738739, 0.4616103858, 0.02733949616, -0.2535533852, 0.3484637175, 0.3309876136, -0.2950887461, 0.1958019515, 0.06099724771, 0.2691738861};
    static final double[] vd5temp = new double[]{-0.2335808916, 0.2004621729, 0.05067312783, 0.1483313327, 0.4193562472, -0.0683876854, 0.8092621294, -0.1702431983, -0.05881963586, -0.1104006534, 0.005469174586, 0.02413483588};
    static final double[] vd6temp = new double[]{0.07905558067, -0.06784653218, -0.002413743535, 0.04795434784, -0.02979345169, -0.05477003063, 0.157522456, -0.05400590327, 0.8600210456, 0.4427411664, -0.05350546863, -0.1279990455, 0.003964078767, 0.01749302183};
    static final double[] vd7temp = new double[]{0.04472356538, -0.03838234812, -0.001245771188, 0.02792643621, -0.02285669131, -0.03338969826, 0.04201463682, -0.02161240035, -0.06527800067, 0.3288435947, 0.7890314114, 0.4902682296, -0.04839771981, -0.1181080824, 0.003500297801, 0.01544640999};
    static final double[] vd8temp = new double[]{-2.366701878E-5, 2.031134472E-5, -3.373738591E-4, -0.002266339823, -0.002165041937, 0.001906206337, -0.00708732388, 0.002020684368, 0.0446076377, -0.02107187698, -0.07263524048, 0.3379418668, 0.7876410397, 0.4910540301, -0.04831177914, -0.1179902457, 0.003490713064, 0.01540411365};
    static final double[] vd9temp = new double[]{-1.333785556E-6, 1.14467219E-6, 4.933806493E-7, 2.205985224E-6, -3.259284258E-7, -2.564526296E-6, -1.197305244E-6, -1.010124086E-7, -0.007800395608, 0.001767376409, 0.04472504864, -0.02106027212, -0.07263753168, 0.3379294037, 0.7876411418, 0.4910559454, -0.04831174259, -0.1179901111, 0.003490712084, 0.01540410933};
    static final double[] v0 = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])v0temp);
    static final double[] v1 = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])v1temp);
    static final double[] v2 = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])v2temp);
    static final double[] v3 = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])v3temp);
    static final double[] v4 = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])v4temp);
    static final double[] v5 = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])v5temp);
    static final double[] v6 = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])v6temp);
    static final double[] v7 = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])v7temp);
    static final double[] v8 = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])v8temp);
    static final double[] v9 = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])v9temp);
    static final double[] vd0 = ArrayMath.invert((double[])ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])vd0temp));
    static final double[] vd1 = ArrayMath.invert((double[])ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])vd1temp));
    static final double[] vd2 = ArrayMath.invert((double[])ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])vd2temp));
    static final double[] vd3 = ArrayMath.invert((double[])ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])vd3temp));
    static final double[] vd4 = ArrayMath.invert((double[])ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])vd4temp));
    static final double[] vd5 = ArrayMath.invert((double[])ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])vd5temp));
    static final double[] vd6 = ArrayMath.invert((double[])ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])vd6temp));
    static final double[] vd7 = ArrayMath.invert((double[])ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])vd7temp));
    static final double[] vd8 = ArrayMath.invert((double[])ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])vd8temp));
    static final double[] vd9 = ArrayMath.invert((double[])ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])vd9temp));
    static final double[] vgtemp = ArrayMath.scalarMultiply((double)0.7071067811865475, (double[])vg);
    static final double[] phvg = WaveletMath.lowToHigh((double[])vgtemp);
    static final double[] phv0 = new double[]{-0.4056098474, -0.5476194186, 0.3345888248, -0.008469145514, 0.00286042945, 0.4344317225, -0.1793040681, 0.4501354334, -0.007823562605, -2.169451337E-4, 3.443284776E-7, -1.518815163E-6};
    static final double[] phv1 = new double[]{-0.271433142, -0.3664656082, 0.08617650411, -0.2747405494, -0.5148935461, -0.309740649, -0.2206953036, -0.5444907507, 0.04953215623, -0.02013924147, -0.001989883688, 0.004859370755, 1.43793511E-4, -6.345441585E-4};
    static final double[] phv2 = new double[]{-0.07388896229, -0.09975850151, 0.1991481291, 0.2684432545, -0.01045213665, 0.2405920775, 0.5401581689, -0.3490563093, -0.06165711214, -0.194370567, 0.5024780923, -0.3169028187, -0.03084242027, 0.07560970841, 0.002218060423, -0.009788044508};
    static final double[] phv3 = new double[]{0.002329741271, 0.003145415646, -1.484555312E-4, 0.003513131058, -0.002412185766, -0.002301643677, -0.01162880173, 0.004467413223, 0.04333253688, 0.01764767584, -0.06404967457, -0.3432838094, 0.7870194497, -0.4897071, -0.04826799594, 0.1178085687, 0.003490290194, -0.01540224757};
    static final double[] phv4 = new double[]{-2.11818273E-5, -2.859787559E-5, 1.74327979E-5, -5.207298811E-7, -7.036938958E-5, -3.609725256E-5, 5.332707089E-5, -1.468100425E-4, -0.007805460453, -0.001796282458, 0.04479149901, 0.0210192526, -0.07264258737, -0.3379188415, 0.7876414895, -0.4910573861, -0.04831174654, 0.1179901294, 0.003490712054, -0.0154041092};
    static final double[] phvd0temp = new double[]{0.4378023718, -0.3757277153, -0.06873475431, -0.1032247812, 0.7266439214, 0.3259673475, -0.1186803367, -0.05853826628, -3.032048461E-4, -4.670847828E-5, 1.703850068E-6, 7.518930104E-6};
    static final double[] phvd1temp = new double[]{-0.09713836045, 0.08336541004, 0.1006861439, 0.5919694503, 0.3702101657, -0.5544630394, -0.4149317683, -0.07460178119, 0.0279042853, 0.005912930318, -0.00171203503, -0.003636645827, 1.436692465E-4, 6.339957943E-4};
    static final double[] phvd2temp = new double[]{-0.08958975532, 0.0768870985, 0.001185119667, -0.06467017684, 0.03743730652, 0.0742301144, -0.1113332259, 0.05103740064, 0.4816519926, -0.7799800339, 0.334522116, 0.07239621136, -0.0208535432, -0.04433542083, 0.001748540164, 0.007716105825};
    static final double[] phvd3temp = new double[]{4.166215409E-5, -3.575500495E-5, 6.680919371E-4, 0.004483753011, 0.004274088494, -0.003773957888, 0.01399084946, -0.003990648231, -0.117757513, 0.04833340703, 0.4910525706, -0.7876666869, 0.3379295212, 0.07264103605, -0.02106021362, -0.04472460633, 0.001767709932, 0.0078006998};
    static final double[] phvd4temp = new double[]{2.633834884E-6, -2.260391508E-6, -9.742819475E-7, -4.356173277E-6, 6.436128145E-7, 5.064186603E-6, 2.364326456E-6, 1.994698649E-7, 0.0154034918, -0.003490049659, -0.1179904012, 0.04831170232, 0.4910559595, -0.7876411054, 0.3379294202, 0.07263751587, -0.02106029251, -0.04472490177, 0.001767711864, 0.007800708325};
    static final double[] phvd0 = ArrayMath.invert((double[])phvd0temp);
    static final double[] phvd1 = ArrayMath.invert((double[])phvd1temp);
    static final double[] phvd2 = ArrayMath.invert((double[])phvd2temp);
    static final double[] phvd3 = ArrayMath.invert((double[])phvd3temp);
    static final double[] phvd4 = ArrayMath.invert((double[])phvd4temp);

    public int getFilterType() {
        return 10;
    }

    public MultiscaleFunction primaryScaling(int n, int n2) {
        return new Scaling6(n, n2);
    }

    public MultiscaleFunction dualScaling(int n, int n2) {
        return new Scaling6(n, n2);
    }

    public MultiscaleFunction primaryWavelet(int n, int n2) {
        return new Wavelet6(n, n2);
    }

    public MultiscaleFunction dualWavelet(int n, int n2) {
        return new Wavelet6(n, n2);
    }

    public int previousDimension(int n) {
        return Cascades.previousDimension(10, n);
    }

    public double[] lowpass(double[] dArray, double[] dArray2) {
        return this.lowpass(dArray);
    }

    public double[] highpass(double[] dArray, double[] dArray2) {
        return this.highpass(dArray);
    }

    public double[] lowpass(double[] dArray) {
        int n;
        if (dArray.length < 20) {
            throw new IllegalScalingException("The array is not long enough : " + dArray.length + " < " + 20);
        }
        double[] dArray2 = new double[2 * dArray.length - 10];
        int n2 = dArray.length - 1;
        int n3 = 10;
        while (n3 <= n2 - 10) {
            n = -6;
            while (n < 6) {
                int n4 = 2 * n3 + n - 4;
                dArray2[n4] = dArray2[n4] + vg[n + 6] * dArray[n3];
                ++n;
            }
            ++n3;
        }
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[0], (double[])v0, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[1], (double[])v1, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[2], (double[])v2, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[3], (double[])v3, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[4], (double[])v4, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[5], (double[])v5, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[6], (double[])v6, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[7], (double[])v7, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[8], (double[])v8, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[9], (double[])v9, (int)0);
        n = dArray2.length - vd0.length;
        int n5 = dArray2.length - vd1.length;
        int n6 = dArray2.length - vd2.length;
        int n7 = dArray2.length - vd3.length;
        int n8 = dArray2.length - vd4.length;
        int n9 = dArray2.length - vd5.length;
        int n10 = dArray2.length - vd6.length;
        int n11 = dArray2.length - vd7.length;
        int n12 = dArray2.length - vd8.length;
        int n13 = dArray2.length - vd9.length;
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n2], (double[])vd0, (int)n);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n2 - 1], (double[])vd1, (int)n5);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n2 - 2], (double[])vd2, (int)n6);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n2 - 3], (double[])vd3, (int)n7);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n2 - 4], (double[])vd4, (int)n8);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n2 - 5], (double[])vd5, (int)n9);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n2 - 6], (double[])vd6, (int)n10);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n2 - 7], (double[])vd7, (int)n11);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n2 - 8], (double[])vd8, (int)n12);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n2 - 9], (double[])vd9, (int)n13);
        return dArray2;
    }

    public double[] highpass(double[] dArray) {
        int n;
        if (dArray.length < 10) {
            throw new IllegalScalingException("The array is not long enough : " + dArray.length + " < 10");
        }
        double[] dArray2 = new double[2 * dArray.length + 10];
        int n2 = dArray.length - 1;
        int n3 = 5;
        while (n3 <= n2 - 5) {
            n = -6;
            while (n < 6) {
                int n4 = 2 * n3 + n + 6;
                dArray2[n4] = dArray2[n4] + phvg[n + 6] * dArray[n3];
                ++n;
            }
            ++n3;
        }
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[0], (double[])phv0, (int)0);
        n = dArray2.length - phvd0.length;
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n2], (double[])phvd0, (int)n);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[1], (double[])phv1, (int)0);
        int n5 = dArray2.length - phvd1.length;
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n2 - 1], (double[])phvd1, (int)n5);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[2], (double[])phv2, (int)0);
        int n6 = dArray2.length - phvd2.length;
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n2 - 2], (double[])phvd2, (int)n6);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[3], (double[])phv3, (int)0);
        int n7 = dArray2.length - phvd3.length;
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n2 - 3], (double[])phvd3, (int)n7);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[4], (double[])phv4, (int)0);
        int n8 = dArray2.length - phvd4.length;
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n2 - 4], (double[])phvd4, (int)n8);
        return dArray2;
    }

    public double[] evalScaling(int n, int n2, int n3) {
        return Cascades.evalScaling(this, n, n3, n2);
    }

    public double[] evalWavelet(int n, int n2, int n3) {
        return Cascades.evalWavelet(this, 10, n, n3, n2);
    }
}

