/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet.jmx;

import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.jetty.servlet.WebApplicationContext;
import org.mortbay.jetty.servlet.jmx.ServletHttpContextMBean;
import org.mortbay.util.LifeCycleEvent;
import org.mortbay.util.LifeCycleListener;

public class WebApplicationContextMBean
extends ServletHttpContextMBean {
    private static final Log log = LogFactory.getLog((Class)(class$org$mortbay$jetty$servlet$jmx$WebApplicationContextMBean == null ? (class$org$mortbay$jetty$servlet$jmx$WebApplicationContextMBean = WebApplicationContextMBean.class$("org.mortbay.jetty.servlet.jmx.WebApplicationContextMBean")) : class$org$mortbay$jetty$servlet$jmx$WebApplicationContextMBean));
    private WebApplicationContext _webappContext;
    private Map _configurations = new HashMap();
    static /* synthetic */ Class class$org$mortbay$jetty$servlet$jmx$WebApplicationContextMBean;

    protected void defineManagedResource() {
        super.defineManagedResource();
        this.defineAttribute("displayName", false);
        this.defineAttribute("defaultsDescriptor", true);
        this.defineAttribute("WAR", true);
        this.defineAttribute("extractWAR", true);
        this._webappContext = (WebApplicationContext)this.getManagedResource();
        this._webappContext.addEventListener((EventListener)new LifeCycleListener(){

            public void lifeCycleStarting(LifeCycleEvent event) {
            }

            public void lifeCycleStarted(LifeCycleEvent event) {
                WebApplicationContextMBean.this.getConfigurations();
            }

            public void lifeCycleFailure(LifeCycleEvent event) {
            }

            public void lifeCycleStopping(LifeCycleEvent event) {
            }

            public void lifeCycleStopped(LifeCycleEvent event) {
                WebApplicationContextMBean.this.destroyConfigurations();
            }
        });
    }

    public void postRegister(Boolean ok) {
        super.postRegister(ok);
        this.getConfigurations();
    }

    public void postDeregister() {
        this.destroyConfigurations();
        super.postDeregister();
    }

    public ObjectName[] getConfigurations() {
        return this.getComponentMBeans(this._webappContext.getConfigurations(), this._configurations);
    }

    public void destroyConfigurations() {
        MBeanServer mbeanServer = this.getMBeanServer();
        Iterator itor = this._configurations.values().iterator();
        while (itor.hasNext()) {
            try {
                ObjectName o = (ObjectName)itor.next();
                log.debug((Object)("Unregistering: " + o));
                if (null == mbeanServer) continue;
                mbeanServer.unregisterMBean(o);
            }
            catch (Exception e) {
                log.warn((Object)"EXCEPTION ", (Throwable)e);
            }
        }
        this._configurations.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

