/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.formats.RowEvaluator;
import uk.ac.starlink.table.formats.StreamStarTable;
import uk.ac.starlink.util.DataSource;

public class PostgresAsciiStarTable
extends StreamStarTable {
    private final StringBuffer cellBuf_ = new StringBuffer();
    private final URL schemaUrl_;
    private final int ncol_;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;

    public PostgresAsciiStarTable(DataSource datsrc, URL schemaUrl) throws IOException {
        this.schemaUrl_ = schemaUrl;
        this.init(datsrc);
        this.ncol_ = this.getColumnCount();
    }

    protected List readRow(PushbackInputStream in) throws TableFormatException, IOException {
        int icol = 0;
        this.cellBuf_.setLength(0);
        Object[] row = new Object[this.ncol_];
        block5: while (true) {
            char c = (char)in.read();
            switch (c) {
                case '\uffff': {
                    return null;
                }
                case '\n': {
                    row[icol++] = this.cellBuf_.toString();
                    this.cellBuf_.setLength(0);
                    if (icol != this.ncol_) {
                        throw new TableFormatException("Wrong num of cols");
                    }
                    return Arrays.asList(row);
                }
                case '|': {
                    row[icol++] = this.cellBuf_.toString();
                    this.cellBuf_.setLength(0);
                    continue block5;
                }
            }
            this.cellBuf_.append(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected RowEvaluator.Metadata obtainMetadata() throws IOException {
        ColumnInfo[] colInfos;
        InputStream in = this.schemaUrl_.openStream();
        try {
            colInfos = this.readSchema(in);
        }
        finally {
            in.close();
        }
        int ncol = colInfos.length;
        RowEvaluator.Decoder[] decoders = new RowEvaluator.Decoder[ncol];
        for (int i = 0; i < ncol; ++i) {
            void var7_8;
            RowEvaluator.Decoder decoder;
            Class clazz = colInfos[i].getContentClass();
            if (clazz == (class$java$lang$Double == null ? PostgresAsciiStarTable.class$("java.lang.Double") : class$java$lang$Double)) {
                decoder = new RowEvaluator.Decoder(){

                    public Object decode(String value) {
                        return "\\N".equals(value) ? null : Double.valueOf(value);
                    }
                };
            } else if (clazz == (class$java$lang$Float == null ? PostgresAsciiStarTable.class$("java.lang.Float") : class$java$lang$Float)) {
                decoder = new RowEvaluator.Decoder(){

                    public Object decode(String value) {
                        return "\\N".equals(value) ? null : Float.valueOf(value);
                    }
                };
            } else if (clazz == (class$java$lang$Integer == null ? PostgresAsciiStarTable.class$("java.lang.Integer") : class$java$lang$Integer)) {
                decoder = new RowEvaluator.Decoder(){

                    public Object decode(String value) {
                        return "\\N".equals(value) ? null : Integer.valueOf(value);
                    }
                };
            } else if (clazz == (class$java$lang$Short == null ? PostgresAsciiStarTable.class$("java.lang.Short") : class$java$lang$Short)) {
                decoder = new RowEvaluator.Decoder(){

                    public Object decode(String value) {
                        return "\\N".equals(value) ? null : Short.valueOf(value);
                    }
                };
            } else if (clazz == (class$java$lang$String == null ? PostgresAsciiStarTable.class$("java.lang.String") : class$java$lang$String)) {
                decoder = new RowEvaluator.Decoder(){

                    public Object decode(String value) {
                        return "\\N".equals(value) ? null : value;
                    }
                };
            } else {
                throw new AssertionError((Object)"Unknown class");
            }
            decoders[i] = var7_8;
        }
        return new RowEvaluator.Metadata(colInfos, decoders, -1L);
    }

    /*
     * WARNING - void declaration
     */
    protected ColumnInfo[] readSchema(InputStream in) throws IOException {
        String line;
        Pattern regex = Pattern.compile("^ +([a-z_]+) ([a-z ]+)(\\(([0-9]+)\\))?,? *$");
        ArrayList<void> infoList = new ArrayList<void>();
        BufferedReader rdr = new BufferedReader(new InputStreamReader(in));
        while ((line = rdr.readLine()) != null) {
            void var10_10;
            ColumnInfo info;
            Matcher matcher = regex.matcher(line);
            if (!matcher.matches()) continue;
            String name = matcher.group(1);
            String type = matcher.group(2);
            String ssiz = matcher.group(4);
            if ("double precision".equals(type)) {
                info = new ColumnInfo(name, class$java$lang$Double == null ? PostgresAsciiStarTable.class$("java.lang.Double") : class$java$lang$Double, null);
            } else if ("real".equals(type)) {
                info = new ColumnInfo(name, class$java$lang$Float == null ? PostgresAsciiStarTable.class$("java.lang.Float") : class$java$lang$Float, null);
            } else if ("smallint".equals(type)) {
                info = new ColumnInfo(name, class$java$lang$Short == null ? PostgresAsciiStarTable.class$("java.lang.Short") : class$java$lang$Short, null);
            } else if ("integer".equals(type)) {
                info = new ColumnInfo(name, class$java$lang$Integer == null ? PostgresAsciiStarTable.class$("java.lang.Integer") : class$java$lang$Integer, null);
            } else if ("date".equals(type)) {
                info = new ColumnInfo(name, class$java$lang$String == null ? PostgresAsciiStarTable.class$("java.lang.String") : class$java$lang$String, null);
                info.setElementSize(10);
                info.setUnitString("iso-8601");
            } else if ("character".equals(type)) {
                info = new ColumnInfo(name, class$java$lang$String == null ? PostgresAsciiStarTable.class$("java.lang.String") : class$java$lang$String, null);
                info.setElementSize(Integer.parseInt(ssiz));
            } else {
                throw new TableFormatException("Unknown schema type " + type);
            }
            infoList.add(var10_10);
        }
        return infoList.toArray(new ColumnInfo[0]);
    }
}

