/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.awt.Component;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.gui.TableConsumer;
import uk.ac.starlink.util.gui.ErrorDialog;

public abstract class BasicTableConsumer
implements TableConsumer {
    private final Component parent_;
    private boolean loading_;
    private String id_;

    public BasicTableConsumer(Component parent) {
        this.parent_ = parent;
    }

    protected abstract void tableLoaded(StarTable var1);

    public synchronized void cancel() {
        if (this.isLoading()) {
            this.setLoading(false);
        }
    }

    public synchronized boolean isLoading() {
        return this.loading_;
    }

    protected synchronized void setLoading(boolean isLoading) {
        this.loading_ = isLoading;
    }

    public synchronized void loadStarted(String id) {
        if (this.isLoading()) {
            throw new IllegalStateException();
        }
        this.id_ = id;
        this.setLoading(true);
    }

    public synchronized void loadSucceeded(StarTable table) {
        if (this.isLoading()) {
            this.cancel();
            this.tableLoaded(table);
        }
    }

    public synchronized void loadFailed(Throwable th) {
        if (this.isLoading()) {
            this.cancel();
            this.processError(th);
        }
    }

    protected void processError(Throwable th) {
        ErrorDialog.showError(this.parent_, "Load Error", th, "Can't load table " + this.id_);
    }
}

