/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.gui.LoadWorker;
import uk.ac.starlink.table.gui.TableConsumer;
import uk.ac.starlink.table.gui.TableLoadDialog;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.gui.ErrorDialog;

public abstract class BasicTableLoadDialog
extends JPanel
implements TableLoadDialog {
    private final String name_;
    private final String description_;
    private final Action okAction_;
    private final Action cancelAction_;
    private final JProgressBar progBar_;
    private JDialog dialog_;
    private StarTableFactory factory_;
    private ComboBoxModel formatModel_;
    private TableConsumer consumer_;
    private TableSupplier supplier_;
    private ComboBoxModel emptyModel_;
    private LoadWorker worker_;

    public BasicTableLoadDialog(String name, String description) {
        super(new BorderLayout());
        this.name_ = name;
        this.description_ = description;
        this.okAction_ = new AbstractAction("OK"){

            public void actionPerformed(ActionEvent evt) {
                BasicTableLoadDialog.this.ok();
            }
        };
        this.cancelAction_ = new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent evt) {
                BasicTableLoadDialog.this.cancel();
            }
        };
        this.progBar_ = new JProgressBar();
        this.emptyModel_ = new DefaultComboBoxModel();
    }

    public String getName() {
        return this.name_;
    }

    public String getDescription() {
        return this.description_;
    }

    public boolean showLoadDialog(Component parent, StarTableFactory factory, ComboBoxModel formatModel, TableConsumer consumer) {
        JDialog dia;
        if (this.dialog_ != null) {
            throw new IllegalStateException("Dialogue already active");
        }
        this.dialog_ = dia = this.createDialog(parent);
        this.factory_ = factory;
        this.formatModel_ = formatModel;
        this.consumer_ = consumer;
        this.supplier_ = null;
        this.setFormatModel(formatModel);
        dia.show();
        this.setBusy(false);
        boolean ok = dia == this.dialog_;
        this.dialog_ = null;
        this.factory_ = null;
        this.formatModel_ = null;
        this.consumer_ = null;
        this.supplier_ = null;
        this.setFormatModel(this.emptyModel_);
        return ok;
    }

    protected JDialog createDialog(Component parent) {
        Frame frame = null;
        if (parent != null) {
            frame = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        }
        Box controlPanel = Box.createHorizontalBox();
        controlPanel.add(Box.createHorizontalGlue());
        controlPanel.add(new JButton(this.cancelAction_));
        controlPanel.add(Box.createHorizontalStrut(5));
        controlPanel.add(new JButton(this.okAction_));
        controlPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JDialog dialog = new JDialog(frame, this.getName(), true);
        JPanel main = new JPanel(new BorderLayout());
        main.add((Component)this, "Center");
        main.add((Component)controlPanel, "South");
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)main, "Center");
        dialog.getContentPane().add((Component)this.progBar_, "South");
        dialog.setLocationRelativeTo(parent);
        dialog.pack();
        return dialog;
    }

    protected void setFormatModel(ComboBoxModel formatModel) {
    }

    protected abstract TableSupplier getTableSupplier() throws RuntimeException;

    protected Action getOkAction() {
        return this.okAction_;
    }

    protected Action getCancelAction() {
        return this.cancelAction_;
    }

    protected JProgressBar getProgessBar() {
        return this.progBar_;
    }

    public static IOException asIOException(Throwable th) {
        if (th instanceof IOException) {
            return (IOException)th;
        }
        String msg = th.getMessage();
        if (msg != null) {
            msg = th.getClass().getName();
        }
        return (IOException)new IOException(msg).initCause(th);
    }

    protected void setBusy(boolean busy) {
        this.setEnabled(!busy);
        this.okAction_.setEnabled(!busy);
        this.progBar_.setIndeterminate(busy);
    }

    private void ok() {
        TableSupplier supplier;
        if (this.dialog_ == null) {
            return;
        }
        try {
            supplier = this.getTableSupplier();
        }
        catch (RuntimeException e) {
            ErrorDialog.showError(this.dialog_, "Dialogue Error", e);
            return;
        }
        final StarTableFactory factory = this.factory_;
        final String format = this.formatModel_.getSelectedItem().toString();
        this.setBusy(true);
        this.worker_ = new LoadWorker(new DialogConsumer(this.dialog_), supplier.getTableID()){

            protected StarTable attemptLoad() throws IOException {
                return supplier.getTable(factory, format);
            }
        };
        this.worker_.invoke();
    }

    private void cancel() {
        if (this.worker_ != null) {
            this.worker_.interrupt();
            this.worker_ = null;
        }
        if (this.dialog_ != null) {
            this.dialog_.dispose();
        }
    }

    private class DialogConsumer
    implements TableConsumer {
        final JDialog dia_;
        String id_;

        DialogConsumer(JDialog dia) {
            this.dia_ = dia;
        }

        public void loadStarted(String id) {
            this.id_ = id;
        }

        public void loadSucceeded(StarTable table) {
            if (BasicTableLoadDialog.this.dialog_ == this.dia_) {
                BasicTableLoadDialog.this.consumer_.loadStarted(this.id_);
                BasicTableLoadDialog.this.consumer_.loadSucceeded(table);
                BasicTableLoadDialog.this.setBusy(false);
                BasicTableLoadDialog.this.dialog_.dispose();
            }
        }

        public void loadFailed(Throwable th) {
            if (BasicTableLoadDialog.this.dialog_ == this.dia_) {
                BasicTableLoadDialog.this.consumer_.loadStarted(this.id_);
                BasicTableLoadDialog.this.consumer_.loadFailed(th);
                BasicTableLoadDialog.this.setBusy(false);
            }
        }
    }

    public class DataSourceTableSupplier
    implements TableSupplier {
        private final DataSource datsrc_;

        public DataSourceTableSupplier(DataSource datsrc) {
            this.datsrc_ = datsrc;
        }

        public StarTable getTable(StarTableFactory factory, String format) throws IOException {
            return factory.makeStarTable(this.datsrc_, format);
        }

        public String getTableID() {
            return this.datsrc_.getName();
        }
    }

    public static interface TableSupplier {
        public StarTable getTable(StarTableFactory var1, String var2) throws IOException;

        public String getTableID();
    }
}

