/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.gui.LoadWorker;
import uk.ac.starlink.table.gui.TableConsumer;
import uk.ac.starlink.table.gui.TableLoadDialog;
import uk.ac.starlink.util.FileDataSource;
import uk.ac.starlink.util.gui.ErrorDialog;

public class FileChooserLoader
extends JFileChooser
implements TableLoadDialog {
    private boolean isAvailable_;
    private final JComboBox formatSelector_;
    private final ComboBoxModel dummyModel_;

    public FileChooserLoader() {
        try {
            SecurityManager manager = System.getSecurityManager();
            if (manager != null) {
                manager.checkRead(this.getCurrentDirectory().toString());
            }
            this.isAvailable_ = true;
        }
        catch (SecurityException e) {
            this.isAvailable_ = false;
        }
        this.setFileSelectionMode(0);
        this.setMultiSelectionEnabled(false);
        this.setCurrentDirectory(new File("."));
        Box formatBox = Box.createVerticalBox();
        Box labelLine = Box.createHorizontalBox();
        labelLine.add(new JLabel("Format: "));
        labelLine.add(Box.createHorizontalGlue());
        formatBox.add(Box.createVerticalGlue());
        formatBox.add(labelLine);
        formatBox.add(Box.createVerticalStrut(5));
        this.formatSelector_ = new JComboBox();
        this.dummyModel_ = this.formatSelector_.getModel();
        Box selectorLine = Box.createHorizontalBox();
        selectorLine.add(this.formatSelector_);
        selectorLine.add(Box.createHorizontalGlue());
        formatBox.add(selectorLine);
        formatBox.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.setAccessory(formatBox);
    }

    public String getName() {
        return "File Browser";
    }

    public String getDescription() {
        return "Load table from files on the local filesystem";
    }

    public boolean isAvailable() {
        return this.isAvailable_;
    }

    public boolean showLoadDialog(Component parent, final StarTableFactory factory, ComboBoxModel formatModel, TableConsumer eater) {
        this.formatSelector_.setModel(formatModel);
        this.formatSelector_.setMaximumSize(this.formatSelector_.getPreferredSize());
        while (this.showOpenDialog(parent) == 0) {
            File file = this.getSelectedFile();
            if (file == null) continue;
            try {
                final FileDataSource datsrc = new FileDataSource(file);
                final String format = (String)formatModel.getSelectedItem();
                new LoadWorker(eater, file.toString()){

                    protected StarTable attemptLoad() throws IOException {
                        return factory.makeStarTable(datsrc, format);
                    }
                }.invoke();
                return true;
            }
            catch (IOException e) {
                ErrorDialog.showError(parent, "Load Error", (Throwable)e, "Can't open file " + file);
            }
        }
        return false;
    }
}

