/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import uk.ac.starlink.connect.Branch;
import uk.ac.starlink.connect.FileNode;
import uk.ac.starlink.connect.FilestoreChooser;
import uk.ac.starlink.connect.Leaf;
import uk.ac.starlink.connect.Node;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.StarTableWriter;
import uk.ac.starlink.table.gui.SaveWorker;
import uk.ac.starlink.table.gui.TableSaveDialog;
import uk.ac.starlink.util.gui.ShrinkWrapper;

class FilestoreTableSaveDialog
implements TableSaveDialog {
    private final FilestoreChooser chooser_ = new FilestoreChooser(){

        public void leafSelected(Leaf leaf) {
            if (FilestoreTableSaveDialog.this.popup_ != null) {
                FilestoreTableSaveDialog.this.popup_.selected(leaf);
            }
        }
    };
    private FilestorePopup popup_;

    public FilestoreTableSaveDialog() {
        this.chooser_.addDefaultBranches();
    }

    public String getName() {
        return "Filestore Browser";
    }

    public String getDescription() {
        return "Save table to local or remote filespace";
    }

    public boolean isAvailable() {
        return true;
    }

    public boolean showSaveDialog(Component parent, StarTableOutput sto, ComboBoxModel formatModel, StarTable table) {
        if (this.popup_ != null) {
            throw new IllegalStateException("Dialogue already visible");
        }
        Frame frame = null;
        if (parent != null) {
            frame = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        }
        FilestorePopup popup = new FilestorePopup(frame, sto, table, formatModel);
        popup.pack();
        popup.setLocationRelativeTo(parent);
        this.chooser_.refreshList();
        this.chooser_.setEnabled(true);
        this.popup_ = popup;
        this.popup_.show();
        boolean success = this.popup_ == popup;
        this.popup_ = null;
        return success;
    }

    public FilestoreChooser getChooser() {
        return this.chooser_;
    }

    private static void attemptSave(StarTable table, StarTableOutput sto, Leaf leaf, String format) throws IOException {
        String loc = leaf instanceof FileNode ? ((FileNode)leaf).getFile().toString() : null;
        if (loc != null) {
            sto.writeStarTable(table, loc, format);
        } else {
            OutputStream stream = leaf.getOutputStream();
            StarTableWriter handler = sto.getHandler(format, leaf.getName());
            sto.writeStarTable(table, stream, handler);
        }
    }

    private static boolean exists(Leaf leaf) {
        String name = leaf.getName();
        Branch parent = leaf.getParent();
        if (parent != null) {
            Node[] siblings = parent.getChildren();
            for (int i = 0; i < siblings.length; ++i) {
                if (!siblings[i].getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean confirmOverwrite(Component parent, String loc) {
        String[] msg = new String[]{"Overwrite existing file \"" + loc + "\"?"};
        String cancelOption = "Cancel";
        String overwriteOption = "Overwrite";
        Object[] options = new Object[]{cancelOption, overwriteOption};
        int result = JOptionPane.showOptionDialog(parent, msg, "Confirm overwrite", 0, 2, null, options, cancelOption);
        return result == 1;
    }

    static /* synthetic */ FilestorePopup access$002(FilestoreTableSaveDialog x0, FilestorePopup x1) {
        x0.popup_ = x1;
        return x0.popup_;
    }

    static /* synthetic */ void access$500(StarTable x0, StarTableOutput x1, Leaf x2, String x3) throws IOException {
        FilestoreTableSaveDialog.attemptSave(x0, x1, x2, x3);
    }

    private class FilestorePopup
    extends JDialog {
        SaveWorker worker_;
        final JProgressBar progBar_;
        final StarTableOutput sto_;
        final StarTable table_;
        final ComboBoxModel formatModel_;

        FilestorePopup(Frame frame, StarTableOutput sto, StarTable table, ComboBoxModel formatModel) {
            super(frame, "Save Table", true);
            this.sto_ = sto;
            this.table_ = table;
            this.formatModel_ = formatModel;
            this.setDefaultCloseOperation(2);
            AbstractAction cancelAction = new AbstractAction(this, "Cancel", FilestoreTableSaveDialog.this){
                private final /* synthetic */ FilestoreTableSaveDialog val$this$0;
                private final /* synthetic */ FilestorePopup this$1;
                {
                    this.this$1 = this$1;
                    this.val$this$0 = val$this$0;
                    super(x0);
                }

                public void actionPerformed(ActionEvent evt) {
                    if (this.this$1.worker_ != null) {
                        this.this$1.worker_.cancel();
                        this.this$1.worker_ = null;
                    } else if (FilestoreTableSaveDialog.access$000(FilestorePopup.access$100(this.this$1)) == this.this$1) {
                        FilestoreTableSaveDialog.access$000(FilestorePopup.access$100(this.this$1)).dispose();
                        FilestoreTableSaveDialog.access$002(FilestorePopup.access$100(this.this$1), null);
                    }
                }
            };
            this.progBar_ = new JProgressBar();
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.progBar_, "South");
            JPanel main = new JPanel(new BorderLayout());
            this.getContentPane().add((Component)main, "Center");
            main.add((Component)FilestoreTableSaveDialog.this.chooser_, "Center");
            Box formatBox = Box.createHorizontalBox();
            formatBox.add(new JLabel("Output Format: "));
            formatBox.add(new ShrinkWrapper(new JComboBox(formatModel)));
            formatBox.add(Box.createHorizontalGlue());
            Box controlBox = Box.createHorizontalBox();
            controlBox.add(Box.createHorizontalGlue());
            controlBox.add(new JButton(FilestoreTableSaveDialog.this.chooser_.getOkAction()));
            controlBox.add(Box.createHorizontalStrut(5));
            controlBox.add(new JButton(cancelAction));
            Box botBox = Box.createVerticalBox();
            botBox.add(formatBox);
            botBox.add(Box.createVerticalStrut(5));
            botBox.add(controlBox);
            botBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            main.add((Component)botBox, "South");
        }

        public void selected(Leaf leaf) {
            if (this.worker_ == null) {
                if (FilestoreTableSaveDialog.exists(leaf) && !FilestoreTableSaveDialog.confirmOverwrite(this, leaf.toString())) {
                    return;
                }
                this.worker_ = new SaveWorker(this, this.progBar_, this.table_, leaf.toString(), leaf){
                    private final /* synthetic */ Leaf val$leaf;
                    private final /* synthetic */ FilestorePopup this$1;
                    {
                        this.this$1 = this$1;
                        this.val$leaf = val$leaf;
                        super(x0, x1, x2);
                    }

                    protected void attemptSave(StarTable table) throws IOException {
                        FilestoreTableSaveDialog.access$500(table, this.this$1.sto_, this.val$leaf, (String)this.this$1.formatModel_.getSelectedItem());
                    }

                    protected void done(boolean success) {
                        this.this$1.worker_ = null;
                        if (success) {
                            this.this$1.dispose();
                        }
                        FilestoreTableSaveDialog.access$200(FilestorePopup.access$100(this.this$1)).setEnabled(true);
                    }
                };
                FilestoreTableSaveDialog.this.chooser_.setEnabled(false);
                this.worker_.invoke();
            }
        }

        static /* synthetic */ FilestoreTableSaveDialog access$100(FilestorePopup x0) {
            return x0.FilestoreTableSaveDialog.this;
        }
    }
}

