/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.gui.ProgressBarStarTable;
import uk.ac.starlink.util.gui.ErrorDialog;

public abstract class SaveWorker {
    private final String location_;
    private final ProgressBarStarTable progTable_;
    private final JProgressBar progBar_;
    private final JDialog progPopup_;
    private Thread worker_;

    protected SaveWorker(Component parent, StarTable table, String location) {
        this.progBar_ = new JProgressBar();
        this.progTable_ = new ProgressBarStarTable(table, this.progBar_);
        this.location_ = location;
        this.progPopup_ = new JDialog(SaveWorker.getFrame(parent), "Saving...", true);
        this.progPopup_.setDefaultCloseOperation(2);
        this.progPopup_.setContentPane(this.createProgressPanel(this.progBar_, table.getName(), location));
        this.progPopup_.pack();
        this.progPopup_.setLocationRelativeTo(parent);
    }

    protected SaveWorker(JProgressBar progBar, StarTable table, String location) {
        this.progBar_ = progBar;
        this.progTable_ = new ProgressBarStarTable(table, this.progBar_);
        this.location_ = location;
        this.progPopup_ = null;
    }

    protected abstract void attemptSave(StarTable var1) throws IOException;

    protected abstract void done(boolean var1);

    public void cancel() {
        if (this.worker_ != null) {
            this.worker_.interrupt();
            this.worker_ = null;
        }
    }

    public void invoke() {
        this.worker_ = new Thread("Saver thread"){
            Throwable error;

            public void run() {
                try {
                    SaveWorker.this.attemptSave(SaveWorker.this.progTable_);
                    this.error = null;
                }
                catch (Throwable e) {
                    this.error = e;
                }
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        if (SaveWorker.access$200(1.access$100(this.this$1)) != null) {
                            SaveWorker.access$202(1.access$100(this.this$1), null);
                            if (this.this$1.error == null) {
                                SaveWorker.access$300(1.access$100(this.this$1));
                                1.access$100(this.this$1).done(true);
                            } else {
                                SaveWorker.access$400(1.access$100(this.this$1), this.this$1.error);
                                1.access$100(this.this$1).done(false);
                            }
                        }
                    }
                });
            }

            static /* synthetic */ SaveWorker access$100(1 x0) {
                return x0.SaveWorker.this;
            }
        };
        this.worker_.start();
        this.saveStarted();
    }

    private void saveStarted() {
        if (this.progPopup_ != null) {
            this.progPopup_.show();
        }
    }

    private void saveSucceeded() {
        if (this.progPopup_ != null) {
            this.progPopup_.dispose();
        }
    }

    private void saveFailed(Throwable error) {
        String[] msg = new String[]{"Error saving " + this.progTable_.getName(), "to " + this.location_};
        ErrorDialog.showError((Component)this.progPopup_, "Save Error", error, msg);
        if (this.progPopup_ != null) {
            this.progPopup_.dispose();
        }
    }

    private JComponent createProgressPanel(JProgressBar progBar, String name, String dest) {
        JPanel main = new JPanel(new BorderLayout());
        Border gapBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        AbstractAction cancelAction = new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent evt) {
                SaveWorker.this.cancel();
            }
        };
        JPanel iconBox = new JPanel();
        iconBox.setBorder(gapBorder);
        iconBox.add(new JLabel(UIManager.getIcon("OptionPane.informationIcon")));
        main.add((Component)iconBox, "West");
        Box midBox = Box.createVerticalBox();
        midBox.setBorder(gapBorder);
        midBox.add(new JLabel("Saving table " + name));
        midBox.add(new JLabel("to " + dest));
        midBox.add(Box.createVerticalStrut(5));
        midBox.add(progBar);
        main.add((Component)midBox, "Center");
        Box controlBox = Box.createHorizontalBox();
        controlBox.setBorder(gapBorder);
        controlBox.add(Box.createHorizontalGlue());
        controlBox.add(new JButton(cancelAction));
        controlBox.add(Box.createHorizontalGlue());
        main.add((Component)controlBox, "South");
        return main;
    }

    private static Frame getFrame(Component parent) {
        if (parent == null) {
            return null;
        }
        if (parent instanceof Frame) {
            return (Frame)parent;
        }
        return (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
    }

    static /* synthetic */ Thread access$200(SaveWorker x0) {
        return x0.worker_;
    }

    static /* synthetic */ Thread access$202(SaveWorker x0, Thread x1) {
        x0.worker_ = x1;
        return x0.worker_;
    }

    static /* synthetic */ void access$300(SaveWorker x0) {
        x0.saveSucceeded();
    }

    static /* synthetic */ void access$400(SaveWorker x0, Throwable x1) {
        x0.saveFailed(x1);
    }
}

