/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast;

import java.io.IOException;
import java.util.logging.Logger;
import uk.ac.starlink.ast.Channel;
import uk.ac.starlink.util.Loader;

public class AstObject {
    protected long pointer = 0L;
    static int[] AST_VERSION;
    static int[] JNIAST_NATIVE_VERSION;
    static int[] JNIAST_JAVA_VERSION;
    private static Logger logger;
    public static final double AST__BAD;

    protected AstObject() {
    }

    protected void finalize() throws Throwable {
        if (this.pointer != 0L) {
            this.annul();
        }
        this.pointer = 0L;
        super.finalize();
    }

    private static native void nativeInitialize();

    public static native int getAstConstantI(String var0);

    static native double getAstConstantD(String var0);

    static native String getAstConstantC(String var0);

    public native void annul();

    public native void delete();

    public native Object clone();

    public boolean equals(Object obj) {
        boolean eq = false;
        if (obj.getClass().equals(this.getClass())) {
            AstStringer stringer = new AstStringer();
            String s1 = stringer.representation(this);
            String s2 = stringer.representation((AstObject)obj);
            eq = s1 != null && s2 != null && s1.equals(s2);
        }
        return eq;
    }

    public int hashCode() {
        String s = new AstStringer().representation(this);
        if (s != null) {
            return s.hashCode();
        }
        return System.identityHashCode(this);
    }

    public boolean sameObject(Object obj) {
        boolean same = false;
        if (obj instanceof AstObject) {
            AstObject aobj = (AstObject)obj;
            String oldID = this.getID();
            if (oldID.equals(aobj.getID())) {
                String newID = oldID + "x";
                this.setID(newID);
                if (newID.equals(aobj.getID())) {
                    same = true;
                }
                if (oldID.length() == 0) {
                    this.clear("ID");
                } else {
                    this.setID(oldID);
                }
            }
        }
        return same;
    }

    public static String reportVersions() {
        return "AST " + AstObject.reportVersion(AST_VERSION) + "; " + "JNIAST native " + AstObject.reportVersion(JNIAST_NATIVE_VERSION) + "; " + "JNIAST java " + AstObject.reportVersion(JNIAST_JAVA_VERSION);
    }

    private static String reportVersion(int[] vers) {
        return "" + 'V' + vers[0] + '.' + vers[1] + '-' + vers[2];
    }

    private static boolean versionGreaterEqual(int[] vers1, int[] vers2) {
        if (vers1[0] == vers2[0]) {
            if (vers1[1] == vers2[1]) {
                if (vers1[2] == vers2[2]) {
                    return true;
                }
                return vers1[2] > vers2[2];
            }
            return vers1[1] > vers2[1];
        }
        return vers1[0] > vers2[0];
    }

    public native void clear(String var1);

    public native AstObject copy();

    public native String getC(String var1);

    public native void setC(String var1, String var2);

    public native double getD(String var1);

    public native void setD(String var1, double var2);

    public native float getF(String var1);

    public native void setF(String var1, float var2);

    public native long getL(String var1);

    public native void setL(String var1, long var2);

    public native int getI(String var1);

    public native void setI(String var1, int var2);

    public boolean getB(String attrib) {
        return this.getI(attrib) != 0;
    }

    public void setB(String attrib, boolean value) {
        this.setI(attrib, value ? 1 : 0);
    }

    public native void set(String var1);

    public native void show();

    public native boolean test(String var1);

    public String getID() {
        return this.getC("ID");
    }

    public void setID(String ID) {
        this.setC("ID", ID);
    }

    public String getIdent() {
        return this.getC("Ident");
    }

    public void setIdent(String Ident) {
        this.setC("Ident", Ident);
    }

    public int getNobject() {
        return this.getI("Nobject");
    }

    public int getRefCount() {
        return this.getI("RefCount");
    }

    static {
        logger = Logger.getLogger("uk.ac.starlink.ast");
        Loader.loadLibrary("jniast");
        AstObject.nativeInitialize();
        AST_VERSION = new int[]{AstObject.getAstConstantI("AST_MAJOR_VERS"), AstObject.getAstConstantI("AST_MINOR_VERS"), AstObject.getAstConstantI("AST_RELEASE")};
        JNIAST_NATIVE_VERSION = new int[]{AstObject.getAstConstantI("JNIAST_MAJOR_VERS"), AstObject.getAstConstantI("JNIAST_MINOR_VERS"), AstObject.getAstConstantI("JNIAST_RELEASE")};
        JNIAST_JAVA_VERSION = new int[]{4, 0, 1};
        if (!AstObject.versionGreaterEqual(AST_VERSION, JNIAST_NATIVE_VERSION) || !AstObject.versionGreaterEqual(JNIAST_NATIVE_VERSION, JNIAST_JAVA_VERSION)) {
            logger.warning("Inconsistent component versions: " + AstObject.reportVersions());
        }
        AST__BAD = AstObject.getAstConstantD("AST__BAD");
    }

    private class AstStringer
    extends Channel {
        StringBuffer buf = new StringBuffer();

        private AstStringer() {
            this.setFull(-1);
            this.setComment(false);
        }

        protected void sink(String line) {
            this.buf.append(line + "\n");
        }

        synchronized String representation(AstObject ao) {
            try {
                this.write(ao);
                String result = this.buf.toString();
                this.buf.setLength(0);
                return result;
            }
            catch (IOException e) {
                return null;
            }
        }
    }
}

