/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import uk.ac.starlink.ast.AstObject;
import uk.ac.starlink.ast.Mapping;
import uk.ac.starlink.ast.NeedsChannelizing;
import uk.ac.starlink.ast.Transformer;
import uk.ac.starlink.ast.Transformer1;
import uk.ac.starlink.ast.Transformer2;

public class IntraMap
extends Mapping
implements NeedsChannelizing {
    private Transformer trans;
    private static final byte[] Chrs64 = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] Inv64 = new byte[256];

    public IntraMap(Transformer trans, int nin, int nout) {
        this.trans = trans;
        this.construct(trans, nin, nout);
    }

    private native void construct(Transformer var1, int var2, int var3);

    public IntraMap(Transformer2 trans) {
        this.trans = trans;
        this.construct(trans, 2, 2);
    }

    public IntraMap(Transformer1 trans) {
        this.trans = trans;
        this.construct(trans, 1, 1);
    }

    public void finalize() throws Throwable {
        this.destroy();
        this.trans = null;
        super.finalize();
    }

    private native void destroy();

    public void channelize() throws IOException {
        if (!(this.trans instanceof Serializable)) {
            throw new NotSerializableException(this.trans.getClass().getName());
        }
        Serializable strans = (Serializable)((Object)this.trans);
        ByteArrayOutputStream bstream = new ByteArrayOutputStream();
        ObjectOutputStream ostream = new ObjectOutputStream(bstream);
        ostream.writeObject(strans);
        ostream.flush();
        byte[] transRep = IntraMap.encodePrintable(bstream.toByteArray());
        this.setC("IntraFlag", new String(transRep));
    }

    public void unChannelize() throws IOException {
        int nin = this.getNin();
        int nout = this.getNout();
        String transString = this.getC("IntraFlag");
        byte[] transEncBytes = transString.getBytes("UTF-8");
        byte[] transBytes = IntraMap.decodePrintable(transEncBytes);
        ByteArrayInputStream bstream = new ByteArrayInputStream(transBytes);
        ObjectInputStream ostream = new ObjectInputStream(bstream);
        try {
            this.trans = (Transformer)ostream.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new Error(e.getMessage());
        }
        this.construct(this.trans, nin, nout);
    }

    public AstObject copy() {
        AstObject copy = super.copy();
        ((IntraMap)copy).trans = this.trans;
        return copy;
    }

    public Object clone() {
        Object clone = super.clone();
        ((IntraMap)clone).trans = this.trans;
        return clone;
    }

    private static byte[] encodePrintable(byte[] plain) {
        int leng = plain.length;
        byte[] coded = new byte[(leng / 3 + 2) * 4];
        int ic = 0;
        int ip = 0;
        while (ip < leng) {
            byte b0 = ip < leng ? plain[ip++] : (byte)0;
            byte b1 = ip < leng ? plain[ip++] : (byte)0;
            byte b2 = ip < leng ? plain[ip++] : (byte)0;
            byte ix0 = (byte)(b0 & 0x3F);
            byte ix1 = (byte)((b0 & 0xC0) >>> 6 | (b1 & 0xF) << 2);
            byte ix2 = (byte)((b1 & 0xF0) >>> 4 | (b2 & 3) << 4);
            byte ix3 = (byte)((b2 & 0xFC) >>> 2);
            coded[ic++] = Chrs64[ix0];
            coded[ic++] = Chrs64[ix1];
            coded[ic++] = Chrs64[ix2];
            coded[ic++] = Chrs64[ix3];
        }
        return coded;
    }

    private static byte[] decodePrintable(byte[] coded) {
        int leng = coded.length;
        byte[] plain = new byte[(leng / 4 + 2) * 3];
        int ic = 0;
        int ip = 0;
        while (ic < leng) {
            byte b0 = ic < leng ? Inv64[coded[ic++]] : (byte)0;
            byte b1 = ic < leng ? Inv64[coded[ic++]] : (byte)0;
            byte b2 = ic < leng ? Inv64[coded[ic++]] : (byte)0;
            byte b3 = ic < leng ? Inv64[coded[ic++]] : (byte)0;
            byte iv0 = (byte)(b0 | b1 << 6);
            byte iv1 = (byte)(b1 >>> 2 | b2 << 4);
            byte iv2 = (byte)(b2 >>> 4 | b3 << 2);
            plain[ip++] = iv0;
            plain[ip++] = iv1;
            plain[ip++] = iv2;
        }
        return plain;
    }

    static {
        for (int i = 0; i < 64; i = (int)((byte)(i + 1))) {
            IntraMap.Inv64[IntraMap.Chrs64[i]] = i;
        }
    }
}

