/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast;

import uk.ac.starlink.ast.AstException;
import uk.ac.starlink.ast.Mapping;

public class MatrixMap
extends Mapping {
    private native void construct(int var1, int var2, int var3, double[] var4);

    public MatrixMap(int nin, int nout, double[][] fullmatrix) {
        double[] matrix;
        if (fullmatrix.length == nout) {
            matrix = new double[nin * nout];
            for (int i = 0; i < nout; ++i) {
                if (fullmatrix[i].length != nin) {
                    throw new AstException("construction matrix is the wrong shape");
                }
                System.arraycopy(fullmatrix[i], 0, matrix, nin * i, nin);
            }
        } else {
            throw new AstException("construction matrix is the wrong shape");
        }
        this.construct(nin, nout, 0, matrix);
    }

    public MatrixMap(int nin, int nout, double[] diag) {
        if (diag.length < nin && diag.length < nout) {
            throw new AstException("construction matrix is the wrong shape");
        }
        double[] matrix = diag;
        this.construct(nin, nout, 1, matrix);
    }

    public MatrixMap(int nin, int nout) {
        this.construct(nin, nout, 2, null);
    }
}

