/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast;

import uk.ac.starlink.ast.Frame;
import uk.ac.starlink.ast.Mapping;

public abstract class Region
extends Frame {
    public static final int OVERLAP_UNKNOWN = 0;
    public static final int OVERLAP_NONE = 1;
    public static final int OVERLAP_INSIDE = 2;
    public static final int OVERLAP_OUTSIDE = 3;
    public static final int OVERLAP_PARTIAL = 4;
    public static final int OVERLAP_SAME = 5;
    public static final int OVERLAP_NEGATE = 6;

    Region() {
    }

    public native double[][] getRegionBounds();

    public native Frame getRegionFrame();

    public native Region getUnc(boolean var1);

    public native Region mapRegion(Mapping var1, Frame var2);

    public native void negate();

    public native int overlap(Region var1);

    public int mask(Mapping map, boolean inside, int ndim, int[] lbnd, int[] ubnd, Object in, Number val) {
        Class<?> type = in.getClass().getComponentType();
        try {
            if (type == Byte.TYPE) {
                return this.maskB(map, inside, ndim, lbnd, ubnd, (byte[])in, (Byte)val);
            }
            if (type == Short.TYPE) {
                return this.maskS(map, inside, ndim, lbnd, ubnd, (short[])in, (Short)val);
            }
            if (type == Integer.TYPE) {
                return this.maskI(map, inside, ndim, lbnd, ubnd, (int[])in, (Integer)val);
            }
            if (type == Long.TYPE) {
                return this.maskL(map, inside, ndim, lbnd, ubnd, (long[])in, (Long)val);
            }
            if (type == Float.TYPE) {
                return this.maskF(map, inside, ndim, lbnd, ubnd, (float[])in, ((Float)val).floatValue());
            }
            if (type == Double.TYPE) {
                return this.maskD(map, inside, ndim, lbnd, ubnd, (double[])in, (Double)val);
            }
            throw new ClassCastException("dummy ClassCastException");
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Bad class " + in.getClass() + " for map 'in' param");
        }
    }

    public native int maskB(Mapping var1, boolean var2, int var3, int[] var4, int[] var5, byte[] var6, byte var7);

    public native int maskS(Mapping var1, boolean var2, int var3, int[] var4, int[] var5, short[] var6, short var7);

    public native int maskI(Mapping var1, boolean var2, int var3, int[] var4, int[] var5, int[] var6, int var7);

    public native int maskL(Mapping var1, boolean var2, int var3, int[] var4, int[] var5, long[] var6, long var7);

    public native int maskF(Mapping var1, boolean var2, int var3, int[] var4, int[] var5, float[] var6, float var7);

    public native int maskD(Mapping var1, boolean var2, int var3, int[] var4, int[] var5, double[] var6, double var7);

    public native void setUnc(Region var1);

    public boolean getAdaptive() {
        return this.getB("Adaptive");
    }

    public void setAdaptive(boolean adaptive) {
        this.setB("Adaptive", adaptive);
    }

    public boolean getNegated() {
        return this.getB("Negated");
    }

    public void setNegated(boolean negated) {
        this.setB("Negated", negated);
    }

    public boolean getClosed() {
        return this.getB("Closed");
    }

    public void setClosed(boolean closed) {
        this.setB("Closed", closed);
    }

    public int getMeshSize() {
        return this.getI("MeshSize");
    }

    public void setMeshSize(int meshSize) {
        this.setI("MeshSize", meshSize);
    }

    public double getFillFactor() {
        return this.getD("FillFactor");
    }

    public void setFillFactor(double fillFactor) {
        this.setD("FillFactor", fillFactor);
    }

    public boolean getBounded() {
        return this.getB("Bounded");
    }
}

