/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast.grf;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import uk.ac.starlink.ast.AstObject;
import uk.ac.starlink.ast.Grf;
import uk.ac.starlink.ast.grf.DefaultGrfContainer;
import uk.ac.starlink.ast.grf.DefaultGrfFontManager;
import uk.ac.starlink.ast.grf.DefaultGrfMarker;
import uk.ac.starlink.ast.grf.DefaultGrfState;

public class DefaultGrf
implements Grf {
    public static final int GRF__ALPHA = 5;
    public static final double BAD = AstObject.AST__BAD;
    public static final int PLAIN = 1;
    public static final int DASH = 2;
    public static final int DOT = 3;
    public static final int SHORTDASH = 4;
    public static final int LONGDASH = 5;
    public static final int DOTDASH = 6;
    public static final String DEFAULT = "DEFAULT";
    private JComponent component = null;
    private DefaultGrfState gstate = new DefaultGrfState();
    private ArrayList currentContext = null;
    private ArrayList masterContext = new ArrayList();
    private Map masterMap = new HashMap();
    private DefaultGrfFontManager grfFontManager = DefaultGrfFontManager.getReference();

    public DefaultGrf() {
        this.establishContext(DEFAULT);
    }

    public DefaultGrf(JComponent component) {
        this.establishContext(DEFAULT);
        this.component = component;
    }

    public void setGraphic(JComponent component) {
        this.component = component;
    }

    public JComponent getGraphic() {
        return this.component;
    }

    public void establishContext(String key) {
        if ((key == null || key.equals(DEFAULT)) && this.masterContext.size() != 0) {
            this.currentContext = (ArrayList)this.masterMap.get(key);
            return;
        }
        this.currentContext = new ArrayList();
        this.masterMap.put(key, this.currentContext);
        this.masterContext.add(this.currentContext);
    }

    public void paint(Graphics2D g2) {
        this.update(g2);
    }

    public void reset() {
        this.masterContext.clear();
        this.gstate = new DefaultGrfState();
        this.establishContext(DEFAULT);
    }

    public Object remove(String key) {
        Object removedList = this.masterMap.remove(key);
        if (removedList != null) {
            this.masterContext.remove(removedList);
            this.masterMap.put(key, null);
        }
        this.gstate = new DefaultGrfState();
        return removedList;
    }

    public void reAdd(String key, Object context) {
        if (key == null || key.equals(DEFAULT)) {
            return;
        }
        if (context instanceof ArrayList) {
            this.currentContext = (ArrayList)context;
            this.masterMap.put(key, this.currentContext);
            this.masterContext.add(this.currentContext);
        }
    }

    public void polyline(double[] x, double[] y) {
        if (this.component != null) {
            DefaultGrfContainer g = new DefaultGrfContainer(1, x, y, this.gstate);
            this.currentContext.add(g);
        }
    }

    public void marker(double[] x, double[] y, int type) {
        if (this.component != null) {
            DefaultGrfContainer g = new DefaultGrfContainer(3, x, y, type, this.gstate);
            this.currentContext.add(g);
        }
    }

    public void text(String text, double x, double y, String just, double upx, double upy) {
        if (this.component != null) {
            DefaultGrfContainer g = this.textProperties(text, x, y, just, upx, upy);
            this.currentContext.add(g);
        }
    }

    protected DefaultGrfContainer textProperties(String text, double x, double y, String just, double upx, double upy) {
        double[] bbox;
        Graphics2D g2 = (Graphics2D)this.component.getGraphics();
        Font f2 = this.grfFontManager.getFont((int)this.gstate.getFont());
        double scale = this.gstate.getSize();
        FontRenderContext frc = g2.getFontRenderContext();
        Rectangle2D rect = f2.getStringBounds(text, frc);
        bbox = new double[]{rect.getX(), rect.getY(), bbox[0] + rect.getWidth(), bbox[1], bbox[2], bbox[1] + rect.getHeight(), bbox[0], bbox[5]};
        int i = 0;
        while (i < 7) {
            int n = i++;
            bbox[n] = bbox[n] * scale;
        }
        double angle = -Math.atan2(-upx, upy);
        double[] anchor = this.getAnchor(just, angle, x, y, bbox);
        AffineTransform trans = AffineTransform.getTranslateInstance(anchor[0], anchor[1]);
        trans.rotate(angle);
        trans.scale(scale, scale);
        double[] bounds = new double[8];
        trans.transform(bbox, 0, bounds, 0, 4);
        return new DefaultGrfContainer(2, text, anchor[0], anchor[1], angle, bounds, this.gstate);
    }

    public void flush() {
        if (this.component != null) {
            this.component.repaint();
        }
    }

    public double[] textExtent(String text, double x, double y, String just, double upx, double upy) {
        if (this.component != null) {
            DefaultGrfContainer cont = this.textProperties(text, x, y, just, upx, upy);
            return cont.getBBox();
        }
        return null;
    }

    public double[] charHeight() {
        double[] sizes = new double[2];
        double[] bounds = this.textExtent("ABCD", 0.0, 0.0, "CC", 1.0, 0.0);
        sizes[0] = bounds[4] - bounds[0];
        bounds = this.textExtent("ABCD", 0.0, 0.0, "CC", 0.0, 1.0);
        sizes[1] = bounds[5] - bounds[1];
        return sizes;
    }

    /*
     * WARNING - void declaration
     */
    public double attribute(int attr, double value, int prim) {
        void var8_4;
        double oldValue;
        if (attr == GRF__STYLE) {
            oldValue = this.gstate.getStyle();
            if (value != BAD) {
                this.gstate.setStyle(value);
            }
        } else if (attr == GRF__WIDTH) {
            oldValue = this.gstate.getWidth();
            if (value != BAD) {
                this.gstate.setWidth(Math.max(1.0, value));
            }
        } else if (attr == GRF__SIZE) {
            oldValue = this.gstate.getSize();
            if (value != BAD) {
                this.gstate.setSize(value);
            }
        } else if (attr == GRF__FONT) {
            oldValue = this.gstate.getFont();
            if (value != BAD) {
                this.gstate.setFont(value);
            }
        } else if (attr == GRF__COLOUR) {
            oldValue = this.gstate.getColour();
            if (value != BAD) {
                this.gstate.setColour(value);
            }
        } else if (attr == 5) {
            oldValue = this.gstate.getAlpha();
            if (value != BAD) {
                this.gstate.setAlpha(Math.min(1.0, Math.max(0.0, value)));
            }
        } else {
            return BAD;
        }
        return (double)var8_4;
    }

    public double[] axisScale() {
        double[] scales;
        scales = new double[]{0.013888888888888888, -scales[0]};
        return scales;
    }

    public int addFont(Font font) {
        return this.grfFontManager.add(font);
    }

    public int deleteFont(Font font) {
        return this.grfFontManager.remove(font);
    }

    public int getFontIndex(Font font) {
        return this.grfFontManager.getIndex(font);
    }

    public Font getFont(int index) {
        return this.grfFontManager.getFont(index);
    }

    public void setClipRegion(Rectangle region) {
        this.gstate.setClip(region);
    }

    protected double[] getAnchor(String just, double angle, double x, double y, double[] bbox) {
        int lenJust = just.length();
        char[] localJust = new char[2];
        double[] anchor = new double[2];
        if (lenJust == 0) {
            localJust[0] = 67;
            localJust[1] = 67;
        } else if (lenJust == 1) {
            localJust[0] = just.charAt(0);
            localJust[1] = 67;
        } else {
            localJust[0] = just.charAt(0);
            localJust[1] = just.charAt(1);
        }
        double w = bbox[2] - bbox[0];
        double h = bbox[5] - bbox[1];
        block0 : switch (localJust[0]) {
            case 'C': {
                switch (localJust[1]) {
                    case 'C': {
                        anchor[0] = x - w * 0.5 * Math.cos(angle) - h * 0.5 * Math.sin(angle);
                        anchor[1] = y - w * 0.5 * Math.sin(angle) + h * 0.5 * Math.cos(angle);
                        break;
                    }
                    case 'L': {
                        anchor[0] = x - h * 0.5 * Math.sin(angle);
                        anchor[1] = y + h * 0.5 * Math.cos(angle);
                        break;
                    }
                    case 'R': {
                        anchor[0] = x - w * Math.cos(angle) - h * 0.5 * Math.sin(angle);
                        anchor[1] = y - w * Math.sin(angle) + h * 0.5 * Math.cos(angle);
                    }
                }
                break;
            }
            case 'T': {
                switch (localJust[1]) {
                    case 'C': {
                        anchor[0] = x - w * 0.5 * Math.cos(angle) - h * Math.sin(angle);
                        anchor[1] = y - w * 0.5 * Math.sin(angle) + h * Math.cos(angle);
                        break;
                    }
                    case 'L': {
                        anchor[0] = x - h * Math.sin(angle);
                        anchor[1] = y + h * Math.cos(angle);
                        break;
                    }
                    case 'R': {
                        anchor[0] = x - w * Math.cos(angle) - h * Math.sin(angle);
                        anchor[1] = y - w * Math.sin(angle) + h * Math.cos(angle);
                    }
                }
                break;
            }
            case 'B': {
                switch (localJust[1]) {
                    case 'C': {
                        anchor[0] = x - w * 0.5 * Math.cos(angle);
                        anchor[1] = y - w * 0.5 * Math.sin(angle);
                        break block0;
                    }
                    case 'L': {
                        anchor[0] = x;
                        anchor[1] = y;
                        break block0;
                    }
                    case 'R': {
                        anchor[0] = x - w * Math.cos(angle);
                        anchor[1] = y - w * Math.sin(angle);
                    }
                }
            }
        }
        return anchor;
    }

    protected void update(Graphics2D g2) {
        ArrayList context = null;
        int size = 0;
        for (int j = 0; j < this.masterContext.size(); ++j) {
            context = (ArrayList)this.masterContext.get(j);
            size = context.size();
            for (int i = 0; i < size; ++i) {
                DefaultGrfContainer cont = (DefaultGrfContainer)context.get(i);
                if (cont.getType() == 1) {
                    DefaultGrf.drawLine(g2, cont);
                    continue;
                }
                if (cont.getType() == 3) {
                    this.drawMark(g2, cont);
                    continue;
                }
                if (cont.getType() != 2) continue;
                this.drawText(g2, cont);
            }
        }
    }

    public static void drawLine(Graphics2D g2, DefaultGrfContainer cont) {
        double[] xPos = cont.getXPositions();
        double[] yPos = cont.getYPositions();
        DefaultGrfState gstate = cont.getGrfState();
        Color oldcolour = g2.getColor();
        g2.setColor(new Color((int)gstate.getColour()));
        Stroke oldstroke = g2.getStroke();
        g2.setStroke(DefaultGrf.lineStroke((int)gstate.getStyle(), (float)gstate.getWidth()));
        Rectangle localClip = gstate.getClip();
        Shape oldclip = g2.getClip();
        if (localClip != null) {
            g2.clipRect(localClip.x, localClip.y, localClip.width, localClip.height);
        }
        Rectangle globalClip = g2.getClipBounds();
        Composite oldAlpha = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, (float)gstate.getAlpha()));
        int xlower = Integer.MIN_VALUE;
        int xupper = Integer.MAX_VALUE;
        if (globalClip != null) {
            xlower = globalClip.x - globalClip.width;
            xupper = globalClip.x + globalClip.width * 2;
        }
        int[] x = new int[xPos.length];
        int[] y = new int[xPos.length];
        int j = 0;
        int t = 0;
        if (xPos.length > 20) {
            for (int i = 0; i < xPos.length; ++i) {
                if (xPos[i] != BAD && yPos[i] != BAD) {
                    x[j] = (int)xPos[i];
                    if (x[j] <= xlower || x[j] >= xupper) continue;
                    y[j] = (int)yPos[i];
                    if (j > 0) {
                        if (y[j] == y[j - 1] && x[j] == x[j - 1]) continue;
                        ++j;
                        ++t;
                        continue;
                    }
                    j = 1;
                    continue;
                }
                if (j <= 0) continue;
                g2.drawPolyline(x, y, j);
                j = 0;
            }
            if (j > 0) {
                g2.drawPolyline(x, y, j);
            }
            if (t < 4) {
                int[] bounds = DefaultGrf.bound(xlower, xPos);
                int lower = Math.max(0, bounds[0] - 5);
                int upper = Math.min(xPos.length, bounds[1] + 5);
                j = 0;
                for (int i = lower; i < upper; ++i) {
                    if (xPos[i] != BAD && yPos[i] != BAD) {
                        x[j] = (int)xPos[i];
                        y[j] = (int)yPos[i];
                        ++j;
                        continue;
                    }
                    if (j <= 0) continue;
                    g2.drawPolyline(x, y, j);
                    j = 0;
                }
                if (j > 0) {
                    g2.drawPolyline(x, y, j);
                }
            }
        } else {
            for (int i = 0; i < xPos.length; ++i) {
                if (xPos[i] != BAD && yPos[i] != BAD) {
                    x[j] = (int)xPos[i];
                    y[j] = (int)yPos[i];
                    ++j;
                    continue;
                }
                if (j <= 0) continue;
                g2.drawPolyline(x, y, j);
                j = 0;
            }
            if (j > 0) {
                g2.drawPolyline(x, y, j);
            }
        }
        g2.setStroke(oldstroke);
        g2.setColor(oldcolour);
        g2.setClip(oldclip);
        g2.setComposite(oldAlpha);
    }

    public static Stroke lineStroke(int type, float width) {
        switch (type) {
            case 1: {
                return new BasicStroke(width, 0, 1);
            }
            case 2: {
                return new BasicStroke(width, 0, 1, 10.0f, new float[]{6.0f, 6.0f}, 0.0f);
            }
            case 4: {
                return new BasicStroke(width, 0, 1, 10.0f, new float[]{3.0f, 3.0f}, 0.0f);
            }
            case 3: {
                return new BasicStroke(width, 0, 1, 10.0f, new float[]{1.0f, 1.0f}, 0.0f);
            }
            case 5: {
                return new BasicStroke(width, 0, 1, 10.0f, new float[]{12.0f, 12.0f}, 0.0f);
            }
            case 6: {
                return new BasicStroke(width, 0, 1, 10.0f, new float[]{3.0f, 3.0f, 6.0f, 3.0f}, 0.0f);
            }
        }
        return new BasicStroke(width);
    }

    protected void drawText(Graphics2D g2, DefaultGrfContainer cont) {
        if (cont.getX() == BAD || cont.getY() == BAD) {
            return;
        }
        float x = (float)cont.getX();
        float y = (float)cont.getY();
        DefaultGrfState gstate = cont.getGrfState();
        Rectangle localClip = gstate.getClip();
        Shape oldclip = g2.getClip();
        if (localClip != null) {
            g2.clipRect(localClip.x, localClip.y, localClip.width, localClip.height);
        }
        if (localClip == null ? !g2.hitClip((int)x - 100, (int)y - 100, 200, 200) : !g2.hitClip((int)x, (int)y, 1, 1)) {
            return;
        }
        String text = cont.getText();
        double angle = cont.getAngle();
        double size = gstate.getSize();
        g2.setColor(new Color((int)gstate.getColour()));
        g2.setFont(this.grfFontManager.getFont((int)gstate.getFont()));
        AffineTransform oldtrans = g2.getTransform();
        g2.translate(x, y);
        if (size != 1.0) {
            g2.transform(AffineTransform.getScaleInstance(size, size));
        }
        if (angle != 0.0) {
            g2.transform(AffineTransform.getRotateInstance(angle));
        }
        g2.drawString(text, 0.0f, 0.0f);
        g2.setTransform(oldtrans);
        g2.setClip(oldclip);
    }

    protected void drawMark(Graphics2D g2, DefaultGrfContainer cont) {
        double[] x = cont.getXPositions();
        double[] y = cont.getYPositions();
        int type = cont.getInt();
        DefaultGrfState gstate = cont.getGrfState();
        double size = gstate.getSize();
        g2.setColor(new Color((int)gstate.getColour()));
        Stroke oldstroke = g2.getStroke();
        g2.setStroke(DefaultGrf.lineStroke((int)gstate.getStyle(), (float)gstate.getWidth()));
        Rectangle localClip = gstate.getClip();
        Shape oldclip = g2.getClip();
        if (localClip != null) {
            g2.clipRect(localClip.x, localClip.y, localClip.width, localClip.height);
        }
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == BAD || y[i] == BAD || !g2.hitClip((int)x[i], (int)y[i], 1, 1)) continue;
            DefaultGrfMarker.draw(g2, type, x[i], y[i], size);
        }
        g2.setStroke(oldstroke);
        g2.setClip(oldclip);
    }

    public static int[] bound(double xcoord, double[] values) {
        boolean increases;
        int low = 0;
        int high = values.length - 1;
        int mid = 0;
        boolean bl = increases = values[low] < values[high];
        if (increases) {
            while (low < high - 1) {
                mid = (low + high) / 2;
                if (xcoord < values[mid]) {
                    high = mid;
                    continue;
                }
                low = mid;
            }
        } else {
            while (low < high - 1) {
                mid = (low + high) / 2;
                if (xcoord > values[mid]) {
                    high = mid;
                    continue;
                }
                low = mid;
            }
        }
        int[] bounds = new int[]{low, high};
        return bounds;
    }

    public static int encodeColor(Color colour) {
        int result = colour.getRGB();
        if (result == -1) {
            result = 0;
        }
        return result;
    }

    public static Color decodeColor(int value) {
        if (value == 0) {
            value = -1;
        }
        return new Color(value);
    }

    public void paint(Graphics g) {
        this.update((Graphics2D)g);
    }

    public void clear() {
        this.reset();
    }

    public void line(int n, float[] x, float[] y) {
        double[] dx = new double[n];
        double[] dy = new double[n];
        for (int i = 0; i < n; ++i) {
            dx[i] = x[i];
            dy[i] = y[i];
        }
        this.polyline(dx, dy);
    }

    public void mark(int n, float[] x, float[] y, int type) {
        double[] dx = new double[n];
        double[] dy = new double[n];
        for (int i = 0; i < n; ++i) {
            dx[i] = x[i];
            dy[i] = y[i];
        }
        this.marker(dx, dy, type);
    }

    public void text(String text, float x, float y, String just, float upx, float upy) {
        this.text(text, (double)x, (double)y, just, (double)upx, (double)upy);
    }

    public double attr(int attr, double value, int prim) {
        if (attr == GRF__COLOUR) {
            double retalpha;
            double retrgb;
            if (value != AstObject.AST__BAD) {
                int ivalue = (int)value;
                if (ivalue == 0) {
                    ivalue = -1;
                }
                double rgb = ivalue & 0xFFFFFF;
                int opaque = (ivalue & 0xFF000000) >>> 24;
                double alpha = (double)opaque / 255.0;
                retrgb = this.attribute(GRF__COLOUR, rgb, prim);
                retalpha = this.attribute(5, alpha, prim);
            } else {
                retrgb = this.attribute(GRF__COLOUR, AstObject.AST__BAD, prim);
                retalpha = this.attribute(5, AstObject.AST__BAD, prim);
            }
            int retopaque = (int)(retalpha * 255.9);
            double result = retopaque << 24 | (int)retrgb;
            if (result == -1.0) {
                result = 0.0;
            }
            return result;
        }
        return this.attribute(attr, value, prim);
    }

    public float[] qch() {
        double[] dch = this.charHeight();
        return new float[]{(float)dch[0], (float)dch[1]};
    }

    public float[][] txExt(String text, float x, float y, String just, float upx, float upy) {
        double[] dte = this.textExtent(text, x, y, just, upx, upy);
        float[] xte = new float[]{(float)dte[6], (float)dte[4], (float)dte[2], (float)dte[0]};
        float[] yte = new float[]{(float)dte[7], (float)dte[5], (float)dte[3], (float)dte[1]};
        return new float[][]{xte, yte};
    }

    public int cap(int cap, int value) {
        if (cap == GRF__SCALES) {
            return 1;
        }
        return 0;
    }

    public float[] scales() {
        return new float[]{1.0f, -1.0f};
    }
}

