/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast.grf;

import java.util.ArrayList;
import uk.ac.starlink.ast.AstObject;

public class GrfEscape {
    public static final int GRF__ESPER = AstObject.getAstConstantI("GRF__ESPER");
    public static final int GRF__ESSUP = AstObject.getAstConstantI("GRF__ESSUP");
    public static final int GRF__ESSUB = AstObject.getAstConstantI("GRF__ESSUB");
    public static final int GRF__ESGAP = AstObject.getAstConstantI("GRF__ESGAP");
    public static final int GRF__ESBAC = AstObject.getAstConstantI("GRF__ESBAC");
    public static final int GRF__ESSIZ = AstObject.getAstConstantI("GRF__ESSIZ");
    public static final int GRF__ESWID = AstObject.getAstConstantI("GRF__ESWID");
    public static final int GRF__ESFON = AstObject.getAstConstantI("GRF__ESFON");
    public static final int GRF__ESCOL = AstObject.getAstConstantI("GRF__ESCOL");
    public static final int GRF__ESSTY = AstObject.getAstConstantI("GRF__ESSTY");
    public static final int GRF__ESPOP = AstObject.getAstConstantI("GRF__ESPOP");
    public static final int GRF__ESPSH = AstObject.getAstConstantI("GRF__ESPSH");
    private final int code;
    private final int value;

    public GrfEscape(int code, int value) {
        this.code = code;
        this.value = value;
    }

    public int getCode() {
        return this.code;
    }

    public int getValue() {
        return this.value;
    }

    public String getText() {
        String valSeq;
        boolean start = this.value >= 0;
        String string = valSeq = this.value >= 0 ? this.value + "+" : "+";
        if (this.code == GRF__ESPER) {
            return "%%";
        }
        if (this.code == GRF__ESSUP) {
            return "%^" + valSeq;
        }
        if (this.code == GRF__ESSUB) {
            return "%v" + valSeq;
        }
        if (this.code == GRF__ESGAP) {
            return "%>" + this.value + "+";
        }
        if (this.code == GRF__ESBAC) {
            return "%<" + this.value + "+";
        }
        if (this.code == GRF__ESSIZ) {
            return "%s" + valSeq;
        }
        if (this.code == GRF__ESWID) {
            return "%w" + valSeq;
        }
        if (this.code == GRF__ESFON) {
            return "%f" + valSeq;
        }
        if (this.code == GRF__ESCOL) {
            return "%c" + valSeq;
        }
        if (this.code == GRF__ESSTY) {
            return "%t" + valSeq;
        }
        if (this.code == GRF__ESPSH) {
            return "%+";
        }
        if (this.code == GRF__ESPOP) {
            return "%-";
        }
        return "%?+";
    }

    public String toString() {
        return this.getText();
    }

    public boolean equals(Object o) {
        if (o instanceof GrfEscape) {
            GrfEscape other = (GrfEscape)o;
            return other.getCode() == this.getCode() && other.getValue() == this.getValue();
        }
        return false;
    }

    public int hashCode() {
        int h = 5;
        h = h * 23 + this.getCode();
        h = h * 23 + this.getValue();
        return h;
    }

    public static void setEscapes(boolean escapes) {
        GrfEscape.escapes(escapes ? 1 : 0);
    }

    public static boolean getEscapes() {
        return GrfEscape.escapes(-1);
    }

    private static native boolean escapes(int var0);

    private static native boolean findEscape(String var0, int[] var1);

    public static Object[] findEscapes(String text) {
        int[] results;
        ArrayList<Object> answer = new ArrayList<Object>();
        for (int pos = 0; pos < text.length(); pos += results[2]) {
            results = new int[3];
            boolean found = GrfEscape.findEscape(text.substring(pos), results);
            if (found) {
                answer.add(new GrfEscape(results[0], results[1]));
                continue;
            }
            answer.add(text.substring(pos, pos + results[2]));
        }
        return answer.toArray();
    }
}

