/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.CrosshairInfo;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.XYItemRenderer;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.chart.tooltips.XYToolTipGenerator;
import com.jrefinery.data.XYDataset;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public abstract class AbstractXYItemRenderer
implements XYItemRenderer {
    protected ChartRenderingInfo info;
    protected XYToolTipGenerator toolTipGenerator;
    protected PropertyChangeSupport listeners;

    protected AbstractXYItemRenderer() {
        this(null);
    }

    protected AbstractXYItemRenderer(XYToolTipGenerator xYToolTipGenerator) {
        this.toolTipGenerator = xYToolTipGenerator;
        this.listeners = new PropertyChangeSupport(this);
    }

    public void initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, ChartRenderingInfo chartRenderingInfo) {
        this.info = chartRenderingInfo;
    }

    public XYToolTipGenerator getToolTipGenerator() {
        return this.toolTipGenerator;
    }

    public void setToolTipGenerator(XYToolTipGenerator xYToolTipGenerator) {
        this.toolTipGenerator = xYToolTipGenerator;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.removePropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChanged(String string, Object object, Object object2) {
        this.listeners.firePropertyChange(string, object, object2);
    }

    public abstract void drawItem(Graphics2D var1, Rectangle2D var2, ChartRenderingInfo var3, XYPlot var4, ValueAxis var5, ValueAxis var6, XYDataset var7, int var8, int var9, CrosshairInfo var10);
}

