/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AbstractXYItemRenderer;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.CrosshairInfo;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.XYItemRenderer;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.chart.entity.XYItemEntity;
import com.jrefinery.chart.tooltips.XYToolTipGenerator;
import com.jrefinery.data.XYDataset;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class AreaXYItemRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer {
    public static final int SHAPES = 1;
    public static final int LINES = 2;
    public static final int SHAPES_AND_LINES = 3;
    public static final int AREA = 4;
    public static final int AREA_AND_SHAPES = 5;
    protected boolean plotShapes;
    protected boolean plotLines;
    protected boolean plotArea;
    protected double shapeScale = 6.0;
    protected boolean showOutline;
    protected double zeroToJava2D;
    protected Line2D line;
    protected Polygon pArea = null;

    public AreaXYItemRenderer() {
        this(4);
    }

    public AreaXYItemRenderer(int n) {
        this(n, null);
    }

    public AreaXYItemRenderer(int n, XYToolTipGenerator xYToolTipGenerator) {
        super(xYToolTipGenerator);
        if (n == 1) {
            this.plotShapes = true;
        }
        if (n == 2) {
            this.plotLines = true;
        }
        if (n == 3) {
            this.plotShapes = true;
            this.plotLines = true;
        }
        if (n == 4) {
            this.plotArea = true;
        }
        if (n == 5) {
            this.plotArea = true;
            this.plotShapes = true;
        }
        this.line = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
        this.showOutline = false;
    }

    public boolean isOutline() {
        return this.showOutline;
    }

    public void setOutline(boolean bl) {
        this.showOutline = bl;
    }

    public boolean getPlotShapes() {
        return this.plotShapes;
    }

    public boolean getPlotLines() {
        return this.plotLines;
    }

    public boolean getPlotArea() {
        return this.plotArea;
    }

    public void initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, ChartRenderingInfo chartRenderingInfo) {
        super.initialise(graphics2D, rectangle2D, xYPlot, xYDataset, chartRenderingInfo);
        ValueAxis valueAxis = xYPlot.getRangeAxis();
        this.zeroToJava2D = valueAxis.translateValueToJava2D(0.0, rectangle2D);
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairInfo crosshairInfo) {
        Object object;
        Object object2;
        int n3 = xYDataset.getItemCount(n);
        Paint paint = xYPlot.getSeriesPaint(n);
        Stroke stroke = xYPlot.getSeriesStroke(n);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        Number number = xYDataset.getXValue(n, n2);
        Number number2 = xYDataset.getYValue(n, n2);
        double d = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D);
        double d2 = valueAxis2.translateValueToJava2D(number2.doubleValue(), rectangle2D);
        if (n2 == 0) {
            this.pArea = new Polygon();
            double d3 = valueAxis2.translateValueToJava2D(0.0, rectangle2D);
            this.pArea.addPoint((int)d, (int)d3);
        }
        this.pArea.addPoint((int)d, (int)d2);
        Shape shape = null;
        if (this.plotShapes) {
            shape = xYPlot.getShape(n, n2, d, d2, this.shapeScale);
            graphics2D.draw(shape);
        } else {
            shape = new Rectangle2D.Double(d - 2.0, d2 - 2.0, 4.0, 4.0);
        }
        if (this.plotLines && n2 > 0) {
            object2 = xYDataset.getXValue(n, n2 - 1);
            object = xYDataset.getYValue(n, n2 - 1);
            double d4 = valueAxis.translateValueToJava2D(((Number)object2).doubleValue(), rectangle2D);
            double d5 = valueAxis2.translateValueToJava2D(((Number)object).doubleValue(), rectangle2D);
            this.line.setLine(d4, d5, d, d2);
            graphics2D.draw(this.line);
        }
        if (this.plotArea && n2 > 0 && n2 == n3 - 1) {
            double d6 = valueAxis2.translateValueToJava2D(0.0, rectangle2D);
            this.pArea.addPoint((int)d, (int)d6);
            graphics2D.fill(this.pArea);
            if (this.showOutline) {
                graphics2D.setStroke(xYPlot.outlineStroke);
                graphics2D.setPaint(xYPlot.outlinePaint);
                graphics2D.draw(this.pArea);
            }
        }
        if (valueAxis.isCrosshairLockedOnData()) {
            if (valueAxis2.isCrosshairLockedOnData()) {
                crosshairInfo.updateCrosshairPoint(number.doubleValue(), number2.doubleValue());
            } else {
                crosshairInfo.updateCrosshairX(number.doubleValue());
            }
        } else if (valueAxis2.isCrosshairLockedOnData()) {
            crosshairInfo.updateCrosshairY(number2.doubleValue());
        }
        if (this.info != null && (object2 = this.info.getEntityCollection()) != null && shape != null) {
            object = "";
            if (this.toolTipGenerator != null) {
                object = this.toolTipGenerator.generateToolTip(xYDataset, n, n2);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(shape, (String)object, n, n2);
            object2.addEntity(xYItemEntity);
        }
    }
}

