/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisNotCompatibleException;
import com.jrefinery.chart.CategoryAxis;
import com.jrefinery.chart.CategoryItemRenderer;
import com.jrefinery.chart.CategoryPlotConstants;
import com.jrefinery.chart.Marker;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.PlotNotCompatibleException;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.event.PlotChangeEvent;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.Dataset;
import com.jrefinery.data.DatasetChangeEvent;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public abstract class CategoryPlot
extends Plot
implements CategoryPlotConstants {
    protected CategoryPlot parent;
    protected CategoryAxis domainAxis;
    protected ValueAxis rangeAxis;
    protected List markers;
    protected CategoryItemRenderer renderer;
    protected double introGapPercent;
    protected double trailGapPercent;
    protected double categoryGapsPercent;
    protected double itemGapsPercent;
    protected boolean labelsVisible;
    protected Font labelFont;
    protected Paint labelPaint;
    protected String labelFormatPattern;
    protected NumberFormat labelFormatter;
    protected boolean verticalLabels;

    protected CategoryPlot(CategoryDataset categoryDataset, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryItemRenderer categoryItemRenderer) {
        this(categoryDataset, categoryAxis, valueAxis, categoryItemRenderer, Plot.DEFAULT_INSETS, Plot.DEFAULT_BACKGROUND_PAINT, null, 1.0f, Plot.DEFAULT_OUTLINE_STROKE, Plot.DEFAULT_OUTLINE_PAINT, 1.0f, 0.05, 0.05, 0.2, 0.15);
    }

    protected CategoryPlot(CategoryDataset categoryDataset, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryItemRenderer categoryItemRenderer, Insets insets, Paint paint, Image image, float f, Stroke stroke, Paint paint2, float f2, double d, double d2, double d3, double d4) {
        super((Dataset)categoryDataset, insets, paint, image, f, stroke, paint2, f2);
        this.renderer = categoryItemRenderer;
        this.domainAxis = categoryAxis;
        if (categoryAxis != null) {
            categoryAxis.setPlot(this);
            categoryAxis.addChangeListener(this);
        }
        this.rangeAxis = valueAxis;
        if (valueAxis != null) {
            valueAxis.setPlot(this);
            valueAxis.addChangeListener(this);
        }
        this.markers = new ArrayList();
        this.markers.add(new Marker(0.0, new Color(0.8f, 0.8f, 0.8f, 0.5f), new Color(0.85f, 0.85f, 0.95f, 0.5f), 0.6f));
        this.insets = insets;
        this.introGapPercent = d;
        this.trailGapPercent = d2;
        this.categoryGapsPercent = d3;
        this.itemGapsPercent = d4;
        this.labelsVisible = false;
        this.labelFont = CategoryPlotConstants.DEFAULT_LABEL_FONT;
        this.labelPaint = Color.black;
        this.labelFormatter = NumberFormat.getInstance();
        this.labelFormatPattern = null;
        this.verticalLabels = false;
    }

    public boolean isSubplot() {
        return this.parent != null;
    }

    public CategoryPlot getParent() {
        return this.parent;
    }

    public void setParent(CategoryPlot categoryPlot) {
        this.parent = categoryPlot;
    }

    public int getSeriesCount() {
        int n = 0;
        CategoryDataset categoryDataset = this.getCategoryDataset();
        if (categoryDataset != null) {
            n = categoryDataset.getSeriesCount();
        }
        return n;
    }

    public List getLegendItemLabels() {
        ArrayList<String> arrayList = new ArrayList<String>();
        CategoryDataset categoryDataset = this.getCategoryDataset();
        if (categoryDataset != null) {
            int n = categoryDataset.getSeriesCount();
            int n2 = 0;
            while (n2 < n) {
                arrayList.add(categoryDataset.getSeriesName(n2));
                ++n2;
            }
        }
        return arrayList;
    }

    public CategoryItemRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(CategoryItemRenderer categoryItemRenderer) {
        this.renderer = categoryItemRenderer;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getIntroGapPercent() {
        return this.introGapPercent;
    }

    public void setIntroGapPercent(double d) {
        if (d < 0.0 || d > 0.2) {
            throw new IllegalArgumentException("BarPlot.setIntroGapPercent(double): argument outside valid range.");
        }
        if (this.introGapPercent != d) {
            this.introGapPercent = d;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public double getTrailGapPercent() {
        return this.trailGapPercent;
    }

    public void setTrailGapPercent(double d) {
        if (d < 0.0 || d > 0.2) {
            throw new IllegalArgumentException("BarPlot.setTrailGapPercent(double): argument outside valid range.");
        }
        if (this.trailGapPercent != d) {
            this.trailGapPercent = d;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public double getCategoryGapsPercent() {
        return this.categoryGapsPercent;
    }

    public void setCategoryGapsPercent(double d) {
        if (d < 0.0 || d > 0.3) {
            throw new IllegalArgumentException("BarPlot.setCategoryGapsPercent(double): argument outside valid range.");
        }
        if (this.categoryGapsPercent != d) {
            this.categoryGapsPercent = d;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public double getItemGapsPercent() {
        return this.itemGapsPercent;
    }

    public void setItemGapsPercent(double d) {
        if (d < 0.0 || d > 0.3) {
            throw new IllegalArgumentException("BarPlot.setItemGapsPercent(double): argument outside valid range.");
        }
        if (d != this.itemGapsPercent) {
            this.itemGapsPercent = d;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public CategoryDataset getCategoryDataset() {
        return (CategoryDataset)this.dataset;
    }

    public CategoryAxis getDomainAxis() {
        CategoryAxis categoryAxis = this.domainAxis;
        if (categoryAxis == null && this.parent != null) {
            categoryAxis = this.parent.getDomainAxis();
        }
        return categoryAxis;
    }

    public void setDomainAxis(CategoryAxis categoryAxis) throws AxisNotCompatibleException {
        if (this.isCompatibleDomainAxis(categoryAxis)) {
            if (categoryAxis != null) {
                try {
                    categoryAxis.setPlot(this);
                }
                catch (PlotNotCompatibleException plotNotCompatibleException) {
                    throw new AxisNotCompatibleException("CategoryPlot.setDomainAxis(...): plot not compatible with axis.");
                }
                categoryAxis.addChangeListener(this);
            }
            if (this.domainAxis != null) {
                this.domainAxis.removeChangeListener(this);
            }
        } else {
            throw new AxisNotCompatibleException("CategoryPlot.setDomainAxis(...): axis not compatible with plot.");
        }
        this.domainAxis = categoryAxis;
    }

    public ValueAxis getRangeAxis() {
        ValueAxis valueAxis = this.rangeAxis;
        if (valueAxis == null && this.parent != null) {
            valueAxis = this.parent.getRangeAxis();
        }
        return valueAxis;
    }

    public void setRangeAxis(ValueAxis valueAxis) throws AxisNotCompatibleException {
        if (this.isCompatibleRangeAxis(valueAxis)) {
            if (valueAxis != null) {
                try {
                    valueAxis.setPlot(this);
                }
                catch (PlotNotCompatibleException plotNotCompatibleException) {
                    throw new AxisNotCompatibleException("CategoryPlot.setRangeAxis(...): plot not compatible with axis.");
                }
                valueAxis.addChangeListener(this);
            }
            if (this.rangeAxis != null) {
                this.rangeAxis.removeChangeListener(this);
            }
        } else {
            throw new AxisNotCompatibleException("Plot.setRangeAxis(...): axis not compatible with plot.");
        }
        this.rangeAxis = valueAxis;
    }

    public abstract boolean isCompatibleDomainAxis(CategoryAxis var1);

    public abstract boolean isCompatibleRangeAxis(ValueAxis var1);

    public abstract double getCategoryCoordinate(int var1, Rectangle2D var2);

    public void zoom(double d) {
        ValueAxis valueAxis = this.getRangeAxis();
        if (d > 0.0) {
            double d2 = valueAxis.getMaximumAxisValue() - valueAxis.getMinimumAxisValue();
            double d3 = d2 * d;
            valueAxis.setAnchoredRange(d3);
        } else {
            valueAxis.setAutoRange(true);
        }
    }

    public void setLabelsVisible(boolean bl) {
        if (this.labelsVisible != bl) {
            this.labelsVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean getLabelsVisible() {
        return this.labelsVisible;
    }

    public void setLabelFont(Font font) {
        if (this.labelFont == null) {
            throw new IllegalArgumentException("CategoryPlot.setLabelFont(...): null font not allowed.");
        }
        if (!this.labelFont.equals(font)) {
            this.labelFont = font;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelPaint(Paint paint) {
        if (this.labelPaint == null) {
            throw new IllegalArgumentException("CategoryPlot.setLabelPaint(...): null paint not allowed.");
        }
        if (!this.labelPaint.equals(paint)) {
            this.labelPaint = paint;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Paint getLabelPaint() {
        return this.labelPaint;
    }

    public void setLabelFormatString(String string) {
        boolean bl = false;
        if (string == null) {
            if (this.labelFormatter != null) {
                this.labelFormatPattern = null;
                this.labelFormatter = null;
                bl = true;
            }
        } else if (this.labelFormatter == null || !string.equals(this.labelFormatPattern)) {
            this.labelFormatPattern = string;
            this.labelFormatter = new DecimalFormat(string);
            bl = true;
        }
        if (bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public NumberFormat getLabelFormatter() {
        return this.labelFormatter;
    }

    public void setVerticalLabels(boolean bl) {
        if (this.verticalLabels != bl) {
            this.verticalLabels = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean getVerticalLabels() {
        return this.verticalLabels;
    }

    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        if (this.rangeAxis != null) {
            this.rangeAxis.configure();
        }
        super.datasetChanged(datasetChangeEvent);
    }

    public void addRangeMarker(Marker marker) {
        this.markers.add(marker);
    }
}

