/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.ChartMouseEvent;
import com.jrefinery.chart.ChartMouseListener;
import com.jrefinery.chart.ChartPanelConstants;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.ChartUtilities;
import com.jrefinery.chart.HorizontalValuePlot;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalValuePlot;
import com.jrefinery.chart.entity.ChartEntity;
import com.jrefinery.chart.entity.EntityCollection;
import com.jrefinery.chart.event.ChartChangeEvent;
import com.jrefinery.chart.event.ChartChangeListener;
import com.jrefinery.chart.ui.ChartPropertyEditPanel;
import com.jrefinery.ui.ExtensionFileFilter;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ToolTipManager;
import javax.swing.filechooser.FileFilter;

public class ChartPanel
extends JPanel
implements ChartPanelConstants,
ActionListener,
MouseListener,
MouseMotionListener,
Printable,
ChartChangeListener {
    protected JFreeChart chart;
    protected List chartMouseListeners;
    protected boolean useBuffer;
    protected boolean refreshBuffer;
    protected Image chartBuffer;
    protected int chartBufferHeight;
    protected int chartBufferWidth;
    protected int minimumDrawWidth;
    protected int minimumDrawHeight;
    protected int maximumDrawWidth;
    protected int maximumDrawHeight;
    protected JPopupMenu popup;
    protected ChartRenderingInfo info;
    protected double scaleX;
    protected double scaleY;
    protected Rectangle2D zoomRectangle = null;
    protected Point2D zoomPoint = null;
    protected boolean fillZoomRectangle = false;
    protected boolean horizontalZoom = false;
    protected boolean verticalZoom = false;
    protected boolean horizontalAxisTrace = false;
    protected boolean verticalAxisTrace = false;
    protected JMenuItem zoomInBothAxesMenuItem;
    protected JMenuItem zoomInHorizontalMenuItem;
    protected JMenuItem zoomInVerticalMenuItem;
    protected JMenuItem zoomOutBothMenuItem;
    protected JMenuItem zoomOutHorizontalMenuItem;
    protected JMenuItem zoomOutVerticalMenuItem;
    protected JMenuItem autoRangeBothMenuItem;
    protected JMenuItem autoRangeHorizontalMenuItem;
    protected JMenuItem autoRangeVerticalMenuItem;
    private Rectangle2D available = new Rectangle2D.Double();
    private Rectangle2D chartArea = new Rectangle2D.Double();
    private Line2D verticalTraceLine;
    private Line2D horizontalTraceLine;

    public ChartPanel(JFreeChart jFreeChart) {
        this(jFreeChart, 680, 420, 300, 200, 800, 600, true, true, true, true, true, true);
    }

    public ChartPanel(JFreeChart jFreeChart, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this(jFreeChart, 680, 420, 300, 200, 800, 600, true, bl, bl2, bl3, bl4, bl5);
    }

    public ChartPanel(JFreeChart jFreeChart, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this.chart = jFreeChart;
        this.chartMouseListeners = new ArrayList();
        this.info = new ChartRenderingInfo();
        this.setPreferredSize(new Dimension(n, n2));
        this.useBuffer = bl;
        this.refreshBuffer = false;
        this.chart.addChangeListener(this);
        this.minimumDrawWidth = n3;
        this.minimumDrawHeight = n4;
        this.maximumDrawWidth = n5;
        this.maximumDrawHeight = n6;
        this.popup = null;
        if (bl2 || bl3 || bl4 || bl5) {
            this.popup = this.createPopupMenu(bl2, bl3, bl4, bl5);
        }
        this.enableEvents(16L);
        this.enableEvents(32L);
        this.setGenerateToolTips(bl6);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setOpaque(true);
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public void setChart(JFreeChart jFreeChart) {
        if (this.chart != null) {
            this.chart.removeChangeListener(this);
        }
        this.chart = jFreeChart;
        this.chart.addChangeListener(this);
        if (this.useBuffer) {
            this.refreshBuffer = true;
        }
        Plot plot = jFreeChart.getPlot();
        this.horizontalZoom = this.horizontalZoom && plot instanceof HorizontalValuePlot;
        this.verticalZoom = this.verticalZoom && plot instanceof VerticalValuePlot;
        this.repaint();
    }

    public int getMinimumDrawWidth() {
        return this.minimumDrawWidth;
    }

    public void setMinimumDrawWidth(int n) {
        this.minimumDrawWidth = n;
    }

    public int getMaximumDrawWidth() {
        return this.maximumDrawWidth;
    }

    public void setMaximumDrawWidth(int n) {
        this.maximumDrawWidth = n;
    }

    public void setMinimumDrawHeight(int n) {
        this.minimumDrawHeight = n;
    }

    public int getMinimumDrawHeight() {
        return this.minimumDrawHeight;
    }

    public int getMaximumDrawHeight() {
        return this.maximumDrawHeight;
    }

    public void setMaximumDrawHeight(int n) {
        this.maximumDrawHeight = n;
    }

    public void setMouseZoomable(boolean bl) {
        this.setMouseZoomable(bl, true);
    }

    public void setMouseZoomable(boolean bl, boolean bl2) {
        this.setHorizontalZoom(bl);
        this.setVerticalZoom(bl);
        this.setFillZoomRectangle(bl2);
    }

    public void setHorizontalZoom(boolean bl) {
        this.horizontalZoom = bl && this.chart.getPlot() instanceof HorizontalValuePlot;
    }

    public void setFillZoomRectangle(boolean bl) {
        this.fillZoomRectangle = bl;
    }

    public void setVerticalZoom(boolean bl) {
        this.verticalZoom = bl && this.chart.getPlot() instanceof VerticalValuePlot;
    }

    public void setHorizontalAxisTrace(boolean bl) {
        this.horizontalAxisTrace = bl;
    }

    public void setVerticalAxisTrace(boolean bl) {
        this.verticalAxisTrace = bl;
    }

    public void setGenerateToolTips(boolean bl) {
        this.info.setGenerateToolTips(bl);
        if (bl) {
            ToolTipManager.sharedInstance().registerComponent(this);
        } else {
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        EntityCollection entityCollection;
        String string = null;
        if (this.info.isGenerateToolTips() && (entityCollection = this.info.getEntityCollection()) != null) {
            Insets insets = this.getInsets();
            ChartEntity chartEntity = entityCollection.getEntity((int)((double)(mouseEvent.getX() - insets.left) / this.scaleX), (int)((double)(mouseEvent.getY() - insets.top) / this.scaleY));
            if (chartEntity != null) {
                string = chartEntity.getToolTipText();
            }
        }
        return string;
    }

    public void setRefreshBuffer(boolean bl) {
        this.refreshBuffer = bl;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        this.available.setRect(insets.left, insets.top, dimension.getWidth() - (double)insets.left - (double)insets.right, dimension.getHeight() - (double)insets.top - (double)insets.bottom);
        boolean bl = false;
        double d = this.available.getWidth();
        double d2 = this.available.getHeight();
        this.scaleX = 1.0;
        this.scaleY = 1.0;
        if (d < (double)this.minimumDrawWidth) {
            this.scaleX = d / (double)this.minimumDrawWidth;
            d = this.minimumDrawWidth;
            bl = true;
        } else if (d > (double)this.maximumDrawWidth) {
            this.scaleX = d / (double)this.maximumDrawWidth;
            d = this.maximumDrawWidth;
            bl = true;
        }
        if (d2 < (double)this.minimumDrawHeight) {
            this.scaleY = d2 / (double)this.minimumDrawHeight;
            d2 = this.minimumDrawHeight;
            bl = true;
        } else if (d2 > (double)this.maximumDrawHeight) {
            this.scaleY = d2 / (double)this.maximumDrawHeight;
            d2 = this.maximumDrawHeight;
            bl = true;
        }
        this.chartArea.setRect(0.0, 0.0, d, d2);
        AffineTransform affineTransform = AffineTransform.getScaleInstance(this.scaleX, this.scaleY);
        if (this.useBuffer) {
            if (this.chartBuffer == null || (double)this.chartBufferWidth != this.available.getWidth() || (double)this.chartBufferHeight != this.available.getHeight()) {
                this.chartBufferWidth = (int)this.available.getWidth();
                this.chartBufferHeight = (int)this.available.getHeight();
                this.chartBuffer = this.createImage(this.chartBufferWidth, this.chartBufferHeight);
                this.refreshBuffer = true;
            }
            if (this.refreshBuffer) {
                Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, this.chartBufferWidth, this.chartBufferHeight);
                Graphics2D graphics2D2 = (Graphics2D)this.chartBuffer.getGraphics();
                if (bl) {
                    AffineTransform affineTransform2 = graphics2D2.getTransform();
                    graphics2D2.transform(affineTransform);
                    this.chart.draw(graphics2D2, this.chartArea, this.info);
                    graphics2D2.setTransform(affineTransform2);
                } else {
                    this.chart.draw(graphics2D2, double_, this.info);
                }
                this.refreshBuffer = false;
            }
            graphics.drawImage(this.chartBuffer, insets.left, insets.right, this);
        } else {
            AffineTransform affineTransform3 = graphics2D.getTransform();
            graphics2D.translate(insets.left, insets.right);
            if (bl) {
                graphics2D.transform(affineTransform);
            }
            this.chart.draw(graphics2D, this.chartArea, this.info);
            graphics2D.setTransform(affineTransform3);
        }
        this.verticalTraceLine = null;
        this.horizontalTraceLine = null;
    }

    public void chartChanged(ChartChangeEvent chartChangeEvent) {
        this.refreshBuffer = true;
        this.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("PROPERTIES")) {
            this.attemptEditChartProperties();
        } else if (string.equals("SAVE")) {
            try {
                this.doSaveAs();
            }
            catch (IOException iOException) {
                System.err.println("ChartPanel.doSaveAs: i/o exception = " + iOException.getMessage());
            }
        } else if (string.equals("PRINT")) {
            this.createChartPrintJob();
        } else if (string.equals("ZOOM_IN_BOTH")) {
            this.zoomInBoth(this.zoomPoint.getX(), this.zoomPoint.getY());
        } else if (string.equals("ZOOM_IN_HORIZONTAL")) {
            this.zoomInHorizontal(this.zoomPoint.getX());
        } else if (string.equals("ZOOM_IN_VERTICAL")) {
            this.zoomInVertical(this.zoomPoint.getY());
        } else if (string.equals("ZOOM_OUT_BOTH")) {
            this.zoomOutBoth(this.zoomPoint.getX(), this.zoomPoint.getY());
        } else if (string.equals("ZOOM_HORIZONTAL_BOTH")) {
            this.zoomOutHorizontal(this.zoomPoint.getX());
        } else if (string.equals("ZOOM_VERTICAL_BOTH")) {
            this.zoomOutVertical(this.zoomPoint.getY());
        } else if (string.equals("AUTO_RANGE_BOTH")) {
            this.autoRangeBoth();
        } else if (string.equals("AUTO_RANGE_HORIZONTAL")) {
            this.autoRangeHorizontal();
        } else if (string.equals("AUTO_RANGE_VERTICAL")) {
            this.autoRangeVertical();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.zoomRectangle == null) {
            this.zoomPoint = RefineryUtilities.getPointInRectangle((double)mouseEvent.getX(), (double)mouseEvent.getY(), (Rectangle2D)this.getScaledDataArea());
            if (mouseEvent.isPopupTrigger() && this.popup != null) {
                this.displayPopupMenu(mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.zoomRectangle != null) {
            if (Math.abs((double)mouseEvent.getX() - this.zoomPoint.getX()) >= 20.0) {
                if ((double)mouseEvent.getX() < this.zoomPoint.getX() && (double)mouseEvent.getY() < this.zoomPoint.getY()) {
                    this.autoRangeBoth();
                } else {
                    double d = Math.min(this.zoomRectangle.getWidth(), this.getScaledDataArea().getMaxX() - this.zoomPoint.getX());
                    double d2 = Math.min(this.zoomRectangle.getHeight(), this.getScaledDataArea().getMaxY() - this.zoomPoint.getY());
                    Rectangle2D.Double double_ = new Rectangle2D.Double(this.zoomPoint.getX(), this.zoomPoint.getY(), d, d2);
                    this.zoom(double_);
                }
                this.zoomPoint = null;
                this.zoomRectangle = null;
            } else {
                Graphics2D graphics2D = (Graphics2D)this.getGraphics();
                graphics2D.setXORMode(Color.gray);
                if (this.fillZoomRectangle) {
                    graphics2D.fill(this.zoomRectangle);
                } else {
                    graphics2D.draw(this.zoomRectangle);
                }
                graphics2D.dispose();
                this.zoomRectangle = null;
            }
        } else if (mouseEvent.isPopupTrigger() && this.popup != null) {
            this.displayPopupMenu(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Insets insets = this.getInsets();
        int n = (int)((double)(mouseEvent.getX() - insets.left) / this.scaleX);
        int n2 = (int)((double)(mouseEvent.getY() - insets.top) / this.scaleY);
        this.chart.handleClick(n, n2, this.info);
        if (this.chartMouseListeners.isEmpty()) {
            return;
        }
        ChartEntity chartEntity = this.info.getEntityCollection().getEntity(n, n2);
        ChartMouseEvent chartMouseEvent = new ChartMouseEvent(mouseEvent, chartEntity);
        Iterator iterator = this.chartMouseListeners.iterator();
        while (iterator.hasNext()) {
            ChartMouseListener chartMouseListener = (ChartMouseListener)iterator.next();
            chartMouseListener.chartMouseClicked(chartMouseEvent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.horizontalAxisTrace) {
            this.drawHorizontalAxisTrace(mouseEvent.getX());
        }
        if (this.verticalAxisTrace) {
            this.drawVerticalAxisTrace(mouseEvent.getY());
        }
        if (this.chartMouseListeners.isEmpty()) {
            return;
        }
        Insets insets = this.getInsets();
        int n = (int)((double)(mouseEvent.getX() - insets.left) / this.scaleX);
        int n2 = (int)((double)(mouseEvent.getY() - insets.top) / this.scaleY);
        ChartEntity chartEntity = this.info.getEntityCollection().getEntity(n, n2);
        ChartMouseEvent chartMouseEvent = new ChartMouseEvent(mouseEvent, chartEntity);
        Iterator iterator = this.chartMouseListeners.iterator();
        while (iterator.hasNext()) {
            ChartMouseListener chartMouseListener = (ChartMouseListener)iterator.next();
            chartMouseListener.chartMouseMoved(chartMouseEvent);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.popup != null && this.popup.isShowing()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        graphics2D.setXORMode(Color.gray);
        if (this.zoomRectangle != null) {
            if (this.fillZoomRectangle) {
                graphics2D.fill(this.zoomRectangle);
            } else {
                graphics2D.draw(this.zoomRectangle);
            }
        }
        Rectangle2D rectangle2D = this.getScaledDataArea();
        if (this.horizontalZoom && this.verticalZoom) {
            double d = Math.min((double)mouseEvent.getX(), rectangle2D.getMaxX());
            double d2 = Math.min((double)mouseEvent.getY(), rectangle2D.getMaxY());
            this.zoomRectangle = new Rectangle2D.Double(this.zoomPoint.getX(), this.zoomPoint.getY(), d - this.zoomPoint.getX(), d2 - this.zoomPoint.getY());
        }
        if (this.zoomRectangle != null) {
            if (this.fillZoomRectangle) {
                graphics2D.fill(this.zoomRectangle);
            } else {
                graphics2D.draw(this.zoomRectangle);
            }
        }
        graphics2D.dispose();
    }

    public void zoomInBoth(double d, double d2) {
        this.zoomInHorizontal(d);
        this.zoomInVertical(d2);
    }

    public void zoomInHorizontal(double d) {
        if (this.chart.getPlot() instanceof HorizontalValuePlot) {
            HorizontalValuePlot horizontalValuePlot = (HorizontalValuePlot)((Object)this.chart.getPlot());
            ValueAxis valueAxis = horizontalValuePlot.getHorizontalValueAxis();
            double d2 = valueAxis.translateJava2DtoValue((float)d, this.info.getDataArea());
            valueAxis.resizeRange(0.5, d2);
        }
    }

    public void zoomInVertical(double d) {
        if (this.chart.getPlot() instanceof VerticalValuePlot) {
            VerticalValuePlot verticalValuePlot = (VerticalValuePlot)((Object)this.chart.getPlot());
            ValueAxis valueAxis = verticalValuePlot.getVerticalValueAxis();
            double d2 = valueAxis.translateJava2DtoValue((float)d, this.info.getDataArea());
            valueAxis.resizeRange(0.5, d2);
        }
    }

    public void zoomOutBoth(double d, double d2) {
        this.zoomOutHorizontal(d);
        this.zoomOutVertical(d2);
    }

    public void zoomOutHorizontal(double d) {
        if (this.chart.getPlot() instanceof HorizontalValuePlot) {
            HorizontalValuePlot horizontalValuePlot = (HorizontalValuePlot)((Object)this.chart.getPlot());
            ValueAxis valueAxis = horizontalValuePlot.getHorizontalValueAxis();
            double d2 = valueAxis.translateJava2DtoValue((float)d, this.info.getDataArea());
            valueAxis.resizeRange(2.0, d2);
        }
    }

    public void zoomOutVertical(double d) {
        if (this.chart.getPlot() instanceof VerticalValuePlot) {
            VerticalValuePlot verticalValuePlot = (VerticalValuePlot)((Object)this.chart.getPlot());
            ValueAxis valueAxis = verticalValuePlot.getVerticalValueAxis();
            double d2 = valueAxis.translateJava2DtoValue((float)d, this.info.getDataArea());
            valueAxis.resizeRange(2.0, d2);
        }
    }

    public void zoom(Rectangle2D rectangle2D) {
        if (rectangle2D.getHeight() > 0.0 && rectangle2D.getWidth() > 0.0) {
            double d;
            double d2;
            ValueAxis valueAxis;
            Object object;
            Rectangle2D rectangle2D2 = this.getScaledDataArea();
            if (this.chart.getPlot() instanceof HorizontalValuePlot) {
                object = (HorizontalValuePlot)((Object)this.chart.getPlot());
                valueAxis = object.getHorizontalValueAxis();
                d2 = valueAxis.translateJava2DtoValue((float)rectangle2D.getX(), rectangle2D2);
                d = valueAxis.translateJava2DtoValue((float)rectangle2D.getMaxX(), rectangle2D2);
                valueAxis.setRange(d2, d);
            }
            if (this.chart.getPlot() instanceof VerticalValuePlot) {
                object = (VerticalValuePlot)((Object)this.chart.getPlot());
                valueAxis = object.getVerticalValueAxis();
                d2 = valueAxis.translateJava2DtoValue((float)rectangle2D.getMaxY(), rectangle2D2);
                d = valueAxis.translateJava2DtoValue((float)rectangle2D.getY(), rectangle2D2);
                valueAxis.setRange(d2, d);
            }
        }
    }

    public void autoRangeBoth() {
        this.autoRangeHorizontal();
        this.autoRangeVertical();
    }

    public void autoRangeHorizontal() {
        if (this.chart.getPlot() instanceof HorizontalValuePlot) {
            HorizontalValuePlot horizontalValuePlot = (HorizontalValuePlot)((Object)this.chart.getPlot());
            ValueAxis valueAxis = horizontalValuePlot.getHorizontalValueAxis();
            valueAxis.setAutoRange(true);
        }
    }

    public void autoRangeVertical() {
        Plot plot = this.chart.getPlot();
        if (plot instanceof VerticalValuePlot) {
            VerticalValuePlot verticalValuePlot = (VerticalValuePlot)((Object)plot);
            ValueAxis valueAxis = verticalValuePlot.getVerticalValueAxis();
            valueAxis.setAutoRange(true);
        }
    }

    public Rectangle2D getScaledDataArea() {
        Rectangle2D rectangle2D = this.info.getDataArea();
        Insets insets = this.getInsets();
        double d = rectangle2D.getX() * this.scaleX + (double)insets.left;
        double d2 = rectangle2D.getY() * this.scaleY + (double)insets.top;
        double d3 = rectangle2D.getWidth() * this.scaleX;
        double d4 = rectangle2D.getHeight() * this.scaleY;
        return new Rectangle2D.Double(d, d2, d3, d4);
    }

    private void drawHorizontalAxisTrace(int n) {
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        Rectangle2D rectangle2D = this.getScaledDataArea();
        graphics2D.setXORMode(Color.orange);
        if ((int)rectangle2D.getMinX() < n && n < (int)rectangle2D.getMaxX()) {
            if (this.verticalTraceLine != null) {
                graphics2D.draw(this.verticalTraceLine);
                this.verticalTraceLine.setLine(n, (int)rectangle2D.getMinY(), n, (int)rectangle2D.getMaxY());
            } else {
                this.verticalTraceLine = new Line2D.Float(n, (int)rectangle2D.getMinY(), n, (int)rectangle2D.getMaxY());
            }
            graphics2D.draw(this.verticalTraceLine);
        }
    }

    private void drawVerticalAxisTrace(int n) {
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        Rectangle2D rectangle2D = this.getScaledDataArea();
        graphics2D.setXORMode(Color.orange);
        if ((int)rectangle2D.getMinY() < n && n < (int)rectangle2D.getMaxY()) {
            if (this.horizontalTraceLine != null) {
                graphics2D.draw(this.horizontalTraceLine);
                this.horizontalTraceLine.setLine((int)rectangle2D.getMinX(), n, (int)rectangle2D.getMaxX(), n);
            } else {
                this.horizontalTraceLine = new Line2D.Float((int)rectangle2D.getMinX(), n, (int)rectangle2D.getMaxX(), n);
            }
            graphics2D.draw(this.horizontalTraceLine);
        }
    }

    private void attemptEditChartProperties() {
        ChartPropertyEditPanel chartPropertyEditPanel = new ChartPropertyEditPanel(this.chart);
        int n = JOptionPane.showConfirmDialog(this, chartPropertyEditPanel, "Chart Properties", 2, -1);
        if (n == 0) {
            chartPropertyEditPanel.updateChartProperties(this.chart);
        }
    }

    public void doSaveAs() throws IOException {
        JFileChooser jFileChooser = new JFileChooser();
        ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter("PNG Image Files", ".png");
        jFileChooser.addChoosableFileFilter((FileFilter)extensionFileFilter);
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            ChartUtilities.saveChartAsPNG(jFileChooser.getSelectedFile(), this.chart, this.getWidth(), this.getHeight());
        }
    }

    public void createChartPrintJob() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(this);
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                JOptionPane.showMessageDialog(this, printerException);
            }
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n != 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d = pageFormat.getImageableX();
        double d2 = pageFormat.getImageableY();
        double d3 = pageFormat.getImageableWidth();
        double d4 = pageFormat.getImageableHeight();
        this.chart.draw(graphics2D, new Rectangle2D.Double(d, d2, d3, d4), null);
        return 0;
    }

    public void addChartMouseListener(ChartMouseListener chartMouseListener) {
        this.chartMouseListeners.add(chartMouseListener);
    }

    public void removeChartMouseListener(ChartMouseListener chartMouseListener) {
        this.chartMouseListeners.remove(chartMouseListener);
    }

    protected JPopupMenu createPopupMenu(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        JMenuItem jMenuItem;
        JPopupMenu jPopupMenu = new JPopupMenu("Chart:");
        boolean bl5 = false;
        if (bl) {
            jMenuItem = new JMenuItem("Properties...");
            jMenuItem.setActionCommand("PROPERTIES");
            jMenuItem.addActionListener(this);
            jPopupMenu.add(jMenuItem);
            bl5 = true;
        }
        if (bl2) {
            if (bl5) {
                jPopupMenu.addSeparator();
                bl5 = false;
            }
            jMenuItem = new JMenuItem("Save as...");
            jMenuItem.setActionCommand("SAVE");
            jMenuItem.addActionListener(this);
            jPopupMenu.add(jMenuItem);
            bl5 = true;
        }
        if (bl3) {
            if (bl5) {
                jPopupMenu.addSeparator();
                bl5 = false;
            }
            jMenuItem = new JMenuItem("Print...");
            jMenuItem.setActionCommand("PRINT");
            jMenuItem.addActionListener(this);
            jPopupMenu.add(jMenuItem);
            bl5 = true;
        }
        if (bl4) {
            if (bl5) {
                jPopupMenu.addSeparator();
                bl5 = false;
            }
            jMenuItem = new JMenu("Zoom In");
            JMenuItem jMenuItem2 = new JMenuItem("Both Axes");
            jMenuItem2.setActionCommand("ZOOM_IN_BOTH");
            jMenuItem2.addActionListener(this);
            ((JMenu)jMenuItem).add(jMenuItem2);
            ((JMenu)jMenuItem).addSeparator();
            this.zoomInHorizontalMenuItem = new JMenuItem("Horizontal Axis");
            this.zoomInHorizontalMenuItem.setActionCommand("ZOOM_IN_HORIZONTAL");
            this.zoomInHorizontalMenuItem.addActionListener(this);
            ((JMenu)jMenuItem).add(this.zoomInHorizontalMenuItem);
            this.zoomInVerticalMenuItem = new JMenuItem("Vertical Axis");
            this.zoomInVerticalMenuItem.setActionCommand("ZOOM_IN_VERTICAL");
            this.zoomInVerticalMenuItem.addActionListener(this);
            ((JMenu)jMenuItem).add(this.zoomInVerticalMenuItem);
            jPopupMenu.add(jMenuItem);
            JMenu jMenu = new JMenu("Zoom Out");
            JMenuItem jMenuItem3 = new JMenuItem("Both Axes");
            jMenuItem3.setActionCommand("ZOOM_OUT_BOTH");
            jMenuItem3.addActionListener(this);
            jMenu.add(jMenuItem3);
            jMenu.addSeparator();
            this.zoomOutHorizontalMenuItem = new JMenuItem("Horizontal Axis");
            this.zoomOutHorizontalMenuItem.setActionCommand("ZOOM_HORIZONTAL_BOTH");
            this.zoomOutHorizontalMenuItem.addActionListener(this);
            jMenu.add(this.zoomOutHorizontalMenuItem);
            this.zoomOutVerticalMenuItem = new JMenuItem("Vertical Axis");
            this.zoomOutVerticalMenuItem.setActionCommand("ZOOM_VERTICAL_BOTH");
            this.zoomOutVerticalMenuItem.addActionListener(this);
            jMenu.add(this.zoomOutVerticalMenuItem);
            jPopupMenu.add(jMenu);
            JMenu jMenu2 = new JMenu("Auto Range");
            this.autoRangeBothMenuItem = new JMenuItem("Both Axes");
            this.autoRangeBothMenuItem.setActionCommand("AUTO_RANGE_BOTH");
            this.autoRangeBothMenuItem.addActionListener(this);
            jMenu2.add(this.autoRangeBothMenuItem);
            jMenu2.addSeparator();
            this.autoRangeHorizontalMenuItem = new JMenuItem("Horizontal Axis");
            this.autoRangeHorizontalMenuItem.setActionCommand("AUTO_RANGE_HORIZONTAL");
            this.autoRangeHorizontalMenuItem.addActionListener(this);
            jMenu2.add(this.autoRangeHorizontalMenuItem);
            this.autoRangeVerticalMenuItem = new JMenuItem("Vertical Axis");
            this.autoRangeVerticalMenuItem.setActionCommand("AUTO_RANGE_VERTICAL");
            this.autoRangeVerticalMenuItem.addActionListener(this);
            jMenu2.add(this.autoRangeVerticalMenuItem);
            jPopupMenu.addSeparator();
            jPopupMenu.add(jMenu2);
        }
        return jPopupMenu;
    }

    private void displayPopupMenu(int n, int n2) {
        if (this.popup != null) {
            Plot plot = this.chart.getPlot();
            if (plot instanceof HorizontalValuePlot) {
                // empty if block
            }
            this.popup.show(this, n, n2);
        }
    }
}

