/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisConstants;
import com.jrefinery.chart.DateUnit;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.event.AxisChangeEvent;
import com.jrefinery.data.DateRange;
import com.jrefinery.data.Range;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public abstract class DateAxis
extends ValueAxis {
    public static final Date DEFAULT_CROSSHAIR_DATE = null;
    protected Date anchorDate = new Date();
    protected Date crosshairDate;
    protected DateUnit tickUnit;
    protected SimpleDateFormat tickLabelFormatter;
    protected static long[] standardTickUnitMagnitudes = new long[]{1L, 5L, 10L, 50L, 100L, 500L, 1000L, 5000L, 10000L, 30000L, 60000L, 300000L, 600000L, 1800000L, 3600000L, 21600000L, 43200000L, 86400000L, 604800000L, 2592000000L, 7776000000L, 15552000000L, 31536000000L, 157680000000L, 315360000000L, 788400000000L, 1576800000000L, -1141367296000L};
    protected static int[][] standardTickUnits = new int[][]{{14, 1}, {14, 5}, {14, 10}, {14, 50}, {14, 100}, {14, 500}, {13, 1}, {13, 5}, {13, 10}, {13, 30}, {12, 1}, {12, 5}, {12, 10}, {12, 30}, {11, 1}, {11, 6}, {11, 12}, {5, 1}, {5, 7}, {2, 1}, {2, 3}, {2, 6}, {1, 1}, {1, 5}, {1, 10}, {1, 25}, {1, 50}, {1, 100}};
    protected static String[] standardTickFormats = new String[]{"HH:mm:ss.SSS", "HH:mm:ss.SSS", "HH:mm:ss.SSS", "HH:mm:ss.SSS", "HH:mm:ss.SSS", "HH:mm:ss.SSS", "HH:mm:ss", "HH:mm:ss", "HH:mm:ss", "HH:mm:ss", "HH:mm", "HH:mm", "HH:mm", "HH:mm", "HH:mm", "d-MMM, H:mm", "d-MMM, H:mm", "d-MMM-yyyy", "d-MMM-yyyy", "MMM-yyyy", "MMM-yyyy", "MMM-yyyy", "yyyy", "yyyy", "yyyy", "yyyy", "yyyy", "yyyy"};

    protected DateAxis(String string) {
        this(string, AxisConstants.DEFAULT_AXIS_LABEL_FONT, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_STROKE, true, (Range)new DateRange(), true, new DateUnit(5, 1), new SimpleDateFormat(), true, ValueAxis.DEFAULT_GRID_LINE_STROKE, ValueAxis.DEFAULT_GRID_LINE_PAINT, false, DEFAULT_CROSSHAIR_DATE, ValueAxis.DEFAULT_CROSSHAIR_STROKE, ValueAxis.DEFAULT_CROSSHAIR_PAINT);
    }

    protected DateAxis(String string, Font font, Paint paint, Insets insets, boolean bl, Font font2, Paint paint2, Insets insets2, boolean bl2, Stroke stroke, boolean bl3, Range range, boolean bl4, DateUnit dateUnit, SimpleDateFormat simpleDateFormat, boolean bl5, Stroke stroke2, Paint paint3, boolean bl6, Date date, Stroke stroke3, Paint paint4) {
        super(string, font, paint, insets, bl, font2, paint2, insets2, bl2, stroke, bl3, bl4, bl5, stroke2, paint3, bl6, 0.0, stroke3, paint4);
        this.range = range;
        this.crosshairDate = date;
        if (date != null) {
            this.crosshairValue = date.getTime();
        }
        this.tickUnit = dateUnit;
        this.tickLabelFormatter = simpleDateFormat;
        this.anchorValue = this.anchorDate.getTime();
    }

    public void setRange(Range range) {
        if (range == null) {
            throw new IllegalArgumentException("DateAxis.setAxisRange(...): null not permitted.");
        }
        if (!(range instanceof DateRange)) {
            range = new DateRange(range);
        }
        this.autoRange = false;
        this.range = range;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Date getMinimumDate() {
        Date date = null;
        if (this.range instanceof DateRange) {
            DateRange dateRange = (DateRange)this.range;
            date = dateRange.getLowerDate();
        } else {
            date = new Date((long)this.range.getLowerBound());
        }
        return date;
    }

    public void setMinimumDate(Date date) {
        this.range = new DateRange(date, this.getMaximumDate());
    }

    public Date getMaximumDate() {
        Date date = null;
        if (this.range instanceof DateRange) {
            DateRange dateRange = (DateRange)this.range;
            date = dateRange.getUpperDate();
        } else {
            date = new Date((long)this.range.getUpperBound());
        }
        return date;
    }

    public void setMaximumDate(Date date) {
        this.range = new DateRange(this.getMinimumDate(), date);
    }

    public void setAnchorValue(double d) {
        long l = (long)d;
        this.anchorDate.setTime(l);
        super.setAnchorValue(d);
    }

    public void setAxisRange(double d, double d2) {
        this.range = new DateRange(d, d2);
    }

    public Date getCrosshairDate() {
        return this.crosshairDate;
    }

    public void setCrosshairDate(Date date) {
        this.crosshairDate = date;
        if (date != null) {
            double d = date.getTime();
            this.setCrosshairValue(d);
        } else {
            this.setCrosshairVisible(false);
        }
    }

    public Date getAnchorDate() {
        return this.anchorDate;
    }

    public void setAnchorDate(Date date) {
        this.anchorDate = date;
        double d = date.getTime();
        super.setAnchorValue(d);
    }

    public DateUnit getTickUnit() {
        return this.tickUnit;
    }

    public void setTickUnit(DateUnit dateUnit) {
        this.tickUnit = dateUnit;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public SimpleDateFormat getTickLabelFormatter() {
        return this.tickLabelFormatter;
    }

    public Date calculateLowestVisibleTickValue(DateUnit dateUnit) {
        return this.nextStandardDate(this.getMinimumDate(), dateUnit.getField(), dateUnit.getCount());
    }

    public Date calculateHighestVisibleTickValue(DateUnit dateUnit) {
        return this.previousStandardDate(this.getMaximumDate(), dateUnit.getField(), dateUnit.getCount());
    }

    protected Date previousStandardDate(Date date, int n, int n2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n3 = calendar.get(n);
        int n4 = n2 * (n3 / n2);
        switch (n) {
            case 14: {
                int n5 = calendar.get(1);
                int n6 = calendar.get(2);
                int n7 = calendar.get(5);
                int n8 = calendar.get(11);
                int n9 = calendar.get(12);
                int n10 = calendar.get(13);
                calendar.set(n5, n6, n7, n8, n9, n10);
                calendar.set(14, n4);
                return calendar.getTime();
            }
            case 13: {
                int n11 = calendar.get(1);
                int n12 = calendar.get(2);
                int n13 = calendar.get(5);
                int n14 = calendar.get(11);
                int n15 = calendar.get(12);
                calendar.clear(14);
                calendar.set(n11, n12, n13, n14, n15, n4);
                return calendar.getTime();
            }
            case 12: {
                int n16 = calendar.get(1);
                int n17 = calendar.get(2);
                int n18 = calendar.get(5);
                int n19 = calendar.get(11);
                calendar.clear(14);
                calendar.set(n16, n17, n18, n19, n4, 0);
                return calendar.getTime();
            }
            case 11: {
                int n20 = calendar.get(1);
                int n21 = calendar.get(2);
                int n22 = calendar.get(5);
                calendar.clear(14);
                calendar.set(n20, n21, n22, n4, 0, 0);
                return calendar.getTime();
            }
            case 5: {
                int n23 = calendar.get(1);
                int n24 = calendar.get(2);
                calendar.clear(14);
                calendar.set(n23, n24, n4, 0, 0, 0);
                return calendar.getTime();
            }
            case 2: {
                int n25 = calendar.get(1);
                calendar.clear(14);
                calendar.set(n25, n4, 1, 0, 0, 0);
                return calendar.getTime();
            }
            case 1: {
                calendar.clear(14);
                calendar.set(n4, 0, 1, 0, 0, 0);
                return calendar.getTime();
            }
        }
        return null;
    }

    protected Date nextStandardDate(Date date, int n, int n2) {
        Date date2 = this.previousStandardDate(date, n, n2);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date2);
        calendar.add(n, n2);
        return calendar.getTime();
    }

    protected int findAxisMagnitudeIndex() {
        long l = this.getMaximumDate().getTime() - this.getMinimumDate().getTime();
        int n = 0;
        while (n < standardTickUnitMagnitudes.length - 1) {
            if (l < standardTickUnitMagnitudes[n]) break;
            ++n;
        }
        return Math.max(0, n - 1);
    }
}

