/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisConstants;
import com.jrefinery.chart.HorizontalAxis;
import com.jrefinery.chart.HorizontalNumberAxis;
import com.jrefinery.chart.HorizontalValuePlot;
import com.jrefinery.chart.NumberAxis;
import com.jrefinery.chart.NumberTickUnit;
import com.jrefinery.chart.SymbolicTickUnit;
import com.jrefinery.chart.Tick;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.event.AxisChangeEvent;
import com.jrefinery.data.Range;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class HorizontalSymbolicAxis
extends HorizontalNumberAxis
implements HorizontalAxis {
    public static final Paint DEFAULT_SYMBOLIC_GRID_LINE_PAINT = new Color(232, 234, 232);
    protected List symbolicValue;
    protected boolean xSymbolicZoomIsAccepted = false;
    public List symbolicGridLineList = null;
    protected Paint symbolicGridPaint;
    protected boolean symbolicGridLinesVisible;

    public HorizontalSymbolicAxis(String string, String[] stringArray) {
        this(string, stringArray, AxisConstants.DEFAULT_AXIS_LABEL_FONT, true, DEFAULT_SYMBOLIC_GRID_LINE_PAINT);
        this.autoRange = true;
    }

    public HorizontalSymbolicAxis(String string, String[] stringArray, Font font, boolean bl, Paint paint) {
        this(string, stringArray, font, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, false, true, AxisConstants.DEFAULT_TICK_STROKE, false, false, false, NumberAxis.DEFAULT_MINIMUM_AUTO_RANGE, 0.0, 1.0, false, false, new SymbolicTickUnit(NumberAxis.DEFAULT_TICK_UNIT.getSize(), stringArray), false, ValueAxis.DEFAULT_GRID_LINE_STROKE, ValueAxis.DEFAULT_GRID_LINE_PAINT, false, 0.0, ValueAxis.DEFAULT_CROSSHAIR_STROKE, ValueAxis.DEFAULT_CROSSHAIR_PAINT, bl, paint);
    }

    public HorizontalSymbolicAxis(String string, String[] stringArray, Font font, Paint paint, Insets insets, boolean bl, Font font2, Paint paint2, Insets insets2, boolean bl2, boolean bl3, Stroke stroke, boolean bl4, boolean bl5, boolean bl6, Number number, double d, double d2, boolean bl7, boolean bl8, NumberTickUnit numberTickUnit, boolean bl9, Stroke stroke2, Paint paint3, boolean bl10, double d3, Stroke stroke3, Paint paint4, boolean bl11, Paint paint5) {
        super(string, font, paint, insets, bl, font2, paint2, insets2, bl2, bl3, stroke, bl4, bl5, bl6, number, d, d2, bl7, bl8, numberTickUnit, bl9, stroke2, paint3, bl10, d3, stroke3, paint4);
        this.symbolicValue = Arrays.asList(stringArray);
        this.symbolicGridLinesVisible = bl11;
        this.symbolicGridPaint = paint5;
    }

    public String[] getSymbolicValue() {
        String[] stringArray = new String[this.symbolicValue.size()];
        stringArray = this.symbolicValue.toArray(stringArray);
        return stringArray;
    }

    public Paint getSymbolicGridPaint() {
        return this.symbolicGridPaint;
    }

    public boolean isGridLinesVisible() {
        return this.symbolicGridLinesVisible;
    }

    public void setSymbolicGridLinesVisible(boolean bl) {
        if (this.symbolicGridLinesVisible != bl) {
            this.symbolicGridLinesVisible = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public void setAnchoredRange(double d) {
        if (this.xSymbolicZoomIsAccepted) {
            double d2 = Math.rint(this.anchorValue);
            double d3 = Math.rint(d2 - d / 2.0) - 0.5;
            double d4 = Math.rint(d2 + d / 2.0) + 0.5;
            if (d3 < -0.5) {
                d3 = -0.5;
            }
            if (d4 > (double)this.symbolicValue.size() - 0.5) {
                d4 = (double)this.symbolicValue.size() - 0.5;
            }
            this.setRange(d3, d4);
        }
    }

    private void selectAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        throw new UnsupportedOperationException();
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        if (this.visible) {
            super.draw(graphics2D, rectangle2D, rectangle2D2);
        }
        if (this.symbolicGridLinesVisible) {
            this.drawSymbolicGridLines(graphics2D, rectangle2D, rectangle2D2);
        }
    }

    public void drawSymbolicGridLines(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        this.drawSymbolicGridLines(graphics2D, rectangle2D, rectangle2D2, true);
    }

    public void drawSymbolicGridLines(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, boolean bl) {
        this.symbolicGridLineList = new Vector(this.ticks.size());
        boolean bl2 = bl;
        double d = rectangle2D2.getY();
        double d2 = this.plot.outlineStroke != null ? (double)((BasicStroke)this.plot.outlineStroke).getLineWidth() : 1.0;
        Iterator iterator = this.ticks.iterator();
        while (iterator.hasNext()) {
            Tick tick = (Tick)iterator.next();
            double d3 = this.translateValueToJava2D(tick.getNumericalValue() - 0.5, rectangle2D2);
            double d4 = this.translateValueToJava2D(tick.getNumericalValue() + 0.5, rectangle2D2);
            if (bl2) {
                graphics2D.setPaint(Color.white);
                graphics2D.setXORMode((Color)this.symbolicGridPaint);
            } else {
                graphics2D.setPaint(Color.white);
                graphics2D.setXORMode(Color.white);
            }
            Rectangle2D.Double double_ = new Rectangle2D.Double(d3, d + d2, d4 - d3, rectangle2D2.getMaxY() - d - d2);
            graphics2D.fill(double_);
            this.symbolicGridLineList.add(double_);
            boolean bl3 = bl2 = !bl2;
        }
        graphics2D.setPaintMode();
    }

    public Rectangle2D.Double getSymbolicGridLine(int n) {
        if (this.symbolicGridLineList != null) {
            return (Rectangle2D.Double)this.symbolicGridLineList.get(n);
        }
        return null;
    }

    protected void autoAdjustRange() {
        if (this.plot == null) {
            return;
        }
        if (this.plot instanceof HorizontalValuePlot) {
            double d;
            double d2;
            double d3 = this.symbolicValue.size() - 1;
            double d4 = d3 - (d2 = 0.0);
            if (d4 < (d = this.autoRangeMinimumSize.doubleValue())) {
                d3 = (d3 + d2 + d) / 2.0;
                d2 = (d3 + d2 - d) / 2.0;
            }
            double d5 = 0.5;
            double d6 = 0.5;
            if (this.autoRangeIncludesZero) {
                if (this.autoRangeStickyZero) {
                    d3 = d3 <= 0.0 ? 0.0 : (d3 += d5);
                    d2 = d2 >= 0.0 ? 0.0 : (d2 -= d6);
                } else {
                    d3 = Math.max(0.0, d3 + d5);
                    d2 = Math.min(0.0, d2 - d6);
                }
            } else if (this.autoRangeStickyZero) {
                d3 = d3 <= 0.0 ? Math.min(0.0, d3 + d5) : (d3 += d5 * d4);
                d2 = d2 >= 0.0 ? Math.max(0.0, d2 - d6) : (d2 -= d6);
            } else {
                d3 += d5;
                d2 -= d6;
            }
            this.range = new Range(d2, d3);
        }
    }
}

