/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.CrosshairInfo;
import com.jrefinery.chart.HorizontalNumberAxis;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.data.Range;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OverlaidXYPlot
extends XYPlot {
    protected List subplots = new ArrayList();
    protected int seriesCount = 0;

    public OverlaidXYPlot(String string, String string2) {
        this(new HorizontalNumberAxis(string), new VerticalNumberAxis(string2));
    }

    public OverlaidXYPlot(ValueAxis valueAxis, ValueAxis valueAxis2) {
        super(null, valueAxis, valueAxis2);
    }

    public void add(XYPlot xYPlot) {
        ValueAxis valueAxis;
        xYPlot.setParent(this);
        xYPlot.setDomainAxis(null);
        xYPlot.setRangeAxis(null);
        xYPlot.setFirstSeriesIndex(this.seriesCount);
        this.seriesCount += xYPlot.getSeriesCount();
        this.subplots.add(xYPlot);
        ValueAxis valueAxis2 = this.getDomainAxis();
        if (valueAxis2 != null) {
            valueAxis2.configure();
        }
        if ((valueAxis = this.getRangeAxis()) != null) {
            valueAxis.configure();
        }
    }

    public List getLegendItemLabels() {
        ArrayList arrayList = new ArrayList();
        if (this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                XYPlot xYPlot = (XYPlot)iterator.next();
                List list = xYPlot.getLegendItemLabels();
                arrayList.addAll(list);
            }
        }
        return arrayList;
    }

    public void render(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, CrosshairInfo crosshairInfo) {
        Iterator iterator = this.subplots.iterator();
        while (iterator.hasNext()) {
            XYPlot xYPlot = (XYPlot)iterator.next();
            xYPlot.render(graphics2D, rectangle2D, chartRenderingInfo, crosshairInfo);
        }
    }

    public String getPlotType() {
        return "Overlaid XY Plot";
    }

    public Range getHorizontalDataRange() {
        Range range = null;
        if (this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                XYPlot xYPlot = (XYPlot)iterator.next();
                range = Range.combine(range, (Range)xYPlot.getHorizontalDataRange());
            }
        }
        return range;
    }

    public Range getVerticalDataRange() {
        Range range = null;
        if (this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                XYPlot xYPlot = (XYPlot)iterator.next();
                range = Range.combine(range, (Range)xYPlot.getVerticalDataRange());
            }
        }
        return range;
    }

    public int getSeriesCount() {
        int n = 0;
        Iterator iterator = this.subplots.iterator();
        while (iterator.hasNext()) {
            XYPlot xYPlot = (XYPlot)iterator.next();
            n += xYPlot.getSeriesCount();
        }
        return n;
    }

    public void setFirstSeriesIndex(int n) {
        this.firstSeriesIndex = n;
        int n2 = n;
        Iterator iterator = this.subplots.iterator();
        while (iterator.hasNext()) {
            XYPlot xYPlot = (XYPlot)iterator.next();
            xYPlot.setFirstSeriesIndex(n2);
            n2 += xYPlot.getSeriesCount();
        }
    }
}

