/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisConstants;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.SeriesShapeFactory;
import com.jrefinery.chart.ShapeFactory;
import com.jrefinery.chart.event.AxisChangeEvent;
import com.jrefinery.chart.event.AxisChangeListener;
import com.jrefinery.chart.event.PlotChangeEvent;
import com.jrefinery.chart.event.PlotChangeListener;
import com.jrefinery.data.Dataset;
import com.jrefinery.data.DatasetChangeEvent;
import com.jrefinery.data.DatasetChangeListener;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class Plot
implements AxisChangeListener,
DatasetChangeListener,
AxisConstants {
    public static final Number ZERO = new Integer(0);
    protected static final Insets DEFAULT_INSETS = new Insets(2, 2, 2, 10);
    protected static final Stroke DEFAULT_OUTLINE_STROKE = new BasicStroke(1.0f);
    protected static final Paint DEFAULT_OUTLINE_PAINT = Color.gray;
    protected static final float DEFAULT_FOREGROUND_ALPHA = 1.0f;
    protected static final float DEFAULT_BACKGROUND_ALPHA = 1.0f;
    protected static final Paint DEFAULT_BACKGROUND_PAINT = Color.white;
    protected static final int MINIMUM_WIDTH_TO_DRAW = 10;
    protected static final int MINIMUM_HEIGHT_TO_DRAW = 10;
    protected Dataset dataset;
    protected int firstSeriesIndex = 0;
    protected Insets insets;
    protected Stroke outlineStroke;
    protected Paint outlinePaint;
    protected Paint backgroundPaint;
    protected Image backgroundImage;
    protected float foregroundAlpha;
    protected float backgroundAlpha;
    protected Paint[] seriesPaint;
    protected Stroke[] seriesStroke;
    protected Paint[] seriesOutlinePaint;
    protected Stroke[] seriesOutlineStroke;
    protected List listeners;
    protected ShapeFactory shapeFactory;

    protected Plot(Dataset dataset) {
        this(dataset, DEFAULT_INSETS, DEFAULT_BACKGROUND_PAINT, null, 1.0f, DEFAULT_OUTLINE_STROKE, DEFAULT_OUTLINE_PAINT, 1.0f);
    }

    protected Plot(Dataset dataset, Insets insets, Paint paint, Image image, float f, Stroke stroke, Paint paint2, float f2) {
        this.dataset = dataset;
        if (dataset != null) {
            dataset.addChangeListener((DatasetChangeListener)this);
        }
        this.insets = insets;
        this.backgroundPaint = paint;
        this.backgroundAlpha = f;
        this.outlineStroke = stroke;
        this.outlinePaint = paint2;
        this.foregroundAlpha = f2;
        this.seriesStroke = new Stroke[]{new BasicStroke(1.0f)};
        this.seriesPaint = new Paint[]{Color.red, Color.blue, Color.green, Color.yellow, Color.orange, Color.magenta, Color.cyan, Color.pink, Color.lightGray};
        this.seriesOutlinePaint = new Paint[]{Color.gray};
        this.seriesOutlineStroke = new Stroke[]{new BasicStroke(0.5f)};
        this.listeners = new ArrayList();
        this.shapeFactory = new SeriesShapeFactory();
    }

    public abstract String getPlotType();

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDataset(Dataset dataset) {
        Dataset dataset2 = this.dataset;
        if (dataset2 != null) {
            dataset2.removeChangeListener((DatasetChangeListener)this);
        }
        this.dataset = dataset;
        if (this.dataset != null) {
            this.dataset.addChangeListener((DatasetChangeListener)this);
        }
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent((Object)this, dataset);
        this.datasetChanged(datasetChangeEvent);
    }

    public boolean isSubplot() {
        return false;
    }

    public int getFirstSeriesIndex() {
        return this.firstSeriesIndex;
    }

    public void setFirstSeriesIndex(int n) {
        this.firstSeriesIndex = n;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(Insets insets) {
        if (!this.insets.equals(insets)) {
            this.insets = insets;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        if (paint == null) {
            if (this.backgroundPaint != null) {
                this.backgroundPaint = null;
                this.notifyListeners(new PlotChangeEvent(this));
            }
        } else {
            if (this.backgroundPaint != null && this.backgroundPaint.equals(paint)) {
                return;
            }
            this.backgroundPaint = paint;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public float getBackgroundAlpha() {
        return this.backgroundAlpha;
    }

    public void setBackgroundAlpha(float f) {
        if (this.backgroundAlpha != f) {
            this.backgroundAlpha = f;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImage = image;
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke stroke) {
        if (stroke == null) {
            if (this.outlineStroke != null) {
                this.outlineStroke = null;
                this.notifyListeners(new PlotChangeEvent(this));
            }
        } else {
            if (this.outlineStroke != null && this.outlineStroke.equals(stroke)) {
                return;
            }
            this.outlineStroke = stroke;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlinePaint(Paint paint) {
        if (paint == null) {
            if (this.outlinePaint != null) {
                this.outlinePaint = null;
                this.notifyListeners(new PlotChangeEvent(this));
            }
        } else {
            if (this.outlinePaint != null && this.outlinePaint.equals(paint)) {
                return;
            }
            this.outlinePaint = paint;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public float getForegroundAlpha() {
        return this.foregroundAlpha;
    }

    public void setForegroundAlpha(float f) {
        if (this.foregroundAlpha != f) {
            this.foregroundAlpha = f;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public abstract List getLegendItemLabels();

    public Paint getSeriesPaint(int n) {
        if (this.isSubplot()) {
            n += this.firstSeriesIndex;
        }
        return this.seriesPaint[n % this.seriesPaint.length];
    }

    public void setSeriesPaint(Paint[] paintArray) {
        this.seriesPaint = paintArray;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void setSeriesPaint(int n, Paint paint) {
        if (this.isSubplot()) {
            n += this.firstSeriesIndex;
        }
        this.seriesPaint[n] = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getSeriesStroke(int n) {
        return this.seriesStroke[n % this.seriesStroke.length];
    }

    public void setSeriesStroke(Stroke[] strokeArray) {
        this.seriesStroke = strokeArray;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void setSeriesStroke(int n, Stroke stroke) {
        this.seriesStroke[n] = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getSeriesOutlinePaint(int n) {
        return this.seriesOutlinePaint[n % this.seriesOutlinePaint.length];
    }

    public void setSeriesOutlinePaint(Paint[] paintArray) {
        this.seriesOutlinePaint = paintArray;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getSeriesOutlineStroke(int n) {
        return this.seriesOutlineStroke[n % this.seriesOutlinePaint.length];
    }

    public void setSeriesOutlineStroke(Stroke[] strokeArray) {
        this.seriesOutlineStroke = strokeArray;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void setSeriesOutlineStroke(int n, Stroke stroke) {
        this.seriesOutlineStroke[n] = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public ShapeFactory getShapeFactory() {
        return this.shapeFactory;
    }

    public void setShapeFactory(ShapeFactory shapeFactory) {
        this.shapeFactory = shapeFactory;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Shape getShape(int n, int n2, double d, double d2, double d3) {
        Shape shape = null;
        if (this.shapeFactory != null) {
            shape = this.shapeFactory.getShape(n, n2, d, d2, d3);
        }
        return shape;
    }

    public Shape getShape(int n, Object object, double d, double d2, double d3) {
        Shape shape = null;
        if (this.shapeFactory != null) {
            shape = this.shapeFactory.getShape(n, object, d, d2, d3);
        }
        return shape;
    }

    public void notifyListeners(PlotChangeEvent plotChangeEvent) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            PlotChangeListener plotChangeListener = (PlotChangeListener)iterator.next();
            plotChangeListener.plotChanged(plotChangeEvent);
        }
    }

    public void addChangeListener(PlotChangeListener plotChangeListener) {
        this.listeners.add(plotChangeListener);
    }

    public void removeChangeListener(PlotChangeListener plotChangeListener) {
        this.listeners.remove(plotChangeListener);
    }

    public abstract void draw(Graphics2D var1, Rectangle2D var2, ChartRenderingInfo var3);

    public void drawOutlineAndBackground(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Composite composite;
        if (this.backgroundPaint != null) {
            composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.backgroundAlpha));
            graphics2D.setPaint(this.backgroundPaint);
            graphics2D.fill(rectangle2D);
            graphics2D.setComposite(composite);
        }
        if (this.backgroundImage != null) {
            composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.15f));
            graphics2D.drawImage(this.backgroundImage, (int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), null);
            graphics2D.setComposite(composite);
        }
        if (this.outlineStroke != null && this.outlinePaint != null) {
            graphics2D.setStroke(this.outlineStroke);
            graphics2D.setPaint(this.outlinePaint);
            graphics2D.draw(rectangle2D);
        }
    }

    public void handleClick(int n, int n2, ChartRenderingInfo chartRenderingInfo) {
    }

    public abstract void zoom(double var1);

    public void axisChanged(AxisChangeEvent axisChangeEvent) {
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        PlotChangeEvent plotChangeEvent = new PlotChangeEvent(this);
        this.notifyListeners(plotChangeEvent);
    }
}

