/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.Axis;
import com.jrefinery.chart.AxisNotCompatibleException;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.PlotNotCompatibleException;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalAxis;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.VerticalValuePlot;
import com.jrefinery.chart.event.PlotChangeEvent;
import com.jrefinery.data.Dataset;
import com.jrefinery.data.DatasetChangeEvent;
import com.jrefinery.data.DatasetChangeListener;
import com.jrefinery.data.DefaultMeterDataset;
import com.jrefinery.data.MeterDataset;
import com.jrefinery.data.Range;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.text.DecimalFormat;
import java.util.List;

public class ThermometerPlot
extends Plot
implements VerticalValuePlot {
    public static final int UNITS_NONE = 0;
    public static final int UNITS_FARINHEIGHT = 1;
    public static final int UNITS_CELCIUS = 2;
    public static final int UNITS_KELVIN = 3;
    protected static final String[] UNITS = new String[]{"", "\u00b0F", "\u00b0C", "\u00b0K"};
    protected MeterDataset data;
    protected int units = 2;
    RoundRectangle2D.Double outer1;
    RoundRectangle2D.Double outer2;
    RoundRectangle2D.Double outer3;
    Ellipse2D.Double circle1;
    Ellipse2D.Double circle2;
    public static final int NONE = 0;
    public static final int LEFT = 1;
    public static final int BULB = 2;
    protected int valueLocation = 2;
    protected static final int bulbRadius = 40;
    protected static final int bulbDiameter = 80;
    protected static final int columnRadius = 20;
    protected static final int columnDiameter = 40;
    protected static final int gapRadius = 5;
    protected static final int gapDiameter = 10;
    protected static final int legendWidth = 10;
    public static int NORMAL = 0;
    public static int WARNING = 1;
    public static int CRITICAL = 2;
    protected int range = WARNING;
    protected int rangeData = WARNING;
    protected static final int RANGE_HI = 0;
    protected static final int RANGE_LOW = 1;
    protected static final int DISPLAY_HI = 2;
    protected static final int DISPLAY_LOW = 3;
    protected static final int DISPLAY_RANGE = 4;
    protected double[][] rangeInfo = new double[][]{{2.0, -10.0, 1.0, -10.0, 11.0}, {29.0, 0.0, 26.0, 0.0, 26.0}, {41.0, 20.0, 40.0, 20.0, 20.0}};
    protected Paint[] rangePaint = new Paint[]{Color.blue, Color.yellow, Color.red};
    protected Color outerColour = Color.black;
    protected Color valueColour = Color.white;
    protected Font valueFont = new Font("Arial", 1, 24);
    protected DecimalFormat valueFormat = new DecimalFormat();
    protected Stroke outerStroke = new BasicStroke(1.0f);
    protected Stroke rangeInidcatorStroke = new BasicStroke(3.0f);
    protected int rangeIndcatorStrokeSize = 3;
    protected boolean followValue = false;
    protected boolean drawLines = false;
    protected boolean ignoreDataModelRangeChanges = true;
    protected ValueAxis rangeAxis;

    public ThermometerPlot() {
        this((MeterDataset)new DefaultMeterDataset());
    }

    public ThermometerPlot(MeterDataset meterDataset) {
        this(meterDataset, Plot.DEFAULT_INSETS, Plot.DEFAULT_BACKGROUND_PAINT, null, 1.0f, Plot.DEFAULT_OUTLINE_STROKE, Plot.DEFAULT_OUTLINE_PAINT, 1.0f);
    }

    public ThermometerPlot(MeterDataset meterDataset, Insets insets, Paint paint, Image image, float f, Stroke stroke, Paint paint2, float f2) {
        super((Dataset)meterDataset, insets, paint, image, f, stroke, paint2, f2);
        this.data = meterDataset;
        if (meterDataset != null) {
            meterDataset.addChangeListener((DatasetChangeListener)this);
        }
        this.setInsets(insets);
        this.circle1 = new Ellipse2D.Double();
        this.circle2 = new Ellipse2D.Double();
        this.outer1 = new RoundRectangle2D.Double();
        this.outer2 = new RoundRectangle2D.Double();
        this.outer3 = new RoundRectangle2D.Double();
        this.setRangeAxis(new VerticalNumberAxis(null));
        this.setAxisRange();
    }

    public void setRangeAxis(ValueAxis valueAxis) throws AxisNotCompatibleException {
        if (this.isCompatibleRangeAxis(valueAxis)) {
            if (valueAxis != null) {
                try {
                    valueAxis.setPlot(this);
                }
                catch (PlotNotCompatibleException plotNotCompatibleException) {
                    throw new AxisNotCompatibleException("Plot.setRangeAxis(...): plot not compatible with axis.");
                }
                valueAxis.addChangeListener(this);
            }
            if (this.rangeAxis != null) {
                this.rangeAxis.removeChangeListener(this);
            }
        } else {
            throw new AxisNotCompatibleException("Plot.setRangeAxis(...): axis not compatible with plot.");
        }
        this.rangeAxis = valueAxis;
    }

    public void zoom(double d) {
    }

    public String getPlotType() {
        return "Thermometer Plot";
    }

    public MeterDataset getData() {
        return this.data;
    }

    public void setData(MeterDataset meterDataset) {
        MeterDataset meterDataset2 = this.data;
        if (meterDataset2 != null) {
            meterDataset2.removeChangeListener((DatasetChangeListener)this);
        }
        this.data = meterDataset;
        if (this.data != null) {
            meterDataset.addChangeListener((DatasetChangeListener)this);
        }
        PlotChangeEvent plotChangeEvent = new PlotChangeEvent(this);
        this.notifyListeners(plotChangeEvent);
    }

    public boolean isCompatibleHorizontalAxis(Axis axis) {
        return axis == null;
    }

    public boolean isCompatibleVerticalAxis(Axis axis) {
        return axis instanceof VerticalNumberAxis;
    }

    protected static boolean isValidNumber(double d) {
        return !Double.isNaN(d) && !Double.isInfinite(d);
    }

    public void setValueFormat(DecimalFormat decimalFormat) {
        if (decimalFormat != null) {
            this.valueFormat = decimalFormat;
        }
    }

    public int getValueDisplayLocation() {
        return this.valueLocation;
    }

    public void setUnits(int n) {
        if (n >= 0 && n < UNITS.length && this.units != n) {
            this.units = n;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public void setUnits(String string) {
        if (string == null) {
            return;
        }
        string = string.toUpperCase().trim();
        int n = 0;
        while (n < UNITS.length) {
            if (string.equals(UNITS[n].toUpperCase().trim())) {
                this.setUnits(n);
                n = UNITS.length;
            }
            ++n;
        }
    }

    public void setFont(Font font) {
        if (font != null) {
            this.rangeAxis.setTickLabelFont(font);
            this.setValueFont(font);
        }
    }

    public void setValueFont(Font font) {
        if (font != null && !this.valueFont.equals(font)) {
            this.valueFont = font;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public int getUnits() {
        return this.units;
    }

    public Font getValueFont() {
        return this.valueFont;
    }

    public void setRangePaint(int n, Paint paint) {
        if (n >= 0 && n < this.rangePaint.length && paint != null) {
            this.rangePaint[n] = paint;
        }
    }

    public Paint getRangePaint(int n) {
        if (n >= 0 && n < this.rangePaint.length) {
            return this.rangePaint[n];
        }
        return Color.black;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        String string = null;
        FontMetrics fontMetrics = null;
        if (chartRenderingInfo != null) {
            chartRenderingInfo.setPlotArea(rectangle2D);
        }
        if (this.insets != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)this.insets.left, rectangle2D.getY() + (double)this.insets.top, rectangle2D.getWidth() - (double)this.insets.left - (double)this.insets.right, rectangle2D.getHeight() - (double)this.insets.top - (double)this.insets.bottom);
        }
        this.drawOutlineAndBackground(graphics2D, rectangle2D);
        int n8 = (int)(rectangle2D.getX() + rectangle2D.getWidth() / 2.0);
        int n9 = (int)(rectangle2D.getY() + rectangle2D.getHeight() / 2.0);
        int n10 = (int)(rectangle2D.getMinY() + 40.0);
        int n11 = (int)(rectangle2D.getMaxY() - 80.0);
        this.circle1.setFrame(n8 - 40, n11, 80.0, 80.0);
        n4 = n11 + 5;
        n = 70;
        n2 = 35;
        this.circle2.setFrame(n8 - n2, n4, n, n);
        this.outer1.setRoundRect(n8 - 20, rectangle2D.getMinY(), 40.0, n4, 40.0, 40.0);
        n = 30;
        n2 = 15;
        this.outer2.setRoundRect(n8 - n2, rectangle2D.getMinY() + 5.0, n, n4, n, n);
        Area area = new Area(this.circle1);
        Area area2 = new Area(this.outer1);
        area.add(area2);
        area2 = new Area(this.outer2);
        Area area3 = new Area(this.circle2);
        area2.add(area3);
        if (this.data != null && this.data.isValueValid()) {
            double d = this.data.getValue().doubleValue();
            this.rangeData = this.range;
            switch (this.range) {
                case 0: {
                    if (d > this.rangeInfo[1][0]) {
                        this.range = 2;
                    }
                    if (!(d > this.rangeInfo[0][0])) break;
                    this.range = 1;
                    break;
                }
                case 1: {
                    if (d > this.rangeInfo[1][2]) {
                        this.range = 2;
                    }
                    if (!(d < this.rangeInfo[1][3])) break;
                    this.range = 0;
                    break;
                }
                case 2: {
                    if (d < this.rangeInfo[2][1]) {
                        this.range = 1;
                    }
                    if (!(d < this.rangeInfo[1][1])) break;
                    this.range = 0;
                    break;
                }
                default: {
                    this.range = 1;
                }
            }
            if (this.rangeData != this.range) {
                this.setAxisRange();
            }
            this.rangeData = this.range;
            if (this.followValue && this.range == 1) {
                if (d < this.rangeInfo[0][0]) {
                    this.rangeData = 0;
                }
                if (d > this.rangeInfo[2][1]) {
                    this.rangeData = 2;
                }
            }
            double d2 = (d - this.rangeInfo[this.range][3]) / this.rangeInfo[this.range][4] * (double)(n11 - n10);
            n = 30;
            n2 = 15;
            n3 = n / 2;
            n4 = (int)((long)n11 - Math.round(d2));
            if ((double)n4 < 5.0 + rectangle2D.getMinY()) {
                n4 = (int)(5.0 + rectangle2D.getMinY());
                n3 = 40;
            }
            if (n4 < n11 + 40) {
                this.outer3.setRoundRect(n8 - n2, n4, n, n11 + 40 - n4, n3, n3);
                Area area4 = new Area(this.outer3);
                area3.add(area4);
            }
            graphics2D.setPaint(this.rangePaint[this.rangeData]);
            graphics2D.fill(area3);
            n = 0;
            if (this.drawLines) {
                n += 40;
            }
            Rectangle2D.Double double_ = new Rectangle2D.Double(n8 - 20 - 10, n10, 10 + n, n11 - n10 + 1);
            this.rangeAxis.draw(graphics2D, rectangle2D, double_);
            graphics2D.setStroke(this.rangeInidcatorStroke);
            if (this.rangeIndcatorStrokeSize > 0) {
                double d3 = (double)(n11 - n10) / this.rangeInfo[this.range][4];
                n6 = n8 + 20 + this.rangeIndcatorStrokeSize;
                n7 = n6 + 10;
                if (this.inRange(this.range, this.rangeInfo[1][1])) {
                    n5 = n10;
                    graphics2D.setPaint(this.rangePaint[1]);
                    graphics2D.drawLine(n6, n5 += (int)(d3 * (this.rangeInfo[this.range][2] - this.rangeInfo[1][1])), n7, n5);
                }
                if (this.inRange(this.range, this.rangeInfo[2][1])) {
                    n5 = n10;
                    graphics2D.setPaint(this.rangePaint[2]);
                    graphics2D.drawLine(n6, n5 += (int)(d3 * (this.rangeInfo[this.range][2] - this.rangeInfo[2][1])), n7, n5);
                }
            }
            graphics2D.setFont(this.valueFont);
            graphics2D.setColor(this.valueColour);
            fontMetrics = graphics2D.getFontMetrics();
            switch (this.valueLocation) {
                case 1: {
                    graphics2D.drawString(this.valueFormat.format(d), n8 + 20 + 5, n9);
                    break;
                }
                case 2: {
                    string = this.valueFormat.format(d);
                    n = fontMetrics.stringWidth(string) / 2;
                    graphics2D.drawString(string, n8 - n, n11 + 40 + 5);
                    break;
                }
            }
        }
        graphics2D.setColor(this.outerColour);
        graphics2D.setFont(this.valueFont);
        fontMetrics = graphics2D.getFontMetrics();
        n6 = n8 - 20 - 10 - fontMetrics.stringWidth(UNITS[this.units]);
        if ((double)n6 > rectangle2D.getMinX()) {
            graphics2D.drawString(UNITS[this.units], n6, (int)(rectangle2D.getMinY() + 20.0));
        }
        if (this.outerColour != null) {
            graphics2D.setStroke(this.outerStroke);
            graphics2D.draw(area);
            graphics2D.draw(area2);
        }
    }

    public void setRangeInfo(int n, double d, double d2) {
        this.setRangeInfo(n, d, d2, d, d2);
    }

    public void setRangeInfo(int n, double d, double d2, double d3, double d4) {
        if (n >= 0 && n < 3) {
            this.setRange(n, d, d2);
            this.setDisplayRange(n, d3, d4);
        }
    }

    public void setRange(int n, double d, double d2) {
        if (n >= 0 && n < 3) {
            this.rangeInfo[n][0] = d2;
            this.rangeInfo[n][1] = d;
        }
    }

    public void setDisplayRange(int n, double d, double d2) {
        if (n >= 0 && n < this.rangePaint.length && ThermometerPlot.isValidNumber(d2) && ThermometerPlot.isValidNumber(d)) {
            if (d2 > d) {
                this.rangeInfo[n][2] = d2;
                this.rangeInfo[n][3] = d;
            } else {
                this.rangeInfo[n][2] = d2;
                this.rangeInfo[n][3] = d;
            }
            this.rangeInfo[n][4] = this.rangeInfo[n][2] - this.rangeInfo[n][3];
        }
    }

    public void setDisplayLocation(int n) {
        if (n >= 0 && n < 3) {
            this.valueLocation = n;
        }
    }

    public void setThermometerColor(Color color) {
        this.outerColour = color;
    }

    private boolean inRange(int n, double d) {
        return this.rangeInfo[n][2] > d && this.rangeInfo[n][3] < d;
    }

    private void checkDataModelData() {
        if (this.data != null) {
            Number number = this.data.getMaximumCriticalValue();
            if (number != null) {
                this.rangeInfo[ThermometerPlot.CRITICAL][0] = number.doubleValue();
            }
            if ((number = this.data.getMinimumCriticalValue()) != null) {
                this.rangeInfo[ThermometerPlot.CRITICAL][1] = number.doubleValue();
            }
            if ((number = this.data.getMaximumWarningValue()) != null) {
                this.rangeInfo[ThermometerPlot.WARNING][0] = number.doubleValue();
            }
            if ((number = this.data.getMinimumWarningValue()) != null) {
                this.rangeInfo[ThermometerPlot.WARNING][1] = number.doubleValue();
            }
            if ((number = this.data.getMaximumNormalValue()) != null) {
                this.rangeInfo[ThermometerPlot.NORMAL][0] = number.doubleValue();
            }
            if ((number = this.data.getMinimumNormalValue()) != null) {
                this.rangeInfo[ThermometerPlot.NORMAL][1] = number.doubleValue();
            }
        }
    }

    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        if (!this.ignoreDataModelRangeChanges) {
            this.checkDataModelData();
        }
        super.datasetChanged(datasetChangeEvent);
    }

    public Number getMinimumVerticalDataValue() {
        return new Double(this.rangeInfo[this.range][3]);
    }

    public Number getMaximumVerticalDataValue() {
        return new Double(this.rangeInfo[this.range][2]);
    }

    public Range getVerticalDataRange() {
        return new Range(this.rangeInfo[this.range][3], this.rangeInfo[this.range][2]);
    }

    public void setShowValueLines(boolean bl) {
        this.drawLines = bl;
    }

    public boolean getShowValueLines(boolean bl) {
        return this.drawLines;
    }

    public void setFollowData(boolean bl) {
        this.followValue = bl;
    }

    public boolean getFollowData() {
        return this.followValue;
    }

    public void setRangeIndicatorWidth(int n) {
        if (n != this.rangeIndcatorStrokeSize && n >= 0 && n < 16) {
            this.rangeIndcatorStrokeSize = n;
            this.rangeInidcatorStroke = new BasicStroke(n);
        }
    }

    public int getRangeIndicatorWidth() {
        return this.rangeIndcatorStrokeSize;
    }

    public void setOuterStoke(Stroke stroke) {
        if (stroke != null) {
            this.outerStroke = stroke;
        }
    }

    public Stroke getOuterStroke() {
        return this.outerStroke;
    }

    public void propertyChange() {
        this.notifyListeners(new PlotChangeEvent(this));
    }

    protected void setAxisRange() {
        this.rangeAxis.setRange(new Range(this.rangeInfo[this.range][3], this.rangeInfo[this.range][2]));
    }

    public List getLegendItemLabels() {
        return null;
    }

    public boolean isCompatibleRangeAxis(ValueAxis valueAxis) {
        if (valueAxis == null) {
            return true;
        }
        return valueAxis instanceof VerticalAxis;
    }

    public ValueAxis getVerticalValueAxis() {
        return this.rangeAxis;
    }
}

