/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisConstants;
import com.jrefinery.chart.CategoryAxis;
import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.HorizontalCategoryPlot;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.Tick;
import com.jrefinery.chart.VerticalAxis;
import com.jrefinery.chart.event.AxisChangeEvent;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class VerticalCategoryAxis
extends CategoryAxis
implements VerticalAxis {
    public static final boolean DEFAULT_VERTICAL_LABEL = true;
    protected boolean verticalLabel;

    public VerticalCategoryAxis(String string) {
        this(string, AxisConstants.DEFAULT_AXIS_LABEL_FONT, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, true, true, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, false, AxisConstants.DEFAULT_TICK_STROKE);
    }

    public VerticalCategoryAxis(String string, Font font, Paint paint, Insets insets, boolean bl, boolean bl2, Font font2, Paint paint2, Insets insets2, boolean bl3, Stroke stroke) {
        super(string, font, paint, insets, bl2, font2, paint2, insets2, bl3, stroke);
        this.verticalLabel = bl;
    }

    public boolean isVerticalLabel() {
        return this.verticalLabel;
    }

    public void setVerticalLabel(boolean bl) {
        if (this.verticalLabel != bl) {
            this.verticalLabel = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        Object object;
        Object object2;
        if (!this.visible) {
            return;
        }
        if (this.label != null) {
            double d;
            double d2;
            graphics2D.setFont(this.labelFont);
            graphics2D.setPaint(this.labelPaint);
            object2 = graphics2D.getFontRenderContext();
            object = this.labelFont.getLineMetrics(this.label, (FontRenderContext)object2);
            Rectangle2D rectangle2D3 = this.labelFont.getStringBounds(this.label, (FontRenderContext)object2);
            if (this.verticalLabel) {
                d2 = rectangle2D.getX() + (double)this.labelInsets.left + (double)((LineMetrics)object).getHeight() - (double)((LineMetrics)object).getDescent() - (double)((LineMetrics)object).getLeading();
                d = rectangle2D2.getY() + rectangle2D2.getHeight() / 2.0 + rectangle2D3.getWidth() / 2.0;
                RefineryUtilities.drawRotatedString((String)this.label, (Graphics2D)graphics2D, (float)((float)d2), (float)((float)d), (double)-1.5707963267948966);
            } else {
                d2 = rectangle2D.getX() + (double)this.labelInsets.left;
                d = rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - rectangle2D3.getHeight() / 2.0;
                graphics2D.drawString(this.label, (float)d2, (float)d);
            }
        }
        if (this.tickLabelsVisible) {
            graphics2D.setFont(this.tickLabelFont);
            graphics2D.setPaint(this.tickLabelPaint);
            this.refreshTicks(graphics2D, rectangle2D, rectangle2D2);
            object2 = this.ticks.iterator();
            while (object2.hasNext()) {
                object = (Tick)object2.next();
                graphics2D.drawString(((Tick)object).getText(), ((Tick)object).getX(), ((Tick)object).getY());
            }
        }
    }

    public void refreshTicks(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        this.ticks.clear();
        CategoryPlot categoryPlot = (CategoryPlot)this.plot;
        CategoryDataset categoryDataset = categoryPlot.getCategoryDataset();
        if (categoryDataset != null) {
            Font font = this.getTickLabelFont();
            graphics2D.setFont(font);
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            int n = 0;
            Iterator iterator = categoryDataset.getCategories().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                String string = e.toString();
                Rectangle2D rectangle2D3 = font.getStringBounds(string, fontRenderContext);
                LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
                float f = (float)(rectangle2D2.getX() - (double)this.tickLabelInsets.right - rectangle2D3.getWidth());
                float f2 = (float)(categoryPlot.getCategoryCoordinate(n, rectangle2D2) - (double)lineMetrics.getStrikethroughOffset() + 0.5);
                Tick tick = new Tick(e, string, f, f2);
                this.ticks.add(tick);
                ++n;
            }
        }
    }

    public double reserveWidth(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D) {
        if (!this.visible) {
            return 0.0;
        }
        double d = 0.0;
        if (this.label != null) {
            Rectangle2D rectangle2D2 = this.labelFont.getStringBounds(this.label, graphics2D.getFontRenderContext());
            d = this.labelInsets.left + this.labelInsets.right;
            d = this.verticalLabel ? (d += rectangle2D2.getHeight()) : (d += rectangle2D2.getWidth());
        }
        double d2 = this.tickLabelInsets.left + this.tickLabelInsets.right;
        if (this.tickLabelsVisible) {
            this.refreshTicks(graphics2D, rectangle2D, rectangle2D);
            d2 += this.getMaxTickLabelWidth(graphics2D, rectangle2D);
        }
        return d + d2;
    }

    public Rectangle2D reserveAxisArea(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, double d) {
        if (!this.visible) {
            return new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), 0.0, rectangle2D.getHeight() - d);
        }
        double d2 = 0.0;
        if (this.label != null) {
            Rectangle2D rectangle2D2 = this.labelFont.getStringBounds(this.label, graphics2D.getFontRenderContext());
            d2 = this.labelInsets.left + this.labelInsets.right;
            d2 = this.verticalLabel ? (d2 += rectangle2D2.getHeight()) : (d2 += rectangle2D2.getWidth());
        }
        double d3 = this.tickLabelInsets.left + this.tickLabelInsets.right;
        if (this.tickLabelsVisible) {
            this.refreshTicks(graphics2D, rectangle2D, rectangle2D);
            d3 += this.getMaxTickLabelWidth(graphics2D, rectangle2D);
        }
        return new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), d2 + d3, rectangle2D.getHeight() - d);
    }

    protected boolean isCompatiblePlot(Plot plot) {
        return plot instanceof HorizontalCategoryPlot;
    }

    public void configure() {
    }
}

