/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AbstractXYItemRenderer;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.CrosshairInfo;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.XYItemRenderer;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.chart.entity.EntityCollection;
import com.jrefinery.chart.entity.XYItemEntity;
import com.jrefinery.chart.tooltips.StandardXYToolTipGenerator;
import com.jrefinery.chart.tooltips.XYToolTipGenerator;
import com.jrefinery.data.IntervalXYDataset;
import com.jrefinery.data.XYDataset;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;

public class VerticalXYBarRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer {
    protected double margin;
    protected double translatedRangeZero;

    public VerticalXYBarRenderer() {
        this(0.0, new StandardXYToolTipGenerator());
    }

    public VerticalXYBarRenderer(double d) {
        this(d, new StandardXYToolTipGenerator());
    }

    public VerticalXYBarRenderer(double d, XYToolTipGenerator xYToolTipGenerator) {
        super(xYToolTipGenerator);
        this.margin = d;
    }

    public void setMargin(double d) {
        Double d2 = new Double(this.margin);
        this.margin = d;
        this.firePropertyChanged("VerticalXYBarRenderer.margin", d2, new Double(d));
    }

    public void initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, ChartRenderingInfo chartRenderingInfo) {
        super.initialise(graphics2D, rectangle2D, xYPlot, xYDataset, chartRenderingInfo);
        ValueAxis valueAxis = xYPlot.getRangeAxis();
        this.translatedRangeZero = valueAxis.translateValueToJava2D(0.0, rectangle2D);
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairInfo crosshairInfo) {
        EntityCollection entityCollection;
        IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
        Paint paint = xYPlot.getSeriesPaint(n);
        Paint paint2 = xYPlot.getSeriesOutlinePaint(n);
        Number number = intervalXYDataset.getYValue(n, n2);
        double d = valueAxis2.translateValueToJava2D(number.doubleValue(), rectangle2D);
        Number number2 = intervalXYDataset.getStartXValue(n, n2);
        double d2 = valueAxis.translateValueToJava2D(number2.doubleValue(), rectangle2D);
        Number number3 = intervalXYDataset.getEndXValue(n, n2);
        double d3 = valueAxis.translateValueToJava2D(number3.doubleValue(), rectangle2D);
        double d4 = Math.max(1.0, d3 - d2);
        double d5 = Math.abs(d - this.translatedRangeZero);
        if (this.margin > 0.0) {
            double d6 = d4 * this.margin;
            d4 -= d6;
            d2 += d6 / 2.0;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d2, Math.min(this.translatedRangeZero, d), d4, d5);
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (d3 - d2 > 3.0) {
            graphics2D.setStroke(xYPlot.getSeriesOutlineStroke(n));
            graphics2D.setPaint(paint2);
            graphics2D.draw(double_);
        }
        if (chartRenderingInfo != null && (entityCollection = chartRenderingInfo.getEntityCollection()) != null) {
            String string = "";
            if (this.toolTipGenerator != null) {
                string = this.toolTipGenerator.generateToolTip(xYDataset, n, n2);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(double_, string, n, n2);
            entityCollection.addEntity(xYItemEntity);
        }
    }
}

