/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.gui;

import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataField;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.local.LocalFile;
import edu.sdsc.grid.io.local.LocalMetaDataRecordList;
import edu.sdsc.grid.io.srb.SRBFile;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.plaf.metal.MetalIconFactory;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JargonTreeModel
implements TreeModel {
    private String FIRST_COLUMN_NAME = "Name";
    public static String TOP_LEVEL = "DataGrid";
    private Object root;
    private Object[] subRoots;
    protected EventListenerList listenerList = new EventListenerList();
    private boolean showMetaData = false;
    private MetaDataSelect[] selects;
    private MetaDataField[] fields;
    private int fieldsLength;
    private int[] fieldsOrder;
    private Hashtable table = new Hashtable();
    private HashSet nodeSet = new HashSet();
    private HashSet leafSet = new HashSet();
    private Hashtable resultTable = new Hashtable();
    public static Icon FOLDER_ICON = new MetalIconFactory.FolderIcon16();
    public static Icon FILE_ICON = new MetalIconFactory.FileIcon16();
    static /* synthetic */ Class class$javax$swing$event$TreeModelListener;

    public JargonTreeModel(GeneralFile generalFile) {
        this.root = generalFile;
        this.selects = new MetaDataSelect[2];
        this.selects[0] = MetaDataSet.newSelection("file name");
        this.selects[1] = MetaDataSet.newSelection("directory name");
    }

    public JargonTreeModel(GeneralFile[] generalFileArray) {
        this.root = TOP_LEVEL;
        this.subRoots = generalFileArray;
        this.selects = new MetaDataSelect[2];
        this.selects[0] = MetaDataSet.newSelection("file name");
        this.selects[1] = MetaDataSet.newSelection("directory name");
    }

    JargonTreeModel(GeneralFile generalFile, MetaDataSelect[] metaDataSelectArray) throws IOException {
        this.root = generalFile;
        if (metaDataSelectArray == null) {
            metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("file name"), MetaDataSet.newSelection("directory name")};
        } else {
            this.showMetaData = this.loadFields(generalFile, metaDataSelectArray);
        }
    }

    JargonTreeModel(GeneralFile[] generalFileArray, MetaDataSelect[] metaDataSelectArray) throws IOException {
        this.root = TOP_LEVEL;
        this.subRoots = generalFileArray;
        if (metaDataSelectArray == null) {
            metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("file name"), MetaDataSet.newSelection("directory name")};
        } else {
            int n = 0;
            while (n < generalFileArray.length) {
                this.showMetaData = this.showMetaData || this.loadFields(generalFileArray[n], metaDataSelectArray);
                ++n;
            }
        }
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.add(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = JargonTreeModel.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, treeModelListener);
    }

    protected void fireTreeStructureChanged(Object object) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{object});
        EventListener[] eventListenerArray = this.listenerList.getListeners(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = JargonTreeModel.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener);
        int n = 0;
        while (n < eventListenerArray.length) {
            ((TreeModelListener)eventListenerArray[n]).treeStructureChanged(treeModelEvent);
            ++n;
        }
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.remove(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = JargonTreeModel.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, treeModelListener);
    }

    public void setRoot(Object object) {
        Object object2 = this.root;
        if (object != null) {
            if (!(object instanceof GeneralFile)) {
                throw new ClassCastException("Root must be an instance of GeneralFile");
            }
        } else {
            throw new NullPointerException("Root cannot be null");
        }
        this.root = object;
        this.fireTreeStructureChanged(object2);
    }

    public Object getRoot() {
        return this.root;
    }

    public Object getChild(Object object, int n) {
        String[] stringArray;
        if (object instanceof String) {
            if (object.equals(TOP_LEVEL)) {
                return this.subRoots[n];
            }
        } else if (object instanceof LocalFile) {
            String[] stringArray2 = ((LocalFile)object).list();
            if (stringArray2 == null || n >= stringArray2.length) {
                return null;
            }
            return new LocalFile((LocalFile)object, stringArray2[n]);
        }
        if ((stringArray = (String[])this.table.get(object)) == null) {
            stringArray = ((GeneralFile)object).list();
            this.table.put(object, stringArray);
        }
        return FileFactory.newFile((GeneralFile)object, stringArray[n]);
    }

    public int getChildCount(Object object) {
        String[] stringArray;
        if (object instanceof String) {
            if (object.equals(TOP_LEVEL)) {
                return this.subRoots.length;
            }
        } else if (object instanceof LocalFile) {
            String[] stringArray2 = ((LocalFile)object).list();
            if (stringArray2 == null) {
                return 0;
            }
            return stringArray2.length;
        }
        if ((stringArray = (String[])this.table.get(object)) == null) {
            this.store(object);
            stringArray = ((GeneralFile)object).list();
            if (stringArray != null) {
                this.table.put(object, stringArray);
            }
        }
        if (stringArray != null) {
            return stringArray.length;
        }
        return 0;
    }

    public int getIndexOfChild(Object object, Object object2) {
        if (object instanceof String) {
            if (object.equals(TOP_LEVEL)) {
                int n = 0;
                while (n < this.subRoots.length) {
                    if (object2.equals(this.subRoots[n])) {
                        return n;
                    }
                    ++n;
                }
                int n2 = 0;
                while (n2 < this.subRoots.length) {
                    if (this.subRoots[n2].getClass().equals(object2.getClass())) {
                        object = this.subRoots[n2];
                    }
                    ++n2;
                }
            }
        } else if (object instanceof LocalFile) {
            String[] stringArray = ((LocalFile)object).list();
            if (stringArray == null) {
                return -1;
            }
            String string = ((LocalFile)object2).getName();
            int n = 0;
            while (n < stringArray.length) {
                if (string.equals(stringArray[n])) {
                    return n;
                }
                ++n;
            }
            return -1;
        }
        String string = ((GeneralFile)object2).getName();
        String[] stringArray = (String[])this.table.get(object);
        if (stringArray == null) {
            stringArray = ((GeneralFile)object).list();
            this.table.put(object, stringArray);
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public boolean isLeaf(Object object) {
        if (object instanceof String) {
            if (object.equals(TOP_LEVEL)) {
                return false;
            }
        } else if (object instanceof LocalFile) {
            return ((LocalFile)object).isFile();
        }
        if (this.leafSet.contains(object)) {
            return true;
        }
        if (this.nodeSet.contains(object)) {
            return false;
        }
        GeneralFile generalFile = (GeneralFile)object;
        if (generalFile.isDirectory()) {
            this.nodeSet.add(object);
            return false;
        }
        this.leafSet.add(object);
        return true;
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        System.out.println("valueForPathChanged : " + treePath + " --> " + object);
    }

    private void store(Object object) {
        block8: {
            if (!(object instanceof SRBFile)) break block8;
            GeneralFileSystem generalFileSystem = ((GeneralFile)object).getFileSystem();
            GeneralFile generalFile = null;
            String string = null;
            MetaDataRecordList[] metaDataRecordListArray = null;
            MetaDataRecordList[] metaDataRecordListArray2 = null;
            MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[1];
            MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("directory name")};
            try {
                int n;
                string = ((GeneralFile)object).getAbsolutePath();
                metaDataConditionArray[0] = MetaDataSet.newCondition("directory name", 0, string);
                metaDataRecordListArray = generalFileSystem.query(metaDataConditionArray, this.selects);
                if (metaDataRecordListArray != null) {
                    n = 0;
                    while (n < metaDataRecordListArray.length) {
                        generalFile = FileFactory.newFile(generalFileSystem, metaDataRecordListArray[n].getValue("directory name").toString(), metaDataRecordListArray[n].getValue("file name").toString());
                        this.leafSet.add(generalFile);
                        if (this.showMetaData) {
                            this.resultTable.put(generalFile, metaDataRecordListArray[n]);
                        }
                        ++n;
                    }
                }
                metaDataConditionArray[0] = MetaDataSet.newCondition("parent directory name", 0, string);
                metaDataRecordListArray2 = generalFileSystem.query(metaDataConditionArray, metaDataSelectArray);
                if (metaDataRecordListArray2 != null) {
                    n = 0;
                    while (n < metaDataRecordListArray2.length) {
                        generalFile = FileFactory.newFile(generalFileSystem, metaDataRecordListArray2[n].getValue("directory name").toString());
                        this.nodeSet.add(generalFile);
                        if (this.showMetaData) {
                            this.resultTable.put(generalFile, metaDataRecordListArray2[n]);
                        }
                        ++n;
                    }
                }
            }
            catch (IOException iOException) {}
        }
    }

    private boolean loadFields(GeneralFile generalFile, MetaDataSelect[] metaDataSelectArray) throws IOException {
        if (generalFile instanceof LocalFile) {
            return false;
        }
        GeneralFileSystem generalFileSystem = generalFile.getFileSystem();
        MetaDataSelect[] metaDataSelectArray2 = new MetaDataSelect[]{MetaDataSet.newSelection("file name"), MetaDataSet.newSelection("directory name")};
        metaDataSelectArray = MetaDataSet.mergeSelects(metaDataSelectArray, metaDataSelectArray2);
        if ((metaDataSelectArray = (MetaDataSelect[])this.cleanArray(metaDataSelectArray)) == null) {
            throw new NullPointerException("No valid Selects");
        }
        this.selects = metaDataSelectArray;
        MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("size", 0, "0")};
        MetaDataRecordList[] metaDataRecordListArray = generalFileSystem.query(metaDataConditionArray, metaDataSelectArray, 1);
        if (metaDataRecordListArray == null) {
            metaDataConditionArray[0] = MetaDataSet.newCondition("size", 1, "0");
            metaDataRecordListArray = generalFileSystem.query(metaDataConditionArray, metaDataSelectArray, 1);
        }
        if (metaDataRecordListArray != null) {
            int n = metaDataRecordListArray[0].getFieldCount();
            this.fields = new MetaDataField[n];
            int n2 = 0;
            while (n2 < n) {
                this.fields[n2] = metaDataRecordListArray[0].getField(n2);
                ++n2;
            }
            this.fieldsLength = this.fields.length;
            return true;
        }
        return false;
    }

    Object getValueAt(Object object, int n) {
        Object object2;
        if (object instanceof LocalFile) {
            if (n == 0) {
                return ((LocalFile)object).getName();
            }
            return "-";
        }
        GeneralFile generalFile = (GeneralFile)object;
        GeneralFileSystem generalFileSystem = generalFile.getFileSystem();
        if (n == 0) {
            if (this.isLeaf(object)) {
                return generalFile.getName();
            }
            return generalFile.getAbsolutePath();
        }
        MetaDataRecordList metaDataRecordList = (MetaDataRecordList)this.resultTable.get(generalFile);
        MetaDataRecordList[] metaDataRecordListArray = null;
        if (metaDataRecordList != null) {
            if (!(metaDataRecordList instanceof LocalMetaDataRecordList)) {
                if (n >= metaDataRecordList.getFieldCount()) {
                    return metaDataRecordList.getValue(n);
                }
                return metaDataRecordList.getValue(n);
            }
            return "";
        }
        if (!this.isLeaf(generalFile)) {
            Object object3;
            try {
                object3 = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", 0, generalFile.getAbsolutePath())};
                metaDataRecordListArray = generalFileSystem.query((MetaDataCondition[])object3, this.selects);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (metaDataRecordListArray != null) {
                object3 = null;
                int n2 = 0;
                while (n2 < metaDataRecordListArray.length) {
                    object3 = FileFactory.newFile(generalFile.getFileSystem(), metaDataRecordListArray[n2].getValue("directory name").toString());
                    this.resultTable.put(object3, metaDataRecordListArray[n2]);
                    ++n2;
                }
                if (n > 6) {
                    n = 6;
                }
                return metaDataRecordListArray[0].getValue(n);
            }
            object3 = new LocalMetaDataRecordList();
            this.resultTable.put(generalFile, object3);
            return "1";
        }
        try {
            object2 = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", 0, generalFile.getParent()), MetaDataSet.newCondition("file name", 0, generalFile.getName())};
            metaDataRecordListArray = generalFileSystem.query((MetaDataCondition[])object2, this.selects);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (metaDataRecordListArray != null) {
            object2 = null;
            int n3 = 0;
            while (n3 < metaDataRecordListArray.length) {
                object2 = FileFactory.newFile(generalFile.getFileSystem(), metaDataRecordListArray[n3].getValue("directory name").toString(), metaDataRecordListArray[n3].getValue("file name").toString());
                this.resultTable.put(object2, metaDataRecordListArray[n3]);
                ++n3;
            }
            return metaDataRecordListArray[0].getValue(n);
        }
        object2 = new LocalMetaDataRecordList();
        this.resultTable.put(generalFile, object2);
        return "11";
    }

    JTable getMetaData(GeneralFile generalFile) {
        GeneralFile generalFile2 = generalFile;
        MetaDataRecordList metaDataRecordList = (MetaDataRecordList)this.resultTable.get(generalFile2);
        if (metaDataRecordList == null) {
            return null;
        }
        int n = metaDataRecordList.getFieldCount();
        Object[][] objectArray = new Object[1][n];
        Object[] objectArray2 = new String[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray2[n2] = metaDataRecordList.getFieldName(n2);
            objectArray[0][n2] = metaDataRecordList.getValue(n2);
            ++n2;
        }
        return new JTable(objectArray, objectArray2);
    }

    Object[] cleanArray(Object[] objectArray) {
        Vector<Object> vector = new Vector<Object>(objectArray.length);
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] != null) {
                n2 = n + 1;
                while (n2 < objectArray.length) {
                    if (objectArray[n].equals(objectArray[n2])) {
                        bl = false;
                        n2 = objectArray.length;
                    }
                    ++n2;
                }
                if (bl) {
                    vector.add(objectArray[n]);
                }
                bl = true;
            }
            ++n;
        }
        n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] != null) {
                return vector.toArray((Object[])Array.newInstance(objectArray[n].getClass(), 0));
            }
            ++n;
        }
        return null;
    }

    MetaDataRecordList getMetaDataRecordList(Object object) {
        return (MetaDataRecordList)this.resultTable.get(object);
    }

    boolean showMetaData() {
        return this.showMetaData;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

