/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.srb;

import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.RemoteFileInputStream;
import edu.sdsc.grid.io.srb.SRBFile;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import java.io.IOException;

public class SRBFileInputStream
extends RemoteFileInputStream {
    long filePointer = 0L;
    protected SRBFileSystem fileSystem;
    private SRBFile file;

    public SRBFileInputStream(SRBFileSystem sRBFileSystem, String string) throws IOException {
        super(sRBFileSystem, string);
        this.fileSystem = sRBFileSystem;
    }

    public SRBFileInputStream(SRBFile sRBFile) throws IOException {
        super(sRBFile);
        this.fileSystem = (SRBFileSystem)sRBFile.getFileSystem();
    }

    protected void open(GeneralFile generalFile) throws IOException {
        this.file = (SRBFile)generalFile;
        this.fd = ((SRBFileSystem)generalFile.getFileSystem()).srbObjOpen(generalFile.getName(), 0, generalFile.getParent());
    }

    public int read() throws IOException {
        byte[] byArray = this.fileSystem.srbObjRead(this.fd, 1);
        if (byArray != null) {
            this.filePointer += (long)byArray.length;
            return byArray[0];
        }
        return -1;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = null;
        byArray2 = this.fileSystem.srbObjRead(this.fd, n2);
        if (byArray2 != null) {
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            this.filePointer += (long)byArray2.length;
            return byArray2.length;
        }
        return -1;
    }

    public long skip(long l) throws IOException {
        long l2 = this.available();
        if (this.filePointer + l < l2) {
            this.fileSystem.srbObjSeek(this.fd, l, 1);
            this.filePointer += l;
            return l;
        }
        this.fileSystem.srbObjSeek(this.fd, l2, 1);
        this.filePointer += l2;
        return l2;
    }

    public int available() throws IOException {
        MetaDataRecordList[] metaDataRecordListArray = null;
        MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", 0, this.file.getParent()), MetaDataSet.newCondition("file name", 0, this.file.getName())};
        MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("size")};
        try {
            metaDataRecordListArray = this.fileSystem.query(metaDataConditionArray, metaDataSelectArray, 3);
            if (metaDataRecordListArray != null) {
                return (int)(Long.parseLong(metaDataRecordListArray[0].getValue("size").toString()) - this.filePointer);
            }
        }
        catch (IOException iOException) {}
        return 0;
    }

    public void close() throws IOException {
        if (this.fileSystem != null) {
            this.fileSystem.srbObjClose(this.fd);
            this.fileSystem = null;
        }
        if (this.file != null) {
            this.file = null;
        }
    }
}

