/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.srb;

import edu.sdsc.grid.io.Host;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.MetaDataTable;
import edu.sdsc.grid.io.srb.SRBAccount;
import edu.sdsc.grid.io.srb.SRBCommands;
import edu.sdsc.grid.io.srb.SRBException;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import edu.sdsc.grid.io.srb.SRBMetaDataRecordList;
import edu.sdsc.grid.io.srb.SRBMetaDataSet;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Vector;

class SRBMetaDataCommands {
    private SRBCommands commands;

    SRBMetaDataCommands(SRBCommands sRBCommands) throws IOException {
        this.commands = sRBCommands;
    }

    protected void finalize() {
        if (this.commands != null) {
            this.commands = null;
        }
    }

    static String getOperator(MetaDataCondition metaDataCondition) {
        return MetaDataCondition.getOperatorString(metaDataCondition.getOperator());
    }

    static String getOperator(int n) {
        return MetaDataCondition.getOperatorString(n);
    }

    private String quotes(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return "";
            }
        }
        return "'";
    }

    private void setTableQval(MetaDataTable metaDataTable, char[][] cArray, String string) {
        String string2 = new String("= '" + metaDataTable.getStringValue(0, 0) + "'");
        System.arraycopy(string2.toCharArray(), 0, cArray[SRBMetaDataSet.getSRBID(string + "0_1")], 0, string2.length());
        string2 = new String(SRBMetaDataCommands.getOperator(metaDataTable.getOperator(0)) + " '" + metaDataTable.getStringValue(0, 1) + "'");
        System.arraycopy(string2.toCharArray(), 0, cArray[SRBMetaDataSet.getSRBID(string + "1_1")], 0, string2.length());
        if (metaDataTable.getRowCount() >= 2) {
            string2 = new String("= '" + metaDataTable.getStringValue(1, 0) + "'");
            System.arraycopy(string2.toCharArray(), 0, cArray[SRBMetaDataSet.getSRBID(string + "0_2")], 0, string2.length());
            string2 = new String(SRBMetaDataCommands.getOperator(metaDataTable.getOperator(1)) + " '" + metaDataTable.getStringValue(1, 1) + "'");
            System.arraycopy(string2.toCharArray(), 0, cArray[SRBMetaDataSet.getSRBID(string + "1_2")], 0, string2.length());
        }
        if (metaDataTable.getRowCount() >= 3) {
            string2 = new String("= '" + metaDataTable.getStringValue(2, 0) + "'");
            System.arraycopy(string2.toCharArray(), 0, cArray[SRBMetaDataSet.getSRBID(string + "0_3")], 0, string2.length());
            string2 = new String(SRBMetaDataCommands.getOperator(metaDataTable.getOperator(2)) + " '" + metaDataTable.getStringValue(2, 1) + "'");
            System.arraycopy(string2.toCharArray(), 0, cArray[SRBMetaDataSet.getSRBID(string + "1_3")], 0, string2.length());
        }
        if (metaDataTable.getRowCount() >= 4) {
            string2 = new String("= '" + metaDataTable.getStringValue(3, 0) + "'");
            System.arraycopy(string2.toCharArray(), 0, cArray[SRBMetaDataSet.getSRBID(string + "0_4")], 0, string2.length());
            string2 = new String(SRBMetaDataCommands.getOperator(metaDataTable.getOperator(3)) + " " + "'" + metaDataTable.getStringValue(3, 1) + "'");
            System.arraycopy(string2.toCharArray(), 0, cArray[SRBMetaDataSet.getSRBID(string + "1_4")], 0, string2.length());
        }
        if ((string.equals("definable metadata for files") || string.equals("definable metadata for directories")) && metaDataTable.getRowCount() >= 5) {
            string2 = new String("= '" + metaDataTable.getStringValue(4, 0) + "'");
            System.arraycopy(string2.toCharArray(), 0, cArray[SRBMetaDataSet.getSRBID(string + "0_5")], 0, string2.length());
            string2 = new String(SRBMetaDataCommands.getOperator(metaDataTable.getOperator(4)) + " '" + metaDataTable.getStringValue(4, 1) + "'");
            System.arraycopy(string2.toCharArray(), 0, cArray[SRBMetaDataSet.getSRBID(string + "1_5")], 0, string2.length());
        }
    }

    private String setTableGenQuery(MetaDataTable metaDataTable, String string) {
        if (metaDataTable == null) {
            return "";
        }
        String string2 = new String("= '" + metaDataTable.getStringValue(0, 0) + "'\u0000");
        SRBMetaDataSet.getSRBID(string + "0_1");
        string2 = string2 + new String(SRBMetaDataCommands.getOperator(metaDataTable.getOperator(0)) + " '" + metaDataTable.getStringValue(0, 1) + "'\u0000");
        SRBMetaDataSet.getSRBID(string + "1_1");
        if (metaDataTable.getRowCount() >= 2) {
            string2 = string2 + new String("= '" + metaDataTable.getStringValue(1, 0) + "'\u0000");
            SRBMetaDataSet.getSRBID(string + "0_2");
            string2 = string2 + new String(SRBMetaDataCommands.getOperator(metaDataTable.getOperator(1)) + " '" + metaDataTable.getStringValue(1, 1) + "'\u0000");
            SRBMetaDataSet.getSRBID(string + "1_2");
        }
        if (metaDataTable.getRowCount() >= 3) {
            string2 = string2 + new String("= '" + metaDataTable.getStringValue(2, 0) + "'\u0000");
            SRBMetaDataSet.getSRBID(string + "0_3");
            string2 = string2 + new String(SRBMetaDataCommands.getOperator(metaDataTable.getOperator(2)) + " '" + metaDataTable.getStringValue(2, 1) + "'\u0000");
            SRBMetaDataSet.getSRBID(string + "1_3");
        }
        if (metaDataTable.getRowCount() >= 4) {
            string2 = string2 + new String("= '" + metaDataTable.getStringValue(3, 0) + "'\u0000");
            SRBMetaDataSet.getSRBID(string + "0_4");
            string2 = string2 + new String(SRBMetaDataCommands.getOperator(metaDataTable.getOperator(3)) + " " + "'" + metaDataTable.getStringValue(3, 1) + "'\u0000");
            SRBMetaDataSet.getSRBID(string + "1_4");
        }
        if ((string.equals("definable metadata for files") || string.equals("definable metadata for directories")) && metaDataTable.getRowCount() >= 5) {
            string2 = string2 + new String("= '" + metaDataTable.getStringValue(4, 0) + "'\u0000");
            SRBMetaDataSet.getSRBID(string + "0_5");
            string2 = string2 + new String(SRBMetaDataCommands.getOperator(metaDataTable.getOperator(4)) + " '" + metaDataTable.getStringValue(4, 1) + "'\u0000");
            SRBMetaDataSet.getSRBID(string + "1_5");
        }
        return string2;
    }

    private byte[] setTableConditionIDs(MetaDataTable metaDataTable, String string) {
        Vector<Integer> vector = new Vector<Integer>(10);
        vector.add(new Integer(SRBMetaDataSet.getSRBID(string + "0_1")));
        vector.add(new Integer(SRBMetaDataSet.getSRBID(string + "1_1")));
        if (metaDataTable.getRowCount() >= 2) {
            vector.add(new Integer(SRBMetaDataSet.getSRBID(string + "0_2")));
            vector.add(new Integer(SRBMetaDataSet.getSRBID(string + "1_2")));
        }
        if (metaDataTable.getRowCount() >= 3) {
            vector.add(new Integer(SRBMetaDataSet.getSRBID(string + "0_3")));
            vector.add(new Integer(SRBMetaDataSet.getSRBID(string + "1_3")));
        }
        if (metaDataTable.getRowCount() >= 4) {
            vector.add(new Integer(SRBMetaDataSet.getSRBID(string + "0_4")));
            vector.add(new Integer(SRBMetaDataSet.getSRBID(string + "1_4")));
        }
        if ((string.equals("definable metadata for files") || string.equals("definable metadata for directories")) && metaDataTable.getRowCount() >= 5) {
            vector.add(new Integer(SRBMetaDataSet.getSRBID(string + "0_5")));
            vector.add(new Integer(SRBMetaDataSet.getSRBID(string + "1_5")));
        }
        byte[] byArray = new byte[vector.size() * 4];
        Host.copyInt((Integer)vector.get(0), byArray, 0);
        int n = 1;
        while (n < vector.size()) {
            Host.copyInt((Integer)vector.get(n), byArray, n * 4);
            ++n;
        }
        return byArray;
    }

    SRBMetaDataRecordList[] joinRecordLists(SRBMetaDataRecordList[] sRBMetaDataRecordListArray, SRBMetaDataRecordList[] sRBMetaDataRecordListArray2, String string, String string2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean[] blArray = null;
        int n4 = 0;
        SRBMetaDataRecordList[] sRBMetaDataRecordListArray3 = null;
        if (string != null && sRBMetaDataRecordListArray != null && sRBMetaDataRecordListArray2 != null) {
            blArray = new boolean[sRBMetaDataRecordListArray2.length];
            n = 0;
            while (n < sRBMetaDataRecordListArray.length) {
                int n5 = -1;
                int n6 = -1;
                n2 = 0;
                while (n2 < sRBMetaDataRecordListArray[n].getFieldCount()) {
                    if (sRBMetaDataRecordListArray[n].getField(n2).equals(MetaDataSet.getField(string))) {
                        n3 = 0;
                        while (n3 < sRBMetaDataRecordListArray2.length) {
                            int n7 = 0;
                            while (n7 < sRBMetaDataRecordListArray2[n3].getFieldCount()) {
                                if (sRBMetaDataRecordListArray[n].getValue(n2).equals(sRBMetaDataRecordListArray2[n3].getValue(n7)) && sRBMetaDataRecordListArray2[n3].getField(n7).equals(MetaDataSet.getField(string))) {
                                    n5 = n3;
                                    if (string2 != null) {
                                        int n8 = 0;
                                        while (n8 < sRBMetaDataRecordListArray[n].getFieldCount()) {
                                            if (sRBMetaDataRecordListArray[n].getField(n8).equals(MetaDataSet.getField(string2))) {
                                                int n9 = 0;
                                                while (n9 < sRBMetaDataRecordListArray2[n3].getFieldCount()) {
                                                    if (sRBMetaDataRecordListArray[n].getValue(n8).equals(sRBMetaDataRecordListArray2[n3].getValue(n9))) {
                                                        n6 = n3;
                                                    }
                                                    ++n9;
                                                }
                                            }
                                            ++n8;
                                        }
                                    }
                                }
                                ++n7;
                            }
                            ++n3;
                        }
                    }
                    ++n2;
                }
                if (n5 >= 0 && (string2 == null || string2 != null && n5 == n6)) {
                    sRBMetaDataRecordListArray[n].combineRecordLists(sRBMetaDataRecordListArray2[n5]);
                    blArray[n5] = true;
                    ++n4;
                }
                ++n;
            }
            if (n4 > sRBMetaDataRecordListArray2.length) {
                sRBMetaDataRecordListArray3 = sRBMetaDataRecordListArray;
            } else {
                sRBMetaDataRecordListArray3 = new SRBMetaDataRecordList[sRBMetaDataRecordListArray.length + sRBMetaDataRecordListArray2.length - n4];
                System.arraycopy(sRBMetaDataRecordListArray, 0, sRBMetaDataRecordListArray3, 0, sRBMetaDataRecordListArray.length);
                System.arraycopy(sRBMetaDataRecordListArray2, 0, sRBMetaDataRecordListArray3, sRBMetaDataRecordListArray.length, sRBMetaDataRecordListArray2.length - n4);
                if (blArray != null) {
                    n = 0;
                    n3 = 0;
                    while (n < sRBMetaDataRecordListArray2.length) {
                        if (!blArray[n]) {
                            sRBMetaDataRecordListArray3[sRBMetaDataRecordListArray.length + n3] = sRBMetaDataRecordListArray2[n];
                            ++n3;
                        }
                        ++n;
                    }
                }
            }
            return sRBMetaDataRecordListArray3;
        }
        if (string == null && sRBMetaDataRecordListArray != null && sRBMetaDataRecordListArray2 != null) {
            sRBMetaDataRecordListArray3 = new SRBMetaDataRecordList[sRBMetaDataRecordListArray.length + sRBMetaDataRecordListArray2.length - n4];
            System.arraycopy(sRBMetaDataRecordListArray, 0, sRBMetaDataRecordListArray3, 0, sRBMetaDataRecordListArray.length);
            System.arraycopy(sRBMetaDataRecordListArray2, 0, sRBMetaDataRecordListArray3, sRBMetaDataRecordListArray.length, sRBMetaDataRecordListArray2.length - n4);
            return sRBMetaDataRecordListArray3;
        }
        if (sRBMetaDataRecordListArray == null) {
            return sRBMetaDataRecordListArray2;
        }
        if (sRBMetaDataRecordListArray2 == null) {
            return sRBMetaDataRecordListArray;
        }
        return null;
    }

    private SRBMetaDataRecordList[] getRecordsForDefinableQueries(int n, MetaDataCondition[] metaDataConditionArray, MetaDataSelect[] metaDataSelectArray, int n2, SRBMetaDataRecordList[] sRBMetaDataRecordListArray, boolean bl, boolean bl2) throws IOException {
        SRBMetaDataRecordList[] sRBMetaDataRecordListArray2 = null;
        sRBMetaDataRecordListArray2 = this.srbGetDataDirInfo(n, metaDataConditionArray, metaDataSelectArray, n2, bl, bl2);
        if (sRBMetaDataRecordListArray2 != null) {
            int n3 = 0;
            while (n3 < sRBMetaDataRecordListArray2.length) {
                sRBMetaDataRecordListArray2[n3].setContinuationIndex(-1);
                ++n3;
            }
            if (sRBMetaDataRecordListArray != null && sRBMetaDataRecordListArray2 != null) {
                sRBMetaDataRecordListArray2 = this.joinRecordLists(sRBMetaDataRecordListArray, sRBMetaDataRecordListArray2, null, null);
            }
            return sRBMetaDataRecordListArray2;
        }
        return null;
    }

    static final Object[] cleanArray(Object[] objectArray) {
        Vector<Object> vector = new Vector<Object>(objectArray.length);
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] != null) {
                n2 = n + 1;
                while (n2 < objectArray.length) {
                    if (objectArray[n].equals(objectArray[n2])) {
                        bl = false;
                        n2 = objectArray.length;
                    }
                    ++n2;
                }
                if (bl) {
                    vector.add(objectArray[n]);
                }
                bl = true;
            }
            ++n;
        }
        n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] != null) {
                return vector.toArray((Object[])Array.newInstance(objectArray[n].getClass(), 0));
            }
            ++n;
        }
        return null;
    }

    private String addValueByStyle(int n, MetaDataCondition metaDataCondition, char[][] cArray) {
        String string = "";
        block0 : switch (n) {
            case 0: {
                switch (metaDataCondition.getFieldType()) {
                    case 3: 
                    case 4: {
                        string = string + "'" + metaDataCondition.getStringValue() + "'";
                        break block0;
                    }
                    case 0: {
                        string = string + metaDataCondition.getIntValue();
                        break block0;
                    }
                    case 2: {
                        string = string + metaDataCondition.getFloatValue();
                        break block0;
                    }
                }
                throw new RuntimeException("TODO temp SRBMetaDataCommands.getdatadir,type,scalar");
            }
            case 1: {
                switch (metaDataCondition.getFieldType()) {
                    case 3: 
                    case 4: {
                        string = string + "'" + metaDataCondition.getStringValue(0) + "' and " + "'" + metaDataCondition.getStringValue(1) + "'";
                        break block0;
                    }
                    case 0: {
                        string = string + metaDataCondition.getIntValue(0) + " and " + metaDataCondition.getIntValue(1);
                        break block0;
                    }
                    case 2: {
                        string = string + metaDataCondition.getFloatValue(0) + " and " + metaDataCondition.getFloatValue(1);
                        break block0;
                    }
                }
                throw new RuntimeException("TODO temp SRBMetaDataCommands.getdatadir,type,range");
            }
            case 2: {
                switch (metaDataCondition.getFieldType()) {
                    case 3: 
                    case 4: {
                        string = string + "(";
                        int n2 = 0;
                        while (n2 < metaDataCondition.getCount()) {
                            string = string + "'" + metaDataCondition.getStringValue(n2) + "',";
                            ++n2;
                        }
                        break;
                    }
                    case 0: {
                        string = string + "(";
                        int n3 = 0;
                        while (n3 < metaDataCondition.getCount()) {
                            string = string + metaDataCondition.getIntValue(n3) + ",";
                            ++n3;
                        }
                        break;
                    }
                    case 2: {
                        string = string + "(";
                        int n4 = 0;
                        while (n4 < metaDataCondition.getCount()) {
                            string = string + metaDataCondition.getFloatValue(n4) + ",";
                            ++n4;
                        }
                        break;
                    }
                    default: {
                        throw new RuntimeException("TODO temp SRBMetaDataCommands.getdatadir,type,enum");
                    }
                }
                string = string.substring(0, string.length() - 1) + ")";
                break;
            }
            case 14: {
                MetaDataTable metaDataTable = metaDataCondition.getTableValue();
                if (cArray == null) {
                    string = string + this.setTableGenQuery(metaDataTable, metaDataCondition.getFieldName());
                } else {
                    this.setTableQval(metaDataTable, cArray, metaDataCondition.getFieldName());
                }
                if (metaDataTable.getRowCount() <= 5) break;
                break;
            }
            default: {
                throw new RuntimeException("TODO temp SRBMetaDataCommands.getdatadir,style");
            }
        }
        return string;
    }

    synchronized SRBMetaDataRecordList[] srbGetDataDirInfo(int n, MetaDataCondition[] metaDataConditionArray, MetaDataSelect[] metaDataSelectArray, int n2, boolean bl, boolean bl2) throws IOException {
        String string = SRBAccount.getVersion();
        if (!string.equals("SRB1.1.8&C") && !string.equals("SRB2.0.0&D")) {
            return this.srbGenQuery(n, this.commands.getZone(), metaDataConditionArray, metaDataSelectArray, n2, bl, bl2);
        }
        int n3 = 0;
        int n4 = 0;
        boolean bl3 = false;
        int n5 = metaDataConditionArray.length;
        int n6 = metaDataSelectArray.length;
        Object[] objectArray = new MetaDataCondition[n5];
        Object[] objectArray2 = new MetaDataSelect[n6];
        System.arraycopy(metaDataConditionArray, 0, objectArray, 0, n5);
        System.arraycopy(metaDataSelectArray, 0, objectArray2, 0, n6);
        objectArray = (MetaDataCondition[])SRBMetaDataCommands.cleanArray(objectArray);
        if (objectArray == null) {
            return null;
        }
        n5 = objectArray.length;
        if ((objectArray2 = (MetaDataSelect[])SRBMetaDataCommands.cleanArray(objectArray2)) == null) {
            return null;
        }
        n6 = objectArray2.length;
        try {
            int n7;
            int n8;
            char[][] cArray = new char[SRBFileSystem.TOTAL_METADATA_ATTRIBUTES][SRBFileSystem.MAX_TOKEN];
            int[] nArray = new int[SRBFileSystem.TOTAL_METADATA_ATTRIBUTES];
            SRBMetaDataRecordList[] sRBMetaDataRecordListArray = null;
            SRBMetaDataRecordList[] sRBMetaDataRecordListArray2 = null;
            SRBMetaDataRecordList[] sRBMetaDataRecordListArray3 = null;
            n3 = 0;
            while (n3 < n5) {
                if (objectArray[n3] != null) {
                    n8 = ((MetaDataCondition)objectArray[n3]).getStyle();
                    String string2 = "";
                    n7 = SRBMetaDataSet.getSRBID(((MetaDataCondition)objectArray[n3]).getFieldName());
                    if (n8 != 14) {
                        string2 = SRBMetaDataCommands.getOperator((MetaDataCondition)objectArray[n3]) + " " + string2;
                    }
                    string2 = string2 + this.addValueByStyle(n8, (MetaDataCondition)objectArray[n3], cArray);
                    if (n8 != 14) {
                        System.arraycopy(string2.toCharArray(), 0, cArray[n7], 0, string2.length());
                    }
                }
                ++n3;
            }
            n8 = -1;
            String string3 = null;
            String string4 = null;
            n3 = 0;
            while (n3 < n6) {
                if (objectArray2[n3] != null) {
                    n7 = SRBMetaDataSet.getSRBID(((MetaDataSelect)objectArray2[n3]).getFieldName());
                    if (n7 == -1) {
                        objectArray2[n3] = MetaDataSet.newSelection("file name");
                        objectArray2 = MetaDataSet.mergeSelects(MetaDataSet.newSelection("directory name"), (MetaDataSelect[])objectArray2);
                        sRBMetaDataRecordListArray2 = this.getRecordsForDefinableQueries(n, (MetaDataCondition[])objectArray, (MetaDataSelect[])objectArray2, n2, sRBMetaDataRecordListArray, bl, bl2);
                        nArray = new int[SRBFileSystem.TOTAL_METADATA_ATTRIBUTES];
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata file0")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata file1")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata file2")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata file3")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata file4")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata file5")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata file6")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata file7")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata file8")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata file9")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"file name")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"directory name")] = 0x1000000;
                        string3 = "file name";
                        string4 = "directory name";
                        break;
                    }
                    if (n7 == -2) {
                        objectArray2[n3] = MetaDataSet.newSelection("directory name");
                        sRBMetaDataRecordListArray2 = this.getRecordsForDefinableQueries(n, (MetaDataCondition[])objectArray, (MetaDataSelect[])objectArray2, n2, sRBMetaDataRecordListArray, bl, bl2);
                        nArray = new int[SRBFileSystem.TOTAL_METADATA_ATTRIBUTES];
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata directory0")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata directory1")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata directory2")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata directory3")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata directory4")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata directory5")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata directory6")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata directory7")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata directory8")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata directory9")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"directory name")] = 0x1000000;
                        break;
                    }
                    if (n7 == -3) {
                        objectArray2[n3] = MetaDataSet.newSelection("user name");
                        objectArray2 = MetaDataSet.mergeSelects(MetaDataSet.newSelection("user domain"), (MetaDataSelect[])objectArray2);
                        sRBMetaDataRecordListArray2 = this.getRecordsForDefinableQueries(n, (MetaDataCondition[])objectArray, (MetaDataSelect[])objectArray2, n2, sRBMetaDataRecordListArray, bl, bl2);
                        nArray = new int[SRBFileSystem.TOTAL_METADATA_ATTRIBUTES];
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata user0")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata user1")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata user2")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata user3")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata user4")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata user5")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata user6")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata user7")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata user8")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata user9")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"user name")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"user domain")] = 0x1000000;
                        break;
                    }
                    if (n7 == -4) {
                        objectArray2[n3] = MetaDataSet.newSelection("resource name");
                        sRBMetaDataRecordListArray2 = this.getRecordsForDefinableQueries(n, (MetaDataCondition[])objectArray, (MetaDataSelect[])objectArray2, n2, sRBMetaDataRecordListArray, bl, bl2);
                        nArray = new int[SRBFileSystem.TOTAL_METADATA_ATTRIBUTES];
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata resource0")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata resource1")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata resource2")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata resource3")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata resource4")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata resource5")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata resource6")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata resource7")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata resource8")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata resource9")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"resource name")] = 0x1000000;
                        break;
                    }
                    nArray[n7] = 0x1000000;
                }
                ++n3;
            }
            this.commands.startSRBCommand(2101, 4);
            this.commands.sendArg(n);
            this.commands.sendArg(cArray);
            this.commands.sendArg(nArray);
            this.commands.sendArg(n2);
            this.commands.flush();
            this.commands.commandStatus();
            sRBMetaDataRecordListArray = this.commands.returnSRBMetaDataRecordList();
            if (sRBMetaDataRecordListArray2 != null) {
                if (sRBMetaDataRecordListArray != null) {
                    n4 = 0;
                    while (n4 < sRBMetaDataRecordListArray.length) {
                        if (n8 < sRBMetaDataRecordListArray[n4].getContinuationIndex()) {
                            n8 = sRBMetaDataRecordListArray[n4].getContinuationIndex();
                            sRBMetaDataRecordListArray = this.joinRecordLists(sRBMetaDataRecordListArray, this.commands.srbGetMoreRows(n, n8, n2), string3, string4);
                        }
                        ++n4;
                    }
                    n4 = 0;
                    while (n4 < sRBMetaDataRecordListArray.length) {
                        sRBMetaDataRecordListArray[n4].setContinuationIndex(-1);
                        ++n4;
                    }
                }
                sRBMetaDataRecordListArray3 = this.joinRecordLists(sRBMetaDataRecordListArray2, sRBMetaDataRecordListArray, string3, string4);
            } else {
                sRBMetaDataRecordListArray3 = sRBMetaDataRecordListArray;
            }
            return sRBMetaDataRecordListArray3;
        }
        catch (SRBException sRBException) {
            if (sRBException.getType() == -3005) {
                return null;
            }
            throw sRBException;
        }
    }

    SRBMetaDataRecordList[] srbGenQuery(int n, String string, MetaDataCondition[] metaDataConditionArray, MetaDataSelect[] metaDataSelectArray, int n2, boolean bl, boolean bl2) throws IOException {
        Object object;
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        SRBMetaDataRecordList[] sRBMetaDataRecordListArray = null;
        SRBMetaDataRecordList[] sRBMetaDataRecordListArray2 = null;
        SRBMetaDataRecordList[] sRBMetaDataRecordListArray3 = null;
        byte[] byArray = new byte[999];
        int n7 = metaDataConditionArray.length;
        int n8 = metaDataSelectArray.length;
        Object[] objectArray = new MetaDataCondition[n7];
        Object[] objectArray2 = new MetaDataSelect[n8];
        System.arraycopy(metaDataConditionArray, 0, objectArray, 0, n7);
        System.arraycopy(metaDataSelectArray, 0, objectArray2, 0, n8);
        objectArray = (MetaDataCondition[])SRBMetaDataCommands.cleanArray(objectArray);
        if (objectArray == null) {
            return null;
        }
        n7 = objectArray.length;
        if ((objectArray2 = (MetaDataSelect[])SRBMetaDataCommands.cleanArray(objectArray2)) == null) {
            return null;
        }
        n8 = objectArray2.length;
        int[] nArray = new int[n8];
        int[] nArray2 = new int[n8];
        n4 = 0;
        while (n4 < objectArray.length) {
            if (SRBCommands.DEBUG > 3) {
                System.out.println("conditions\t\t " + ((MetaDataCondition)objectArray[n4]).getFieldName() + " " + ((MetaDataCondition)objectArray[n4]).getStringValue());
            }
            if (((MetaDataCondition)objectArray[n4]).getStyle() == 14) {
                n3 = ((MetaDataCondition)objectArray[n4]).getTableValue().getRowCount();
                n7 = n3 >= 5 ? (((MetaDataCondition)objectArray[n4]).getFieldName().equals("definable metadata for files") || ((MetaDataCondition)objectArray[n4]).getFieldName().equals("definable metadata for directories") ? (n7 += 5 * ((MetaDataCondition)objectArray[n4]).getTableValue().getColumnCount() - 1) : (n7 += 4 * ((MetaDataCondition)objectArray[n4]).getTableValue().getColumnCount() - 1)) : (n7 += n3 * ((MetaDataCondition)objectArray[n4]).getTableValue().getColumnCount() - 1);
            }
            ++n4;
        }
        n3 = -1;
        String string2 = null;
        String string3 = null;
        n6 = n8;
        n4 = 0;
        while (n4 < n6) {
            int n9 = SRBMetaDataSet.getSRBID(((MetaDataSelect)objectArray2[n4]).getFieldName());
            if (n9 == -1) {
                objectArray2[n4] = MetaDataSet.newSelection("file name");
                objectArray2 = MetaDataSet.mergeSelects(MetaDataSet.newSelection("directory name"), (MetaDataSelect[])objectArray2);
                sRBMetaDataRecordListArray2 = this.getRecordsForDefinableQueries(n, (MetaDataCondition[])objectArray, (MetaDataSelect[])objectArray2, n2, sRBMetaDataRecordListArray, bl, bl2);
                n8 = 12;
                nArray = new int[n8];
                nArray2 = new int[n8];
                nArray[0] = SRBMetaDataSet.getSRBID("file name");
                nArray[1] = SRBMetaDataSet.getSRBID("directory name");
                nArray[2] = SRBMetaDataSet.getSRBID("definable metadata file0");
                nArray[3] = SRBMetaDataSet.getSRBID("definable metadata file1");
                nArray[4] = SRBMetaDataSet.getSRBID("definable metadata file2");
                nArray[5] = SRBMetaDataSet.getSRBID("definable metadata file3");
                nArray[6] = SRBMetaDataSet.getSRBID("definable metadata file4");
                nArray[7] = SRBMetaDataSet.getSRBID("definable metadata file5");
                nArray[8] = SRBMetaDataSet.getSRBID("definable metadata file6");
                nArray[9] = SRBMetaDataSet.getSRBID("definable metadata file7");
                nArray[10] = SRBMetaDataSet.getSRBID("definable metadata file8");
                nArray[11] = SRBMetaDataSet.getSRBID("definable metadata file9");
                nArray2[0] = 1;
                nArray2[1] = 1;
                nArray2[2] = 1;
                nArray2[3] = 1;
                nArray2[4] = 1;
                nArray2[5] = 1;
                nArray2[6] = 1;
                nArray2[7] = 1;
                nArray2[8] = 1;
                nArray2[9] = 1;
                nArray2[10] = 1;
                nArray2[11] = 1;
                string2 = "file name";
                string3 = "directory name";
                n4 = n6;
            } else if (n9 == -2) {
                objectArray2[n4] = MetaDataSet.newSelection("directory name");
                sRBMetaDataRecordListArray2 = this.getRecordsForDefinableQueries(n, (MetaDataCondition[])objectArray, (MetaDataSelect[])objectArray2, n2, sRBMetaDataRecordListArray, bl, bl2);
                n8 = 11;
                nArray = new int[n8];
                nArray2 = new int[n8];
                nArray[0] = SRBMetaDataSet.getSRBID("directory name");
                nArray[1] = SRBMetaDataSet.getSRBID("definable metadata directory0");
                nArray[2] = SRBMetaDataSet.getSRBID("definable metadata directory1");
                nArray[3] = SRBMetaDataSet.getSRBID("definable metadata directory2");
                nArray[4] = SRBMetaDataSet.getSRBID("definable metadata directory3");
                nArray[5] = SRBMetaDataSet.getSRBID("definable metadata directory4");
                nArray[6] = SRBMetaDataSet.getSRBID("definable metadata directory5");
                nArray[7] = SRBMetaDataSet.getSRBID("definable metadata directory6");
                nArray[8] = SRBMetaDataSet.getSRBID("definable metadata directory7");
                nArray[9] = SRBMetaDataSet.getSRBID("definable metadata directory8");
                nArray[10] = SRBMetaDataSet.getSRBID("definable metadata directory9");
                nArray2[0] = 1;
                nArray2[1] = 1;
                nArray2[2] = 1;
                nArray2[3] = 1;
                nArray2[4] = 1;
                nArray2[5] = 1;
                nArray2[6] = 1;
                nArray2[7] = 1;
                nArray2[8] = 1;
                nArray2[9] = 1;
                nArray2[10] = 1;
                n4 = n6;
            } else if (n9 == -3) {
                objectArray2[n4] = MetaDataSet.newSelection("user name");
                objectArray2 = MetaDataSet.mergeSelects(MetaDataSet.newSelection("user domain"), (MetaDataSelect[])objectArray2);
                sRBMetaDataRecordListArray2 = this.getRecordsForDefinableQueries(n, (MetaDataCondition[])objectArray, (MetaDataSelect[])objectArray2, n2, sRBMetaDataRecordListArray, bl, bl2);
                n8 = 12;
                nArray = new int[n8];
                nArray2 = new int[n8];
                nArray[0] = SRBMetaDataSet.getSRBID("user name");
                nArray[1] = SRBMetaDataSet.getSRBID("user domain");
                nArray[2] = SRBMetaDataSet.getSRBID("definable metadata user0");
                nArray[3] = SRBMetaDataSet.getSRBID("definable metadata user1");
                nArray[4] = SRBMetaDataSet.getSRBID("definable metadata user2");
                nArray[5] = SRBMetaDataSet.getSRBID("definable metadata user3");
                nArray[6] = SRBMetaDataSet.getSRBID("definable metadata user4");
                nArray[7] = SRBMetaDataSet.getSRBID("definable metadata user5");
                nArray[8] = SRBMetaDataSet.getSRBID("definable metadata user6");
                nArray[9] = SRBMetaDataSet.getSRBID("definable metadata user7");
                nArray[10] = SRBMetaDataSet.getSRBID("definable metadata user8");
                nArray[11] = SRBMetaDataSet.getSRBID("definable metadata user9");
                nArray2[0] = 1;
                nArray2[1] = 1;
                nArray2[2] = 1;
                nArray2[3] = 1;
                nArray2[4] = 1;
                nArray2[5] = 1;
                nArray2[6] = 1;
                nArray2[7] = 1;
                nArray2[8] = 1;
                nArray2[9] = 1;
                nArray2[10] = 1;
                nArray2[11] = 1;
                n4 = n6;
            } else if (n9 == -4) {
                objectArray2[n4] = MetaDataSet.newSelection("resource name");
                sRBMetaDataRecordListArray2 = this.getRecordsForDefinableQueries(n, (MetaDataCondition[])objectArray, (MetaDataSelect[])objectArray2, n2, sRBMetaDataRecordListArray, bl, bl2);
                n8 = 11;
                nArray = new int[n8];
                nArray2 = new int[n8];
                nArray[0] = SRBMetaDataSet.getSRBID("resource name");
                nArray[1] = SRBMetaDataSet.getSRBID("definable metadata resource0");
                nArray[2] = SRBMetaDataSet.getSRBID("definable metadata resource1");
                nArray[3] = SRBMetaDataSet.getSRBID("definable metadata resource2");
                nArray[4] = SRBMetaDataSet.getSRBID("definable metadata resource3");
                nArray[5] = SRBMetaDataSet.getSRBID("definable metadata resource4");
                nArray[6] = SRBMetaDataSet.getSRBID("definable metadata resource5");
                nArray[7] = SRBMetaDataSet.getSRBID("definable metadata resource6");
                nArray[8] = SRBMetaDataSet.getSRBID("definable metadata resource7");
                nArray[9] = SRBMetaDataSet.getSRBID("definable metadata resource8");
                nArray[10] = SRBMetaDataSet.getSRBID("definable metadata resource9");
                nArray2[0] = 1;
                nArray2[1] = 1;
                nArray2[2] = 1;
                nArray2[3] = 1;
                nArray2[4] = 1;
                nArray2[5] = 1;
                nArray2[6] = 1;
                nArray2[7] = 1;
                nArray2[8] = 1;
                nArray2[9] = 1;
                nArray2[10] = 1;
                n4 = n6;
            } else {
                nArray[n4] = n9;
                nArray2[n4] = ((MetaDataSelect)objectArray2[n4]).getOperation();
            }
            ++n4;
        }
        byte[] byArray2 = null;
        n6 = 0;
        if (bl2) {
            Host.copyInt(n8 + 1, byArray, n6);
            n6 += 4;
        } else {
            Host.copyInt(n8, byArray, n6);
            n6 += 4;
        }
        if (bl) {
            Host.copyInt(n7 + 1, byArray, n6);
            n6 += 4;
        } else {
            Host.copyInt(n7, byArray, n6);
            n6 += 4;
        }
        n4 = 0;
        while (n4 < n8) {
            Host.copyInt(nArray[n4], byArray, n6);
            n6 += 4;
            ++n4;
        }
        if (bl2) {
            Host.copyInt(SRBMetaDataSet.getSRBID("nondistinct"), byArray, n6);
            n6 += 4;
        }
        n4 = 0;
        while (n4 < n8) {
            Host.copyInt(nArray2[n4], byArray, n6);
            n6 += 4;
            ++n4;
        }
        if (bl2) {
            Host.copyInt(1, byArray, n6);
            n6 += 4;
        }
        n4 = 0;
        while (n4 < objectArray.length) {
            if (objectArray[n4] != null) {
                if (((MetaDataCondition)objectArray[n4]).getStyle() == 14) {
                    object = this.setTableConditionIDs(((MetaDataCondition)objectArray[n4]).getTableValue(), ((MetaDataCondition)objectArray[n4]).getFieldName());
                    System.arraycopy(object, 0, byArray, n6, ((Object)object).length);
                    n6 += ((Object)object).length;
                } else {
                    Host.copyInt(SRBMetaDataSet.getSRBID(((MetaDataCondition)objectArray[n4]).getFieldName()), byArray, n6);
                    n6 += 4;
                }
            }
            ++n4;
        }
        if (bl) {
            Host.copyInt(SRBMetaDataSet.getSRBID("order by"), byArray, n6);
            n6 += 4;
        }
        n4 = 0;
        while (n4 < objectArray.length) {
            if (objectArray[n4] != null) {
                int n10 = ((MetaDataCondition)objectArray[n4]).getStyle();
                object = n10 == 14 ? " " + this.addValueByStyle(n10, (MetaDataCondition)objectArray[n4], null) : " " + SRBMetaDataCommands.getOperator((MetaDataCondition)objectArray[n4]) + " " + this.addValueByStyle(n10, (MetaDataCondition)objectArray[n4], null);
                System.arraycopy(((String)object).getBytes(), 0, byArray, n6, ((String)object).length());
                n6 += ((String)object).length() + 1;
            }
            ++n4;
        }
        if (bl) {
            object = SRBMetaDataSet.getSRBName(((MetaDataSelect)objectArray2[0]).getFieldName());
            n5 = 1;
            while (n5 < objectArray2.length) {
                object = (String)object + ", " + SRBMetaDataSet.getSRBName(((MetaDataSelect)objectArray2[n5]).getFieldName());
                ++n5;
            }
            System.arraycopy(((String)object).getBytes(), 0, byArray, n6, ((String)object).length());
            n6 += ((String)object).length() + 1;
        }
        byArray2 = new byte[n6 + 4];
        System.arraycopy(byArray, 0, byArray2, 4, n6);
        Host.copyInt(n6, byArray2, 0);
        this.commands.startSRBCommand(2155, 4);
        this.commands.sendArg(n);
        this.commands.sendArg(string);
        this.commands.sendArg(byArray2);
        this.commands.sendArg(n2);
        this.commands.flush();
        try {
            this.commands.commandStatus();
        }
        catch (SRBException sRBException) {
            if (sRBException.getType() == -3005) {
                return null;
            }
            throw sRBException;
        }
        sRBMetaDataRecordListArray = this.commands.returnSRBMetaDataRecordList(true);
        if (sRBMetaDataRecordListArray2 != null) {
            if (sRBMetaDataRecordListArray != null) {
                n5 = 0;
                while (n5 < sRBMetaDataRecordListArray.length) {
                    if (n3 < sRBMetaDataRecordListArray[n5].getContinuationIndex()) {
                        n3 = sRBMetaDataRecordListArray[n5].getContinuationIndex();
                        sRBMetaDataRecordListArray = this.joinRecordLists(sRBMetaDataRecordListArray, this.commands.srbGetMoreRows(n, n3, n2), string2, string3);
                    }
                    ++n5;
                }
                n5 = 0;
                while (n5 < sRBMetaDataRecordListArray.length) {
                    sRBMetaDataRecordListArray[n5].setContinuationIndex(-1);
                    ++n5;
                }
            }
            sRBMetaDataRecordListArray3 = this.joinRecordLists(sRBMetaDataRecordListArray2, sRBMetaDataRecordListArray, string2, string3);
        } else {
            sRBMetaDataRecordListArray3 = sRBMetaDataRecordListArray;
        }
        return sRBMetaDataRecordListArray3;
    }
}

