/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.factory;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import uk.ac.starlink.datanode.factory.SimpleDataNodeBuilder;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.ErrorDataNode;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.datanode.nodes.XMLDocument;
import uk.ac.starlink.util.Compression;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.FileDataSource;

public abstract class DataNodeBuilder {
    private Constructor constructor;
    private Class argClass;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$FileDataNode;

    public abstract boolean suitable(Class var1);

    public abstract DataNode buildNode(Object var1) throws NoSuchDataException;

    public Class getNodeClass() {
        return DataNode.class;
    }

    public static DataNodeBuilder[] getBuilders(final Class clazz) {
        DataNodeBuilder sourceBuilder;
        if (!DataNode.class.isAssignableFrom(clazz)) {
            return new DataNodeBuilder[0];
        }
        HashMap<Class, DataNodeBuilder> builderMap = new HashMap<Class, DataNodeBuilder>();
        ArrayList<DataNodeBuilder> builders = new ArrayList<DataNodeBuilder>();
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            final Constructor<?> constructor = constructors[i];
            Class<?>[] argTypes = constructor.getParameterTypes();
            if (argTypes.length != 1) continue;
            Class<?> argClass = argTypes[0];
            SimpleDataNodeBuilder builder = new SimpleDataNodeBuilder(clazz, argClass){

                public DataNode buildNode(Object obj) throws NoSuchDataException {
                    Object[] args = new Object[]{obj};
                    try {
                        return (DataNode)constructor.newInstance(args);
                    }
                    catch (InvocationTargetException e) {
                        Throwable target = e.getTargetException();
                        if (target instanceof NoSuchDataException) {
                            throw (NoSuchDataException)target;
                        }
                        return new ErrorDataNode(target);
                    }
                    catch (InstantiationException e) {
                        return new ErrorDataNode(e);
                    }
                    catch (IllegalAccessException e) {
                        return new ErrorDataNode(e);
                    }
                }
            };
            builders.add(builder);
            builderMap.put(argClass, builder);
        }
        if (builderMap.containsKey(XMLDocument.class) && !builderMap.containsKey(DataSource.class)) {
            final DataNodeBuilder docBuilder = (DataNodeBuilder)builderMap.get(XMLDocument.class);
            SimpleDataNodeBuilder dataBuilder = new SimpleDataNodeBuilder(clazz, DataSource.class){

                public DataNode buildNode(Object obj) throws NoSuchDataException {
                    DataSource datsrc = (DataSource)obj;
                    try {
                        XMLDocument xdoc = new XMLDocument(datsrc);
                        return docBuilder.buildNode(xdoc);
                    }
                    catch (NoSuchDataException e) {
                        datsrc.close();
                        throw e;
                    }
                }
            };
            builders.add(dataBuilder);
            builderMap.put(DataSource.class, dataBuilder);
        }
        if ((builderMap.containsKey(File.class) || builderMap.containsKey(DataSource.class)) && !builderMap.containsKey(String.class)) {
            final DataNodeBuilder fileBuilder = (DataNodeBuilder)builderMap.get(File.class);
            sourceBuilder = (DataNodeBuilder)builderMap.get(DataSource.class);
            SimpleDataNodeBuilder stringBuilder = new SimpleDataNodeBuilder(clazz, String.class){

                public DataNode buildNode(Object obj) throws NoSuchDataException {
                    String name = (String)obj;
                    DataSource datsrc = null;
                    try {
                        datsrc = DataSource.makeDataSource(name);
                        if (datsrc instanceof FileDataSource && clazz.equals(class$uk$ac$starlink$datanode$nodes$FileDataNode == null ? (class$uk$ac$starlink$datanode$nodes$FileDataNode = DataNodeBuilder.class$("uk.ac.starlink.datanode.nodes.FileDataNode")) : class$uk$ac$starlink$datanode$nodes$FileDataNode)) {
                            File file = ((FileDataSource)datsrc).getFile();
                            return fileBuilder.buildNode(file);
                        }
                        if (datsrc instanceof FileDataSource && fileBuilder != null) {
                            File file = ((FileDataSource)datsrc).getFile();
                            Compression compress = datsrc.getCompression();
                            if (datsrc.getCompression() == Compression.NONE) {
                                datsrc.close();
                                return fileBuilder.buildNode(file);
                            }
                            if (sourceBuilder == null) {
                                datsrc.close();
                                throw new NoSuchDataException("File " + file + " is compressed (" + compress + ")");
                            }
                        }
                        if (sourceBuilder != null) {
                            try {
                                return sourceBuilder.buildNode(datsrc);
                            }
                            catch (NoSuchDataException e) {
                                datsrc.close();
                                throw e;
                            }
                        }
                        throw new NoSuchDataException("No stream builder");
                    }
                    catch (IOException e) {
                        if (datsrc != null) {
                            datsrc.close();
                        }
                        throw new NoSuchDataException(e);
                    }
                }
            };
            builders.add(stringBuilder);
            builderMap.put(String.class, stringBuilder);
        }
        if (builderMap.containsKey(DataSource.class) && !builderMap.containsKey(File.class)) {
            final DataNodeBuilder sourceBuilder2 = (DataNodeBuilder)builderMap.get(DataSource.class);
            SimpleDataNodeBuilder fileBuilder = new SimpleDataNodeBuilder(clazz, File.class){

                public DataNode buildNode(Object obj) throws NoSuchDataException {
                    File file = (File)obj;
                    FileDataSource datsrc = null;
                    try {
                        datsrc = new FileDataSource(file);
                        datsrc.setName(file.getName());
                        return sourceBuilder2.buildNode(datsrc);
                    }
                    catch (IOException e) {
                        if (datsrc != null) {
                            datsrc.close();
                        }
                        throw new NoSuchDataException(e);
                    }
                }
            };
            builders.add(fileBuilder);
            builderMap.put(File.class, fileBuilder);
        }
        if (builderMap.containsKey(File.class) && !builderMap.containsKey(DataSource.class)) {
            final DataNodeBuilder fileBuilder = (DataNodeBuilder)builderMap.get(File.class);
            sourceBuilder = new SimpleDataNodeBuilder(clazz, DataSource.class){

                public DataNode buildNode(Object obj) throws NoSuchDataException {
                    DataSource datsrc = (DataSource)obj;
                    if (datsrc instanceof FileDataSource) {
                        File file = ((FileDataSource)datsrc).getFile();
                        return fileBuilder.buildNode(file);
                    }
                    throw new NoSuchDataException("Only file-type DataSources supported");
                }
            };
            builders.add(sourceBuilder);
            builderMap.put(DataSource.class, sourceBuilder);
        }
        return builders.toArray(new DataNodeBuilder[0]);
    }
}

