/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.factory;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Node;
import uk.ac.starlink.datanode.factory.CreationState;
import uk.ac.starlink.datanode.factory.DataNodeBuilder;
import uk.ac.starlink.datanode.factory.DocumentDataNodeBuilder;
import uk.ac.starlink.datanode.factory.FileDataNodeBuilder;
import uk.ac.starlink.datanode.factory.SourceDataNodeBuilder;
import uk.ac.starlink.datanode.factory.StringDataNodeBuilder;
import uk.ac.starlink.datanode.factory.XMLDataNodeBuilder;
import uk.ac.starlink.datanode.nodes.ARYDataNode;
import uk.ac.starlink.datanode.nodes.BranchDataNode;
import uk.ac.starlink.datanode.nodes.CompressedDataNode;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.DocumentDataNode;
import uk.ac.starlink.datanode.nodes.ErrorDataNode;
import uk.ac.starlink.datanode.nodes.FITSFileDataNode;
import uk.ac.starlink.datanode.nodes.FITSStreamDataNode;
import uk.ac.starlink.datanode.nodes.FileDataNode;
import uk.ac.starlink.datanode.nodes.FtpDirectoryDataNode;
import uk.ac.starlink.datanode.nodes.FtpLocation;
import uk.ac.starlink.datanode.nodes.HDSDataNode;
import uk.ac.starlink.datanode.nodes.HDXDataNode;
import uk.ac.starlink.datanode.nodes.HistoryDataNode;
import uk.ac.starlink.datanode.nodes.JDBCDataNode;
import uk.ac.starlink.datanode.nodes.NDArrayDataNode;
import uk.ac.starlink.datanode.nodes.NDFDataNode;
import uk.ac.starlink.datanode.nodes.NdxDataNode;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.datanode.nodes.NodeUtil;
import uk.ac.starlink.datanode.nodes.PlainDataNode;
import uk.ac.starlink.datanode.nodes.StarTableDataNode;
import uk.ac.starlink.datanode.nodes.TarStreamDataNode;
import uk.ac.starlink.datanode.nodes.VOComponentDataNode;
import uk.ac.starlink.datanode.nodes.VOTableDataNode;
import uk.ac.starlink.datanode.nodes.VOTableTableDataNode;
import uk.ac.starlink.datanode.nodes.WCSDataNode;
import uk.ac.starlink.datanode.nodes.XMLDataNode;
import uk.ac.starlink.datanode.nodes.ZipFileDataNode;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.FileDataSource;

public class DataNodeFactory {
    boolean debug;
    private List builders;
    private Set shunnedClasses;
    private Set deprecatedClasses;
    private static List defaultClassList;
    private static Logger logger;
    private static Pattern pathPattern;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DataNodeFactory() {
        this.builders = new ArrayList();
        this.shunnedClasses = new HashSet();
        this.deprecatedClasses = new HashSet();
        this.builders.addAll(DataNodeFactory.getSpecialBuilders());
        Iterator it = DataNodeFactory.getDefaultClassList().iterator();
        while (it.hasNext()) {
            Class clazz = (Class)it.next();
            DataNodeBuilder[] bbatch = DataNodeBuilder.getBuilders(clazz);
            if (bbatch.length == 0) {
                logger.warning("No builders from class " + clazz.getName());
            }
            this.builders.addAll(Arrays.asList(bbatch));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataNodeFactory(DataNodeFactory orig) {
        List list = orig.builders;
        synchronized (list) {
            this.builders = new ArrayList(orig.builders);
        }
        this.shunnedClasses = new HashSet(orig.shunnedClasses);
        this.deprecatedClasses = new HashSet(orig.deprecatedClasses);
        this.debug = orig.debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNodeClass(Class clazz) {
        List list = this.builders;
        synchronized (list) {
            Iterator it = this.builders.iterator();
            while (it.hasNext()) {
                DataNodeBuilder builder = (DataNodeBuilder)it.next();
                if (!builder.getNodeClass().equals(clazz)) continue;
                it.remove();
            }
        }
        this.shunnedClasses.add(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreferredClass(Class clazz) {
        DataNodeBuilder[] cBuilders = DataNodeBuilder.getBuilders(clazz);
        List<DataNodeBuilder> cbList = Arrays.asList(cBuilders);
        HashSet prefBuilderClasses = new HashSet();
        Iterator<DataNodeBuilder> it = cbList.iterator();
        while (it.hasNext()) {
            prefBuilderClasses.add(it.next().getClass());
        }
        List list = this.builders;
        synchronized (list) {
            Iterator it2 = this.builders.iterator();
            while (it2.hasNext()) {
                DataNodeBuilder builder = (DataNodeBuilder)it2.next();
                if (!builder.getNodeClass().equals(clazz) || !prefBuilderClasses.contains(builder.getClass())) continue;
                it2.remove();
            }
            this.builders.addAll(0, cbList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeprecatedClass(Class clazz) {
        List list = this.builders;
        synchronized (list) {
            Iterator it = this.builders.iterator();
            while (it.hasNext()) {
                DataNodeBuilder builder = (DataNodeBuilder)it.next();
                if (!builder.getNodeClass().equals(clazz)) continue;
                it.remove();
            }
            DataNodeBuilder[] depBuilders = DataNodeBuilder.getBuilders(clazz);
            if (depBuilders != null) {
                this.builders.addAll(Arrays.asList(depBuilders));
            }
        }
        this.deprecatedClasses.add(clazz);
    }

    public List getBuilders() {
        return this.builders;
    }

    public DataNode makeDataNode(DataNode parent, Object obj) throws NoSuchDataException {
        Class<?> objClass = obj.getClass();
        ArrayList<DataNodeBuilder> tried = new ArrayList<DataNodeBuilder>();
        DataNode newNode = null;
        DataNodeBuilder successfulBuilder = null;
        StringBuffer trace = null;
        if (this.debug) {
            trace = new StringBuffer().append("Object: ").append(obj).append('\n').append("Class: ").append(objClass.getName()).append('\n');
        }
        Iterator it = new ArrayList(this.builders).iterator();
        while (it.hasNext() && newNode == null) {
            DataNodeBuilder builder = (DataNodeBuilder)it.next();
            if (!builder.suitable(objClass)) continue;
            if (this.debug) {
                trace.append("\nBuilder: ").append(builder).append('\n');
            }
            tried.add(builder);
            try {
                DataNode node = builder.buildNode(obj);
                Class<?> clazz = node.getClass();
                if (this.shunnedClasses.contains(clazz)) {
                    if (!this.debug) continue;
                    trace.append("   Class ").append(clazz.getName()).append(" shunned.\n");
                    continue;
                }
                if (this.deprecatedClasses.contains(clazz) && builder.getNodeClass() != clazz) {
                    if (!this.debug) continue;
                    trace.append("    Class ").append(clazz.getName()).append(" deprecated.");
                    continue;
                }
                newNode = node;
                if (this.debug) {
                    trace.append("   SUCCESS (").append(newNode.getClass().getName()).append(")\n");
                }
                successfulBuilder = builder;
            }
            catch (NoSuchDataException e) {
                if (!this.debug) continue;
                for (Throwable th = e; th != null; th = th.getCause()) {
                    if (th != e) {
                        trace.append("   Caused by:\n");
                    }
                    String msg = th.getMessage().replaceAll("\n", "\n   ");
                    trace.append("   ").append(msg).append('\n');
                    StackTraceElement[] frames = th.getStackTrace();
                    for (int i = 0; i < frames.length; ++i) {
                        trace.append("      ").append(frames[i]).append("\n");
                    }
                }
            }
        }
        if (newNode == null) {
            StringBuffer msg = new StringBuffer().append("No DataNode could be constructed from ").append(obj).append(" of class ").append(objClass.getName()).append("\n").append("Tried:\n");
            Iterator it2 = tried.iterator();
            while (it2.hasNext()) {
                msg.append("    ").append(it2.next()).append("\n");
            }
            throw new NoSuchDataException(msg.toString());
        }
        if (!$assertionsDisabled && newNode == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && successfulBuilder == null) {
            throw new AssertionError();
        }
        this.configureDataNode(newNode, parent, obj);
        CreationState creator = newNode.getCreator();
        creator.setFactory(this);
        creator.setBuilder(successfulBuilder);
        if (this.debug) {
            creator.setFactoryTrace(trace.toString());
        }
        return newNode;
    }

    public void configureDataNode(DataNode node, DataNode parentNode, Object obj) {
        Matcher match;
        String name;
        String loc;
        URL url;
        File file;
        node.setChildMaker(parentNode == null ? new DataNodeFactory() : parentNode.getChildMaker());
        node.setCreator(new CreationState(parentNode, obj));
        Object parentObj = null;
        String label = null;
        if (obj instanceof FileDataSource) {
            file = ((FileDataSource)obj).getFile();
            label = file.getName();
            parentObj = file.getAbsoluteFile().getParent();
        } else if (obj instanceof File) {
            file = (File)obj;
            label = file.getName();
            parentObj = file.getAbsoluteFile().getParent();
        } else if (obj instanceof DOMSource) {
            DOMSource dsrc = (DOMSource)obj;
            String sysid = dsrc.getSystemId();
            Node pnode = dsrc.getNode().getParentNode();
            if (pnode != null) {
                parentObj = new DOMSource(pnode, sysid);
            } else if (sysid != null && sysid.trim().length() > 0) {
                parentObj = sysid;
            }
        }
        if (parentObj == null && node.getParentObject() == null && obj instanceof DataSource && (url = ((DataSource)obj).getURL()) != null && (loc = url.toExternalForm()).startsWith("ftp://")) {
            String dir = loc.substring(0, loc.lastIndexOf(47));
            try {
                parentObj = new FtpLocation(dir);
            }
            catch (NoSuchDataException e) {
                // empty catch block
            }
        }
        if (label == null && obj instanceof DataSource && (name = ((DataSource)obj).getName()) != null && (match = pathPattern.matcher(name)).lookingAt()) {
            label = match.group(1);
        }
        if (parentObj != null && node.getParentObject() == null) {
            node.setParentObject(parentObj);
        }
        if (label != null && node.getLabel() == null) {
            node.setLabel(label);
        }
    }

    public DataNode makeErrorDataNode(DataNode parent, Throwable th) {
        try {
            return this.makeDataNode(parent, th);
        }
        catch (NoSuchDataException e) {
            return new ErrorDataNode(th);
        }
    }

    public DataNode makeChildNode(DataNode parent, Object obj) {
        try {
            return this.makeDataNode(parent, obj);
        }
        catch (NoSuchDataException e) {
            return this.makeErrorDataNode(parent, e);
        }
    }

    public void fillInAncestors(DataNode node) {
        while (node != null) {
            Object parentObject = node.getParentObject();
            if (parentObject != null) {
                try {
                    DataNode parentNode = this.makeDataNode(null, parentObject);
                    CreationState creator = new CreationState(parentNode, parentObject);
                    creator.setFactory(this);
                    node.setCreator(creator);
                    node = parentNode;
                }
                catch (NoSuchDataException e) {
                    node = null;
                }
                continue;
            }
            node = null;
        }
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("DataNodeFactory with builders:\n");
        Iterator bit = this.builders.iterator();
        while (bit.hasNext()) {
            buf.append("    ").append(bit.next().toString()).append('\n');
        }
        return buf.toString();
    }

    public static List getSpecialBuilders() {
        ArrayList<DataNodeBuilder> specials = new ArrayList<DataNodeBuilder>(5);
        specials.add(FileDataNodeBuilder.getInstance());
        specials.add(StringDataNodeBuilder.getInstance());
        specials.add(SourceDataNodeBuilder.getInstance());
        specials.add(DocumentDataNodeBuilder.getInstance());
        specials.add(XMLDataNodeBuilder.getInstance());
        return specials;
    }

    public static List getDefaultClassList() {
        if (defaultClassList == null) {
            ArrayList<String> classNameList = new ArrayList<String>(Arrays.asList(NDFDataNode.class.getName(), WCSDataNode.class.getName(), ARYDataNode.class.getName(), HistoryDataNode.class.getName(), HDSDataNode.class.getName(), FITSFileDataNode.class.getName(), NdxDataNode.class.getName(), VOTableDataNode.class.getName(), ZipFileDataNode.class.getName(), TarStreamDataNode.class.getName(), NDArrayDataNode.class.getName(), FITSStreamDataNode.class.getName(), JDBCDataNode.class.getName(), StarTableDataNode.class.getName(), HDXDataNode.class.getName(), DocumentDataNode.class.getName(), XMLDataNode.class.getName(), VOTableTableDataNode.class.getName(), VOComponentDataNode.class.getName(), FtpDirectoryDataNode.class.getName(), CompressedDataNode.class.getName(), FileDataNode.class.getName(), BranchDataNode.class.getName(), PlainDataNode.class.getName()));
            if (!NodeUtil.hasHDS()) {
                classNameList.remove(NDFDataNode.class.getName());
                classNameList.remove(ARYDataNode.class.getName());
                classNameList.remove(HistoryDataNode.class.getName());
                classNameList.remove(HDSDataNode.class.getName());
            }
            if (!NodeUtil.hasAST()) {
                classNameList.remove(WCSDataNode.class.getName());
            }
            ArrayList cList = new ArrayList();
            Iterator it = classNameList.iterator();
            while (it.hasNext()) {
                String cname = (String)it.next();
                try {
                    Class clazz = class$uk$ac$starlink$datanode$factory$DataNodeFactory == null ? DataNodeFactory.class$("uk.ac.starlink.datanode.factory.DataNodeFactory") : class$uk$ac$starlink$datanode$factory$DataNodeFactory;
                    cList.add(Class.forName(cname));
                }
                catch (Throwable th) {
                    String msg = th.toString().indexOf(cname) >= 0 ? th.toString() : "Can't load class " + cname + " (" + th + ")";
                    logger.info(msg);
                }
            }
            defaultClassList = cList;
        }
        return defaultClassList;
    }

    static {
        $assertionsDisabled = !DataNodeFactory.class.desiredAssertionStatus();
        logger = Logger.getLogger("uk.ac.starlink.datanode.factory");
        pathPattern = Pattern.compile("([^ /\\\\:]+)$");
    }
}

