/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.factory;

import uk.ac.starlink.datanode.factory.DataNodeBuilder;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.DocumentDataNode;
import uk.ac.starlink.datanode.nodes.HDXDataNode;
import uk.ac.starlink.datanode.nodes.NdxDataNode;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.datanode.nodes.VOTableDataNode;
import uk.ac.starlink.datanode.nodes.XMLDocument;

public class DocumentDataNodeBuilder
extends DataNodeBuilder {
    private static DocumentDataNodeBuilder instance = new DocumentDataNodeBuilder();

    public static DocumentDataNodeBuilder getInstance() {
        return instance;
    }

    private DocumentDataNodeBuilder() {
    }

    public boolean suitable(Class objClass) {
        return XMLDocument.class.isAssignableFrom(objClass);
    }

    public DataNode buildNode(Object obj) throws NoSuchDataException {
        XMLDocument xdoc = (XMLDocument)obj;
        String elName = xdoc.getTopLocalName();
        String elname = elName.toLowerCase();
        String elURI = xdoc.getTopNamespaceURI();
        if (elname.equals("hdx")) {
            return new HDXDataNode(xdoc);
        }
        if (elname.equals("ndx")) {
            return new NdxDataNode(xdoc);
        }
        if (elName.equals("VOTABLE")) {
            return new VOTableDataNode(xdoc);
        }
        return new DocumentDataNode(xdoc);
    }

    public String toString() {
        return "XMLDataNodeBuilder(javax.xml.transform.XMLDocument)";
    }
}

