/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.factory;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import uk.ac.starlink.datanode.factory.DataNodeBuilder;
import uk.ac.starlink.datanode.factory.FileDataNodeBuilder;
import uk.ac.starlink.datanode.factory.SourceDataNodeBuilder;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.FtpDirectoryDataNode;
import uk.ac.starlink.datanode.nodes.JDBCDataNode;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.util.URLDataSource;

public class StringDataNodeBuilder
extends DataNodeBuilder {
    private static StringDataNodeBuilder instance = new StringDataNodeBuilder();
    private DataNodeBuilder fileBuilder = FileDataNodeBuilder.getInstance();
    private DataNodeBuilder sourceBuilder = SourceDataNodeBuilder.getInstance();

    public static StringDataNodeBuilder getInstance() {
        return instance;
    }

    private StringDataNodeBuilder() {
    }

    public boolean suitable(Class objClass) {
        return String.class.isAssignableFrom(objClass);
    }

    public DataNode buildNode(Object obj) throws NoSuchDataException {
        String string = (String)obj;
        File file = new File(string);
        if (file.exists()) {
            return this.fileBuilder.buildNode(file);
        }
        if (string.startsWith("jdbc:")) {
            try {
                return new JDBCDataNode(string);
            }
            catch (NoSuchDataException e) {
                // empty catch block
            }
        }
        if (string.startsWith("ftp://")) {
            try {
                return new FtpDirectoryDataNode(string);
            }
            catch (NoSuchDataException e) {
                // empty catch block
            }
        }
        try {
            URL url = new URL(string);
            URLDataSource datsrc = new URLDataSource(url);
            try {
                return this.sourceBuilder.buildNode(datsrc);
            }
            catch (NoSuchDataException e) {
                datsrc.close();
            }
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        throw new NoSuchDataException("Not obvious what kind of node");
    }

    public String toString() {
        return "StringDataNodeBuilder(java.lang.String)";
    }
}

