/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.factory;

import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;
import uk.ac.starlink.datanode.factory.DataNodeBuilder;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.HDXDataNode;
import uk.ac.starlink.datanode.nodes.NdxDataNode;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.datanode.nodes.VOComponentDataNode;
import uk.ac.starlink.datanode.nodes.XMLDataNode;
import uk.ac.starlink.util.SourceReader;

public class XMLDataNodeBuilder
extends DataNodeBuilder {
    private static XMLDataNodeBuilder instance = new XMLDataNodeBuilder();

    public static XMLDataNodeBuilder getInstance() {
        return instance;
    }

    private XMLDataNodeBuilder() {
    }

    public boolean suitable(Class objClass) {
        return Source.class.isAssignableFrom(objClass);
    }

    public DataNode buildNode(Object obj) throws NoSuchDataException {
        Element el;
        Source xsrc = (Source)obj;
        try {
            el = new SourceReader().getElement(xsrc);
        }
        catch (TransformerException e) {
            throw new NoSuchDataException(e);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchDataException(e);
        }
        String tagName = el.getTagName();
        String localName = el.getLocalName();
        String elName = localName == null ? tagName : localName;
        String elname = elName.toLowerCase();
        if (elname.equals("hdx")) {
            return new HDXDataNode(xsrc);
        }
        if (elname.equals("ndx")) {
            return new NdxDataNode(xsrc);
        }
        if (elName.equals("VOTABLE")) {
            return new VOComponentDataNode(xsrc);
        }
        return new XMLDataNode(xsrc);
    }

    public String toString() {
        return "XMLDataNodeBuilder(javax.xml.transform.Source)";
    }
}

