/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import javax.swing.Icon;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.datanode.factory.DataNodeFactory;
import uk.ac.starlink.datanode.nodes.DataObjectException;
import uk.ac.starlink.datanode.nodes.DataType;
import uk.ac.starlink.datanode.nodes.DetailViewer;
import uk.ac.starlink.datanode.nodes.HDSDataNode;
import uk.ac.starlink.datanode.nodes.IconFactory;
import uk.ac.starlink.datanode.nodes.NDArrayDataNode;
import uk.ac.starlink.datanode.nodes.NDFDataNode;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.datanode.nodes.WCSDataNode;
import uk.ac.starlink.hds.ArrayStructure;
import uk.ac.starlink.hds.HDSArrayBuilder;
import uk.ac.starlink.hds.HDSException;
import uk.ac.starlink.hds.HDSObject;
import uk.ac.starlink.hds.HDSType;
import uk.ac.starlink.ndx.DefaultMutableNdx;
import uk.ac.starlink.ndx.Ndx;

public class ARYDataNode
extends HDSDataNode {
    private ArrayStructure aryobj;
    private NDShape shape;
    private DataNodeFactory customChildMaker;
    private Ndx ndx;

    public ARYDataNode(HDSObject hobj) throws NoSuchDataException {
        super(hobj);
        try {
            if (HDSType.fromName((String)hobj.datType()) == null) {
                throw new NoSuchDataException("Not a numeric type");
            }
            this.aryobj = new ArrayStructure(hobj);
        }
        catch (HDSException e) {
            throw new NoSuchDataException("Not an ARY structure", e);
        }
        this.shape = this.aryobj.getShape();
    }

    public ARYDataNode(ArrayStructure aryobj) throws NoSuchDataException {
        super(aryobj.getHDSObject());
        this.aryobj = aryobj;
        this.shape = aryobj.getShape();
    }

    public ARYDataNode(String path) throws NoSuchDataException {
        this(ARYDataNode.getHDSFromPath(path));
    }

    public String getDescription() {
        return NDShape.toString((NDShape)this.shape) + "  <" + this.aryobj.getType() + ">";
    }

    public String getNodeTLA() {
        return "ARY";
    }

    public String getNodeType() {
        return "HDS array structure";
    }

    public Icon getIcon() {
        return IconFactory.getIcon(IconFactory.getArrayIconID(this.shape.getNumDims()));
    }

    public synchronized DataNodeFactory getChildMaker() {
        if (this.customChildMaker == null) {
            this.customChildMaker = new DataNodeFactory(super.getChildMaker());
            this.customChildMaker.removeNodeClass(ARYDataNode.class);
            this.customChildMaker.removeNodeClass(WCSDataNode.class);
            this.customChildMaker.removeNodeClass(NDFDataNode.class);
        }
        return this.customChildMaker;
    }

    public synchronized void setChildMaker(DataNodeFactory childMaker) {
        super.setChildMaker(childMaker);
        this.customChildMaker = null;
    }

    public void configureDetail(DetailViewer dv) {
        dv.addKeyedItem("Dimensionality", this.shape.getNumDims());
        dv.addKeyedItem("Origin", NDShape.toString((long[])this.shape.getOrigin()));
        dv.addKeyedItem("Dimensions", NDShape.toString((long[])this.shape.getDims()));
        dv.addKeyedItem("Pixel bounds", NDArrayDataNode.boundsString(this.shape));
        dv.addSeparator();
        dv.addKeyedItem("Type", this.aryobj.getType());
        dv.addSeparator();
        dv.addKeyedItem("Storage variant", this.aryobj.getStorage());
    }

    public boolean hasDataObject(DataType dtype) {
        if (dtype == DataType.NDX) {
            return true;
        }
        return super.hasDataObject(dtype);
    }

    public Object getDataObject(DataType dtype) throws DataObjectException {
        if (dtype == DataType.NDX) {
            try {
                return this.getNdx();
            }
            catch (HDSException e) {
                throw new DataObjectException("Error reading array", e);
            }
        }
        return super.getDataObject(dtype);
    }

    private Ndx getNdx() throws HDSException {
        if (this.ndx == null) {
            NDArray nda = HDSArrayBuilder.getInstance().makeNDArray(this.aryobj, AccessMode.READ);
            this.ndx = new DefaultMutableNdx(nda);
        }
        return this.ndx;
    }
}

