/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import nom.tam.fits.AsciiTableHDU;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.ImageHDU;
import nom.tam.fits.TruncatedFileException;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.BufferedDataInputStream;
import nom.tam.util.BufferedFile;
import nom.tam.util.RandomAccess;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.DataType;
import uk.ac.starlink.datanode.nodes.DefaultDataNode;
import uk.ac.starlink.datanode.nodes.HDUDataNode;
import uk.ac.starlink.datanode.nodes.ImageHDUDataNode;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.datanode.nodes.TableHDUDataNode;
import uk.ac.starlink.fits.AbstractArrayDataIO;
import uk.ac.starlink.fits.FitsConstants;
import uk.ac.starlink.fits.MappedFile;
import uk.ac.starlink.util.Compression;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.FileDataSource;

public abstract class FITSDataNode
extends DefaultDataNode {
    private String name;
    private String description;
    private DataSource datsrc;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FITSDataNode(DataSource datsrc) throws NoSuchDataException {
        this.datsrc = datsrc;
        ArrayDataInput istrm = null;
        try {
            block13: {
                try {
                    long dataSize;
                    void var6_7;
                    void var4_6;
                    long fileSize;
                    long headerSize;
                    if (!FITSDataNode.isMagic(datsrc.getIntro())) {
                        throw new NoSuchDataException("Wrong magic number for FITS");
                    }
                    istrm = this.getDataInput();
                    Header primaryHeader = new Header(istrm);
                    if (!(istrm instanceof BufferedFile) && !(istrm instanceof MappedFile)) break block13;
                    if (istrm instanceof BufferedFile) {
                        headerSize = ((BufferedFile)istrm).getFilePointer();
                        fileSize = ((BufferedFile)istrm).length();
                    } else {
                        if (!(istrm instanceof AbstractArrayDataIO)) throw new AssertionError();
                        if (!(istrm instanceof RandomAccess)) throw new AssertionError();
                        headerSize = ((RandomAccess)istrm).getFilePointer();
                        fileSize = ((AbstractArrayDataIO)istrm).length();
                    }
                    if (var4_6 != -1L && var6_7 == var4_6 + (dataSize = FitsConstants.getDataSize((Header)primaryHeader))) {
                        long[] dims = ImageHDUDataNode.getDimsFromHeader(primaryHeader);
                        this.description = dims.length == 0 ? "(header only)" : NDShape.toString((long[])dims);
                    }
                }
                catch (FitsException e) {
                    throw new NoSuchDataException(e);
                }
                catch (IOException e) {
                    throw new NoSuchDataException(e);
                }
            }
            Object var12_10 = null;
            {
            }
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            try {
                datsrc.close();
                if (istrm == null) throw throwable;
                istrm.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        datsrc.close();
        if (istrm != null) {
            istrm.close();
        }
        this.name = datsrc.getName();
        this.setLabel(this.name);
        this.setIconID((short)111);
        this.registerDataObject(DataType.DATA_SOURCE, datsrc);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean allowsChildren() {
        return true;
    }

    protected abstract ArrayDataMaker getArrayData(long var1, long var3);

    public Iterator getChildIterator() {
        int firstHeaderSize;
        Header firstHeader;
        ArrayDataInput istrm;
        final FITSDataNode parent = this;
        try {
            istrm = this.getDataInput();
            firstHeader = new Header();
            firstHeaderSize = FitsConstants.readHeader((Header)firstHeader, (ArrayDataInput)istrm);
        }
        catch (TruncatedFileException e) {
            return Collections.singleton(this.makeErrorChild(e)).iterator();
        }
        catch (IOException e) {
            return Collections.singleton(this.makeErrorChild(e)).iterator();
        }
        return new Iterator(){
            private int nchild = 0;
            private boolean broken = false;
            private Header nextHeader = firstHeader;
            private int nextHeaderSize = firstHeaderSize;
            private long hduStart = 0L;

            public Object next() {
                if (this.hasNext()) {
                    DataNode dnode;
                    try {
                        Header hdr = this.nextHeader;
                        int headsize = this.nextHeaderSize;
                        long datsize = FITSDataNode.getDataSize(hdr);
                        long hdusize = (long)headsize + datsize;
                        long nskip = datsize;
                        while (nskip > 0L) {
                            int skipped = (int)istrm.skip(nskip);
                            nskip -= (long)skipped;
                            if (skipped != 0) continue;
                            istrm.readByte();
                            --nskip;
                        }
                        ArrayDataMaker hdudata = FITSDataNode.this.getArrayData(this.hduStart, hdusize);
                        this.hduStart += hdusize;
                        try {
                            dnode = hdr.containsKey("XTENSION") && AsciiTableHDU.isHeader((Header)hdr) ? new TableHDUDataNode(hdr, hdudata) : (BinaryTableHDU.isHeader((Header)hdr) ? new TableHDUDataNode(hdr, hdudata) : (ImageHDU.isHeader((Header)hdr) ? new ImageHDUDataNode(hdr, hdudata) : null));
                        }
                        catch (NoSuchDataException e) {
                            dnode = null;
                        }
                        if (dnode == null) {
                            dnode = new HDUDataNode(hdr, hdudata);
                        }
                        dnode.setLabel(this.nchild == 0 ? "Primary HDU" : "HDU " + this.nchild);
                        if (dnode instanceof HDUDataNode) {
                            ((HDUDataNode)dnode).setHDUIndex(this.nchild);
                        }
                    }
                    catch (NoSuchDataException e) {
                        dnode = FITSDataNode.this.makeErrorChild(e);
                    }
                    catch (IOException e) {
                        dnode = FITSDataNode.this.makeErrorChild(e);
                    }
                    FITSDataNode.this.getChildMaker().configureDataNode(dnode, parent, null);
                    ++this.nchild;
                    try {
                        this.nextHeader = new Header();
                        this.nextHeaderSize = FitsConstants.readHeader((Header)this.nextHeader, (ArrayDataInput)istrm);
                    }
                    catch (IOException e) {
                        this.nextHeader = null;
                    }
                    catch (TruncatedFileException e) {
                        this.nextHeader = null;
                    }
                    if (this.nextHeader == null) {
                        try {
                            istrm.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return dnode;
                }
                throw new NoSuchElementException();
            }

            public boolean hasNext() {
                return this.nextHeader != null;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String getPathSeparator() {
        return "#";
    }

    public String getNodeTLA() {
        return "FIT";
    }

    public String getNodeType() {
        return "FITS data";
    }

    protected ArrayDataInput getDataInput() throws IOException {
        if (this.datsrc instanceof FileDataSource && this.datsrc.getCompression() == Compression.NONE) {
            String fileName = ((FileDataSource)this.datsrc).getFile().getPath();
            return new MappedFile(fileName);
        }
        return new BufferedDataInputStream(this.datsrc.getInputStream());
    }

    private static long getDataSize(Header hdr) {
        long nel = FITSDataNode.getRawSize(hdr);
        if (nel % 2880L == 0L) {
            return nel;
        }
        return (nel / 2880L + 1L) * 2880L;
    }

    private static long getRawSize(Header hdr) {
        int naxis = hdr.getIntValue("NAXIS", 0);
        if (naxis <= 0) {
            return 0L;
        }
        int bitpix = hdr.getIntValue("BITPIX");
        int gcount = hdr.getIntValue("GCOUNT", 1);
        long pcount = hdr.getLongValue("PCOUNT", 0L);
        long nel = 1L;
        for (int i = 1; i <= naxis; ++i) {
            nel *= hdr.getLongValue("NAXIS" + i);
        }
        int bytepix = Math.abs(bitpix) / 8;
        return (long)(bytepix * gcount) * (pcount + nel);
    }

    public static boolean isMagic(byte[] buffer) {
        return FitsConstants.isMagic((byte[])buffer);
    }

    public static interface ArrayDataMaker {
        public ArrayDataInput getArrayData() throws IOException;

        public DataSource getDataSource();

        public long getOffset();
    }
}

