/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import nom.tam.util.ArrayDataInput;
import uk.ac.starlink.datanode.nodes.FITSDataNode;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.fits.MappedFile;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.FileDataSource;

public class FITSFileDataNode
extends FITSDataNode {
    private File file;
    private String name;
    private FileDataSource fdatsrc;

    public FITSFileDataNode(FileDataSource fdatsrc) throws NoSuchDataException {
        super(fdatsrc);
        this.fdatsrc = fdatsrc;
        this.file = fdatsrc.getFile();
        this.name = this.file.getName();
        this.setLabel(this.name);
    }

    public FITSFileDataNode(File file) throws NoSuchDataException {
        this(FITSFileDataNode.makeFileDataSource(file));
    }

    public String getName() {
        return this.name;
    }

    protected FITSDataNode.ArrayDataMaker getArrayData(final long start, final long size) {
        return new FITSDataNode.ArrayDataMaker(){

            public ArrayDataInput getArrayData() throws IOException {
                RandomAccessFile raf = new RandomAccessFile(FITSFileDataNode.this.file.getPath(), "r");
                FileChannel chan = raf.getChannel();
                MappedByteBuffer niobuf = chan.map(FileChannel.MapMode.READ_ONLY, start, size);
                chan.close();
                return new MappedFile((ByteBuffer)niobuf);
            }

            public DataSource getDataSource() {
                return FITSFileDataNode.this.fdatsrc;
            }

            public long getOffset() {
                return start;
            }

            public String toString() {
                return FITSFileDataNode.this.file + ":" + start + "+" + size;
            }
        };
    }

    public static FileDataSource makeFileDataSource(File file) throws NoSuchDataException {
        try {
            FileDataSource fdatsrc = new FileDataSource(file);
            fdatsrc.setName(file.getName());
            return fdatsrc;
        }
        catch (IOException e) {
            throw new NoSuchDataException(e);
        }
    }
}

