/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.DefaultDataNode;
import uk.ac.starlink.datanode.nodes.FtpLocation;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.util.DataSource;

public class FtpDirectoryDataNode
extends DefaultDataNode {
    private final FtpLocation floc;
    private String name;

    public FtpDirectoryDataNode(FtpLocation floc) {
        this.floc = floc;
        String url = floc.getURL().toExternalForm();
        if (url.charAt(url.length() - 1) == '/') {
            url = url.substring(0, url.length() - 1);
        }
        this.setName(url.substring(url.lastIndexOf(47) + 1));
    }

    public FtpDirectoryDataNode(String location) throws NoSuchDataException {
        this(new FtpLocation(location));
    }

    public String getNodeTLA() {
        return "FTP";
    }

    public String getNodeType() {
        return "FTP directory";
    }

    public String getPathSeparator() {
        return "/";
    }

    public boolean allowsChildren() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getChildIterator() {
        FTPFile[] files;
        try {
            FTPClient client;
            FTPClient fTPClient = client = this.floc.getClient();
            synchronized (fTPClient) {
                this.setDir(client);
                files = client.listFiles();
            }
            if (files == null) {
                files = new FTPFile[]{};
            }
        }
        catch (IOException e) {
            return Collections.singleton(this.makeErrorChild(e)).iterator();
        }
        List<FTPFile> fileList = Arrays.asList(files);
        Collections.sort(fileList, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((FTPFile)o1).getName().compareTo(((FTPFile)o2).getName());
            }
        });
        final Iterator<FTPFile> it = fileList.iterator();
        return new Iterator(){

            public boolean hasNext() {
                return it.hasNext();
            }

            public Object next() {
                DataNode node;
                FTPFile file = (FTPFile)it.next();
                String fname = file.getName();
                if (file.isDirectory()) {
                    try {
                        node = FtpDirectoryDataNode.this.makeChild(new FtpLocation(FtpDirectoryDataNode.this.floc, fname));
                    }
                    catch (NoSuchDataException e) {
                        node = FtpDirectoryDataNode.this.makeErrorChild(e);
                    }
                } else {
                    try {
                        node = FtpDirectoryDataNode.this.makeChild(new FTPFileDataSource(file));
                    }
                    catch (Exception e) {
                        node = FtpDirectoryDataNode.this.makeErrorChild(e);
                    }
                }
                node.setLabel(fname);
                return node;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Object getParentObject() {
        return this.floc.getParent();
    }

    private void setDir(FTPClient client) throws IOException {
        if (!client.changeWorkingDirectory(this.floc.getPath())) {
            throw new IOException(client.getReplyString());
        }
    }

    private class FTPFileDataSource
    extends DataSource {
        private FTPFile file;
        private URL url;
        private FTPClient readingClient;
        private byte[] content;
        public static final int INTRO_LENGTH = 4096;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FTPFileDataSource(FTPFile file) throws IOException {
            super(4096);
            this.file = file;
            long size = file.getSize();
            String name = file.getName();
            this.setName(name);
            try {
                this.url = new URL(FtpDirectoryDataNode.this.floc.getURL().toExternalForm() + '/' + name);
            }
            catch (MalformedURLException e) {
                this.url = null;
            }
            if (size < 4096L) {
                FTPClient client = FtpDirectoryDataNode.this.floc.getClient();
                ByteArrayOutputStream ostrm = new ByteArrayOutputStream((int)size);
                FTPClient fTPClient = client;
                synchronized (fTPClient) {
                    FtpDirectoryDataNode.this.setDir(client);
                    if (!client.retrieveFile(name, ostrm)) {
                        throw new IOException(client.getReplyString());
                    }
                }
                this.content = ostrm.toByteArray();
            }
        }

        public URL getURL() {
            return this.url;
        }

        public long getRawLength() {
            return this.file.getSize();
        }

        protected InputStream getRawInputStream() throws IOException {
            if (this.content != null) {
                return new ByteArrayInputStream(this.content);
            }
            if (this.url == null) {
                throw new IOException("Bad URL");
            }
            return this.url.openStream();
        }
    }
}

