/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.net.ProtocolCommandEvent;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.net.ftp.FTPReply;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;

public class FtpLocation {
    private final URL baseURL;
    private final String path;
    private final String user;
    private final String password;
    private transient FtpLocation parentLoc;
    private transient Boolean hasParentLoc;
    private static Map clientPool = new HashMap();

    public FtpLocation(String loc) throws NoSuchDataException {
        URL url;
        if (!loc.startsWith("ftp://")) {
            throw new NoSuchDataException("Not an ftp-type URL");
        }
        try {
            url = new URL(loc);
        }
        catch (MalformedURLException e) {
            throw new NoSuchDataException("Bad URL: " + loc, e);
        }
        String base = url.getProtocol() + "://";
        if (url.getUserInfo() != null) {
            base = base + url.getUserInfo() + "@";
        }
        base = base + url.getHost();
        if (url.getPort() >= 0) {
            base = base + ":" + url.getPort();
        }
        try {
            this.baseURL = new URL(base);
        }
        catch (MalformedURLException e) {
            throw new AssertionError();
        }
        if (url.getUserInfo() == null) {
            String hostname;
            this.user = "anonymous";
            try {
                hostname = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                hostname = "unknown.host";
            }
            this.password = System.getProperty("user.name") + '@' + hostname;
        } else {
            String info = url.getUserInfo();
            int colonpos = info.indexOf(58);
            if (colonpos > 0) {
                this.user = info.substring(0, colonpos);
                this.password = info.substring(colonpos + 1);
            } else {
                this.user = info;
                this.password = "";
            }
        }
        this.path = url.getPath();
        this.checkPath(this.path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FtpLocation(FtpLocation floc, String path) throws NoSuchDataException {
        this.baseURL = floc.baseURL;
        this.user = floc.user;
        this.password = floc.password;
        if (path.indexOf(47) == 0) {
            this.path = path;
            this.checkPath(path);
        } else {
            try {
                FTPClient client = this.getClient();
                boolean ok = true;
                FTPClient fTPClient = client;
                synchronized (fTPClient) {
                    ok = ok && client.changeWorkingDirectory(path);
                    this.path = client.printWorkingDirectory();
                }
                this.checkOK(this.path != null && ok, client);
            }
            catch (IOException e) {
                throw new NoSuchDataException(e);
            }
        }
    }

    public String getPath() {
        return this.path;
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public URL getURL() {
        try {
            return new URL(this.baseURL + this.path);
        }
        catch (MalformedURLException e) {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized FtpLocation getParent() {
        if (this.hasParentLoc == null) {
            try {
                FTPClient client;
                String parentPath = null;
                FTPClient fTPClient = client = this.getClient();
                synchronized (fTPClient) {
                    if (client.changeWorkingDirectory(this.path) && client.changeToParentDirectory()) {
                        parentPath = client.printWorkingDirectory();
                    }
                }
                if (parentPath != null && !parentPath.equals(this.path)) {
                    try {
                        this.parentLoc = new FtpLocation(this, parentPath);
                    }
                    catch (NoSuchDataException e) {
                        this.parentLoc = null;
                    }
                }
                this.hasParentLoc = this.parentLoc != null;
            }
            catch (IOException e) {
                this.hasParentLoc = Boolean.FALSE;
            }
        }
        return this.parentLoc;
    }

    public synchronized FTPClient getClient() throws IOException {
        FTPClient client;
        if (!clientPool.containsKey(this.baseURL)) {
            client = this.getNewClient();
            clientPool.put(this.baseURL, client);
        } else {
            client = (FTPClient)clientPool.get(this.baseURL);
            try {
                client.sendNoOp();
            }
            catch (FTPConnectionClosedException e) {
                client.disconnect();
                client = this.getNewClient();
                clientPool.put(this.baseURL, client);
            }
        }
        try {
            client.sendNoOp();
        }
        catch (FTPConnectionClosedException e) {
            client.disconnect();
            clientPool.remove(this.baseURL);
            throw e;
        }
        return client;
    }

    private FTPClient getNewClient() throws IOException {
        FTPClient client = new FTPClient();
        String host = this.baseURL.getHost();
        int port = this.baseURL.getPort();
        if (port >= 0) {
            client.setDefaultPort(port);
        }
        try {
            client.connect(host);
            if (!FTPReply.isPositiveCompletion(client.getReplyCode())) {
                client.disconnect();
                throw new IOException("FTP connection to " + host + " failed: " + client.getReplyString());
            }
            this.checkOK(client.login(this.user, this.password), client);
        }
        catch (IOException e) {
            throw (IOException)new IOException("FTP connection to " + host + " failed").initCause(e);
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPath(String path) throws NoSuchDataException {
        try {
            FTPClient client;
            FTPClient fTPClient = client = this.getClient();
            synchronized (fTPClient) {
                this.checkOK(client.changeWorkingDirectory(path), client);
            }
        }
        catch (IOException e) {
            throw new NoSuchDataException("Error setting directory " + path, e);
        }
    }

    private void checkOK(boolean ok, FTPClient client) throws IOException {
        if (!ok) {
            throw new IOException(client.getReplyString());
        }
    }

    private static class ProtocolLogger
    implements ProtocolCommandListener {
        static int nlogger = 0;
        String id = ++nlogger + " ";

        private ProtocolLogger() {
        }

        public void protocolCommandSent(ProtocolCommandEvent evt) {
            System.out.print(this.id + "--> " + evt.getMessage());
        }

        public void protocolReplyReceived(ProtocolCommandEvent evt) {
            System.out.print(this.id + "<-- " + evt.getMessage());
        }
    }
}

