/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.io.File;
import java.net.URL;
import java.nio.Buffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JComponent;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.array.Order;
import uk.ac.starlink.array.OrderedNDShape;
import uk.ac.starlink.datanode.nodes.ComponentMaker;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.DataObjectException;
import uk.ac.starlink.datanode.nodes.DataType;
import uk.ac.starlink.datanode.nodes.DefaultDataNode;
import uk.ac.starlink.datanode.nodes.DetailViewer;
import uk.ac.starlink.datanode.nodes.IconFactory;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.datanode.nodes.NodeUtil;
import uk.ac.starlink.datanode.viewers.ArrayBrowser;
import uk.ac.starlink.hds.ArrayStructure;
import uk.ac.starlink.hds.HDSArrayBuilder;
import uk.ac.starlink.hds.HDSException;
import uk.ac.starlink.hds.HDSObject;
import uk.ac.starlink.hds.HDSReference;
import uk.ac.starlink.hds.HDSType;
import uk.ac.starlink.ndx.DefaultMutableNdx;
import uk.ac.starlink.ndx.Ndx;

public class HDSDataNode
extends DefaultDataNode {
    private HDSObject hobj;
    private HDSObject hparent;
    private OrderedNDShape shape;
    private String type;
    private boolean isStruct;
    private String name;
    private Buffer niobuf;
    private String path;
    private Ndx ndx;
    public static final int MAX_CHILDREN_PER_ARRAY = 1000;

    public HDSDataNode(HDSObject hobj) throws NoSuchDataException {
        try {
            this.hobj = hobj;
            this.type = hobj.datType();
            this.name = hobj.datName();
            this.isStruct = hobj.datStruc();
            this.path = hobj.datRef();
            try {
                this.hparent = hobj.datParen();
            }
            catch (HDSException e) {
                this.hparent = null;
            }
            long[] dims = hobj.datShape();
            int ndim = dims.length;
            if (ndim > 0) {
                long[] origin = new long[ndim];
                Arrays.fill(origin, 1L);
                this.shape = new OrderedNDShape(origin, dims, Order.COLUMN_MAJOR);
            } else {
                this.shape = null;
            }
            this.setIconID(hobj.datStruc() ? (short)104 : IconFactory.getArrayIconID(this.shape != null ? this.shape.getNumDims() : 0));
        }
        catch (HDSException e) {
            throw new NoSuchDataException(e.getMessage());
        }
        this.setLabel(this.name);
    }

    public HDSDataNode(File file) throws NoSuchDataException {
        this(HDSDataNode.getHDSFromFile(file));
        this.setLabel(file.getName());
    }

    public HDSDataNode(String path) throws NoSuchDataException {
        this(HDSDataNode.getHDSFromPath(path));
    }

    protected static HDSObject getHDSFromPath(String path) throws NoSuchDataException {
        HDSReference ref;
        if (!NodeUtil.hasHDS()) {
            throw new NoSuchDataException("HDS subsystem not installed");
        }
        if (path.endsWith(".sdf")) {
            path = path.substring(0, path.length() - 4);
        }
        try {
            ref = new HDSReference(path);
        }
        catch (Exception e) {
            throw new NoSuchDataException(e.getMessage());
        }
        try {
            return ref.getObject("READ");
        }
        catch (HDSException e) {
            throw new NoSuchDataException(e.getMessage());
        }
    }

    protected static HDSObject getHDSFromFile(File file) throws NoSuchDataException {
        HDSReference ref;
        if (!NodeUtil.hasHDS()) {
            throw new NoSuchDataException("HDS subsystem not installed");
        }
        try {
            ref = new HDSReference(file);
        }
        catch (Exception e) {
            throw new NoSuchDataException(e.getMessage());
        }
        try {
            return ref.getObject("READ");
        }
        catch (HDSException e) {
            throw new NoSuchDataException(e.getMessage());
        }
    }

    public boolean allowsChildren() {
        try {
            boolean isStruct = this.hobj.datStruc();
        }
        catch (HDSException e) {
            throw new RuntimeException("Unexpected HDS error");
        }
        return this.isStruct && this.shape == null || this.isStruct && this.shape.getNumPixels() < 1000L;
    }

    public Iterator getChildIterator() {
        if (this.isStruct && this.shape == null) {
            try {
                ArrayList<DataNode> childList = new ArrayList<DataNode>();
                int nChildren = this.hobj.datNcomp();
                for (int i = 0; i < nChildren; ++i) {
                    try {
                        childList.add(this.makeChild(this.hobj.datIndex(i + 1)));
                        continue;
                    }
                    catch (HDSException e) {
                        childList.add(this.makeErrorChild(e));
                    }
                }
                return childList.iterator();
            }
            catch (HDSException e) {
                return Collections.singleton(this.makeErrorChild(e)).iterator();
            }
        }
        if (this.isStruct && this.shape.getNumPixels() < 1000L) {
            final Iterator it = this.shape.pixelIterator();
            return new Iterator(){

                public boolean hasNext() {
                    return it.hasNext();
                }

                public Object next() {
                    DataNode child;
                    long[] pos = (long[])it.next();
                    try {
                        child = HDSDataNode.this.makeChild(HDSDataNode.this.hobj.datCell(pos));
                    }
                    catch (HDSException e) {
                        child = HDSDataNode.this.makeErrorChild(e);
                    }
                    child.setLabel(child.getName() + NDShape.toString((long[])pos));
                    return child;
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        throw new AssertionError();
    }

    public Object getParentObject() {
        return this.hparent;
    }

    public String getDescription() {
        StringBuffer descrip = new StringBuffer();
        if (this.shape != null) {
            descrip.append(NDShape.toString((long[])this.shape.getDims()));
        }
        descrip.append("  <").append(this.type).append(">");
        if (!this.isStruct && this.shape == null) {
            try {
                if (this.type.startsWith("_CHAR")) {
                    descrip.append('\"').append(this.hobj.datGet0c()).append('\"');
                } else {
                    descrip.append("  ").append(this.hobj.datGet0c());
                }
            }
            catch (HDSException e) {
                descrip.append("  ???");
            }
        }
        return descrip.toString();
    }

    public String getPathElement() {
        return this.name;
    }

    public String getPathSeparator() {
        return ".";
    }

    public String getName() {
        return this.name;
    }

    public String getNodeTLA() {
        return "HDS";
    }

    public String getNodeType() {
        return "HDS data structure";
    }

    public void configureDetail(DetailViewer dv) {
        if (this.isStruct) {
            dv.addKeyedItem("Structure type", this.type);
        } else {
            dv.addKeyedItem("Data type", this.type);
        }
        if (this.shape != null) {
            long[] dims = this.shape.getDims();
            dv.addKeyedItem("Dimensions", dims.length);
            StringBuffer sdims = new StringBuffer();
            for (int i = 0; i < dims.length; ++i) {
                if (i > 0) {
                    sdims.append(" x ");
                }
                sdims.append(dims[i]);
            }
            dv.addKeyedItem("Shape", sdims);
        }
        if (this.shape == null && !this.isStruct) {
            String value;
            dv.addSeparator();
            try {
                value = this.hobj.datGet0c();
            }
            catch (HDSException e) {
                value = e.getMessage();
            }
            dv.addKeyedItem("Value", value);
        }
        if (this.shape != null && !this.isStruct) {
            try {
                if (HDSType.fromName((String)this.type) == null) {
                    dv.addScalingPane("Array data", new ComponentMaker(){

                        public JComponent getComponent() throws Exception {
                            ArrayStructure ary = new ArrayStructure(HDSDataNode.this.hobj);
                            return new ArrayBrowser(ary);
                        }
                    });
                }
            }
            catch (Exception e) {
                dv.logError(e);
            }
        }
    }

    public boolean hasDataObject(DataType dtype) {
        if (dtype == DataType.NDX) {
            return this.shape != null && !this.isStruct && HDSType.fromName((String)this.type) != null;
        }
        return super.hasDataObject(dtype);
    }

    public Object getDataObject(DataType dtype) throws DataObjectException {
        if (dtype == DataType.NDX && this.hasDataObject(DataType.NDX)) {
            try {
                return this.getNdx();
            }
            catch (HDSException e) {
                throw new DataObjectException(e);
            }
        }
        return super.getDataObject(dtype);
    }

    private Ndx getNdx() throws HDSException {
        if (this.ndx == null) {
            try {
                URL hurl = new HDSReference(this.hobj).getURL();
            }
            catch (HDSException e) {
                Object hurl = null;
            }
            NDArray nda = HDSArrayBuilder.getInstance().makeNDArray(new ArrayStructure(this.hobj), AccessMode.READ);
            this.ndx = new DefaultMutableNdx(nda);
        }
        return this.ndx;
    }

    public static boolean isMagic(byte[] magic) {
        return magic.length > 4 && (char)magic[0] == 'S' && (char)magic[1] == 'D' && (char)magic[2] == 'S' && magic[3] > 0 && magic[3] <= 4;
    }
}

