/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import uk.ac.starlink.datanode.nodes.ComponentMaker;
import uk.ac.starlink.datanode.nodes.DefaultDataNode;
import uk.ac.starlink.datanode.nodes.DetailViewer;
import uk.ac.starlink.datanode.nodes.ExceptionComponentMaker;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;

public class HTMLDataNode
extends DefaultDataNode {
    public final File file;
    private final URL url;

    public HTMLDataNode(File file) throws NoSuchDataException {
        try {
            this.file = file;
            this.url = file.toURL();
            this.setName("<" + this.url + ">");
            this.setIconID((short)120);
        }
        catch (Exception e) {
            throw new NoSuchDataException("Cannot convert " + file + " to URL");
        }
    }

    public boolean allowsChildren() {
        return false;
    }

    public String getNodeTLA() {
        return "HTM";
    }

    public String getNodeType() {
        return "HTML document";
    }

    public void configureDetail(DetailViewer dv) {
        try {
            dv.addPane("HTML file", new ComponentMaker(){

                public JComponent getComponent() throws IOException {
                    JEditorPane jep = new JEditorPane(HTMLDataNode.this.url);
                    jep.setEditable(false);
                    jep.addHyperlinkListener(new HyperlinkListener(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void hyperlinkUpdate(HyperlinkEvent evt) {
                            if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                                JEditorPane pane = (JEditorPane)evt.getSource();
                                try {
                                    pane.setPage(evt.getURL());
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                    });
                    return jep;
                }
            });
        }
        catch (Exception e) {
            dv.addPane("HTML file error", new ExceptionComponentMaker(e));
        }
    }
}

