/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public class IconFactory {
    public static final String IMAGE_PATH = "/uk/ac/starlink/datanode/images/";
    public static final short NO_ICON = -32767;
    public static final short STOP = 1;
    public static final short EXIT = 2;
    public static final short HELP = 3;
    public static final short DEMO = 4;
    public static final short LOAD = 5;
    public static final short SPLIT_NONE = 11;
    public static final short SPLIT_BELOW = 12;
    public static final short SPLIT_BESIDE = 13;
    public static final short CASCADE = 21;
    public static final short EXCISE = 22;
    public static final short OPEN = 23;
    public static final short CLOSE = 24;
    public static final short RELOAD = 30;
    public static final short DELETE = 31;
    public static final short UP = 32;
    public static final short DOWN = 33;
    public static final short HOME = 34;
    public static final short ARY0 = 91;
    public static final short ARY1 = 92;
    public static final short ARY2 = 93;
    public static final short ARY3 = 94;
    public static final short WHAT = 99;
    public static final short LEAF = 101;
    public static final short PARENT = 102;
    public static final short SCALAR = 103;
    public static final short STRUCTURE = 104;
    public static final short FILE = 105;
    public static final short DIRECTORY = 106;
    public static final short NDF = 107;
    public static final short ZIPFILE = 108;
    public static final short ZIPBRANCH = 109;
    public static final short WCS = 110;
    public static final short FITS = 111;
    public static final short HDU = 112;
    public static final short FRAME = 113;
    public static final short SKYFRAME = 114;
    public static final short HISTORY = 115;
    public static final short HISTORY_RECORD = 116;
    public static final short TABLE = 117;
    public static final short TREE = 118;
    public static final short ERROR = 119;
    public static final short XML_DOCUMENT = 120;
    public static final short XML_ELEMENT = 121;
    public static final short XML_COMMENT = 122;
    public static final short XML_PI = 123;
    public static final short XML_CDATA = 124;
    public static final short XML_EREF = 125;
    public static final short XML_STRING = 126;
    public static final short XML_DTD = 127;
    public static final short NDX = 130;
    public static final short HDX_CONTAINER = 131;
    public static final short TARFILE = 132;
    public static final short TARBRANCH = 133;
    public static final short COMPRESSED = 134;
    public static final short DATA = 135;
    public static final short VOTABLE = 140;
    public static final short VOCOMPONENT = 141;
    public static final short SPECFRAME = 142;
    public static final short MYSPACE = 143;
    public static final short SPLAT = 200;
    public static final short SOG = 201;
    public static final short TOPCAT = 202;
    public static final short HANDLE_EXPAND = 301;
    public static final short HANDLE_COLLAPSE = 302;
    public static final short TREE_LOGO = 401;
    public static final short STARLINK_LOGO = 402;
    public static final short HANDLE1 = 403;
    public static final short HANDLE2 = 404;
    public static final short STAR_LOGO = 405;
    private static boolean festive = IconFactory.isFestive();
    private static Map iconMap = new HashMap();

    private IconFactory() {
    }

    public static Icon getIcon(short id) {
        return IconFactory.getIconByName(IconFactory.getIconName(id));
    }

    public static URL getIconURL(short id) {
        return IconFactory.class.getResource(IMAGE_PATH + IconFactory.getIconName(id));
    }

    /*
     * WARNING - void declaration
     */
    private static String getIconName(short id) {
        void var1_1;
        switch (id) {
            case 12: {
                String iname = "SplitHorizontal.gif";
                break;
            }
            case 13: {
                String iname = "SplitVertical.gif";
                break;
            }
            case 11: {
                String iname = "Frame.gif";
                break;
            }
            case 21: {
                String iname = "PlusPlus.gif";
                break;
            }
            case 22: {
                String iname = "MinusMinus.gif";
                break;
            }
            case 23: {
                String iname = "Plus.gif";
                break;
            }
            case 24: {
                String iname = "Minus.gif";
                break;
            }
            case 30: {
                String iname = "redoy2.gif";
                break;
            }
            case 31: {
                String iname = "trasha2.gif";
                break;
            }
            case 32: {
                String iname = "Up.gif";
                break;
            }
            case 33: {
                String iname = "Down.gif";
                break;
            }
            case 34: {
                String iname = "Home24.gif";
                break;
            }
            case 1: {
                String iname = "Stop.gif";
                break;
            }
            case 2: {
                String iname = "multiply3.gif";
                break;
            }
            case 3: {
                String iname = "Help2.gif";
                break;
            }
            case 4: {
                String iname = "multi8.gif";
                break;
            }
            case 5: {
                String iname = "open3.gif";
                break;
            }
            case 91: {
                String iname = "cell.gif";
                break;
            }
            case 92: {
                String iname = "row.gif";
                break;
            }
            case 93: {
                String iname = "Sheet.gif";
                break;
            }
            case 94: {
                String iname = "Sheets.gif";
                break;
            }
            case 99: {
                String iname = "burst.gif";
                break;
            }
            case 101: {
                String iname = "Tree.leafIcon";
                break;
            }
            case 102: {
                String iname = "Tree.closedIcon";
                break;
            }
            case 103: {
                String iname = "ball.black.gif";
                break;
            }
            case 104: {
                String iname = "closed.gif";
                break;
            }
            case 105: {
                String iname = "file1.gif";
                break;
            }
            case 106: {
                String iname = "dir4.gif";
                break;
            }
            case 107: {
                String iname = "star_gold.gif";
                break;
            }
            case 108: {
                String iname = "archgreen.gif";
                break;
            }
            case 109: {
                String iname = "branchgreen.gif";
                break;
            }
            case 110: {
                String iname = "world1.gif";
                break;
            }
            case 111: {
                String iname = "gstar2.gif";
                break;
            }
            case 112: {
                String iname = "TileCascade.gif";
                break;
            }
            case 113: {
                String iname = "axes42.gif";
                break;
            }
            case 114: {
                String iname = "axes62.gif";
                break;
            }
            case 115: {
                String iname = "book2.gif";
                break;
            }
            case 116: {
                String iname = "mini-doc.gif";
                break;
            }
            case 117: {
                String iname = "table10.gif";
                break;
            }
            case 118: {
                String iname = !festive ? "TREE28.gif" : "sxtree6.gif";
                break;
            }
            case 119: {
                String iname = "madsmiley.gif";
                break;
            }
            case 120: {
                String iname = "xml_doc.gif";
                break;
            }
            case 121: {
                String iname = "xml_el.gif";
                break;
            }
            case 122: {
                String iname = "xml_comm.gif";
                break;
            }
            case 123: {
                String iname = "xml_pi.gif";
                break;
            }
            case 124: {
                String iname = "xml_txt.gif";
                break;
            }
            case 125: {
                String iname = "xml_eref.gif";
                break;
            }
            case 126: {
                String iname = "xml_txt.gif";
                break;
            }
            case 127: {
                String iname = "xml_dtd.gif";
                break;
            }
            case 130: {
                String iname = "fuzz3.gif";
                break;
            }
            case 131: {
                String iname = "box7.gif";
                break;
            }
            case 132: {
                String iname = "archyellow.gif";
                break;
            }
            case 133: {
                String iname = "branchyellow.gif";
                break;
            }
            case 134: {
                String iname = "squishdat.gif";
                break;
            }
            case 135: {
                String iname = "plaindat.gif";
                break;
            }
            case 140: {
                String iname = "telescope2.gif";
                break;
            }
            case 141: {
                String iname = "smallbox1.gif";
                break;
            }
            case 142: {
                String iname = "axes81.gif";
                break;
            }
            case 143: {
                String iname = "AGlogo.gif";
                break;
            }
            case 200: {
                String iname = "multidisplay.gif";
                break;
            }
            case 201: {
                String iname = "sogimage.gif";
                break;
            }
            case 202: {
                String iname = "TopCat2.gif";
                break;
            }
            case 301: {
                String iname = "Tree.expandedIcon";
                break;
            }
            case 302: {
                String iname = "Tree.collapsedIcon";
                break;
            }
            case 401: {
                String iname = !festive ? "TREE27.gif" : "xtree5.gif";
                break;
            }
            case 402: {
                String iname = "starlinklogo3.gif";
                break;
            }
            case 403: {
                String iname = "handle1.gif";
                break;
            }
            case 404: {
                String iname = "handle2.gif";
                break;
            }
            case 405: {
                String iname = "starlinklogo1b.gif";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown icon identifier (programming error)");
            }
        }
        return var1_1;
    }

    public static short getArrayIconID(int ndim) {
        short id;
        switch (ndim) {
            case 0: {
                id = 91;
                break;
            }
            case 1: {
                id = 92;
                break;
            }
            case 2: {
                id = 93;
                break;
            }
            default: {
                id = 94;
            }
        }
        return id;
    }

    private static Icon getIconByName(String name) {
        if (!iconMap.containsKey(name)) {
            Icon icon = null;
            if (name.endsWith(".gif")) {
                InputStream istrm = IconFactory.class.getResourceAsStream(IMAGE_PATH + name);
                if (istrm != null) {
                    try {
                        int datum;
                        istrm = new BufferedInputStream(istrm);
                        ByteArrayOutputStream ostrm = new ByteArrayOutputStream(1024);
                        while ((datum = istrm.read()) > -1) {
                            ostrm.write(datum);
                        }
                        icon = new ImageIcon(ostrm.toByteArray());
                    }
                    catch (IOException iOException) {}
                }
            } else {
                icon = UIManager.getIcon(name);
            }
            if (icon == null) {
                icon = IconFactory.getIconByName("Tree.leafIcon");
            }
            iconMap.put(name, icon);
        }
        return (Icon)iconMap.get(name);
    }

    private static boolean isFestive() {
        Calendar now = Calendar.getInstance();
        int month = now.get(2);
        int day = now.get(5);
        return month == 11 && day >= 21 || month == 0 && day <= 6;
    }
}

