/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.Cursor;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.array.ArrayImpl;
import uk.ac.starlink.array.BridgeNDArray;
import uk.ac.starlink.array.MouldArrayImpl;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.ast.AstException;
import uk.ac.starlink.ast.AstObject;
import uk.ac.starlink.ast.FitsChan;
import uk.ac.starlink.ast.Frame;
import uk.ac.starlink.ast.FrameSet;
import uk.ac.starlink.ast.SkyFrame;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.DataObjectException;
import uk.ac.starlink.datanode.nodes.DataType;
import uk.ac.starlink.datanode.nodes.DetailViewer;
import uk.ac.starlink.datanode.nodes.FITSDataNode;
import uk.ac.starlink.datanode.nodes.HDUDataNode;
import uk.ac.starlink.datanode.nodes.IconFactory;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.datanode.nodes.NodeUtil;
import uk.ac.starlink.fits.FitsArrayBuilder;
import uk.ac.starlink.ndx.DefaultMutableNdx;
import uk.ac.starlink.ndx.Ndx;

public class ImageHDUDataNode
extends HDUDataNode {
    private String name;
    private String description;
    private String hduType;
    private Header header;
    private NDShape shape;
    private final String dataType;
    private String blank;
    private FITSDataNode.ArrayDataMaker hdudata;
    private Number badval;
    private FrameSet wcs;
    private String wcsEncoding;
    private Ndx ndx;

    public ImageHDUDataNode(Header hdr, FITSDataNode.ArrayDataMaker hdudata) throws NoSuchDataException {
        short iconID;
        block19: {
            boolean ok;
            super(hdr, hdudata);
            this.header = hdr;
            this.hdudata = hdudata;
            this.hduType = this.getHduType();
            if (this.hduType != "Image") {
                throw new NoSuchDataException("Not an Image HDU");
            }
            long[] axes = ImageHDUDataNode.getDimsFromHeader(hdr);
            int ndim = axes.length;
            boolean bl = ok = axes != null && ndim > 0;
            if (ok) {
                for (int i = 0; i < ndim; ++i) {
                    ok = ok && axes[i] > 0L;
                }
            }
            if (ok) {
                this.shape = new NDShape(axes);
            }
            boolean hasBlank = hdr.containsKey("BLANK");
            this.badval = null;
            this.blank = "<none>";
            switch (hdr.getIntValue("BITPIX")) {
                case 8: {
                    this.dataType = "byte";
                    if (!hasBlank) break;
                    int val = hdr.getIntValue("BLANK");
                    this.blank = "" + val;
                    this.badval = new Byte((byte)val);
                    break;
                }
                case 16: {
                    this.dataType = "short";
                    if (!hasBlank) break;
                    int val = hdr.getIntValue("BLANK");
                    this.blank = "" + val;
                    this.badval = new Short((short)val);
                    break;
                }
                case 32: {
                    this.dataType = "int";
                    if (!hasBlank) break;
                    int val = hdr.getIntValue("BLANK");
                    this.blank = "" + val;
                    this.badval = new Integer(val);
                    break;
                }
                case -32: {
                    this.dataType = "float";
                    this.blank = null;
                    break;
                }
                case -64: {
                    this.dataType = "double";
                    this.blank = null;
                    break;
                }
                case 64: {
                    throw new NoSuchDataException("64-bit integers not supported by FITS");
                }
                default: {
                    this.dataType = null;
                }
            }
            if (NodeUtil.hasAST()) {
                try {
                    Cursor hdrIt = hdr.iterator();
                    Iterator lineIt = new Iterator((Iterator)hdrIt){
                        private final /* synthetic */ Iterator val$hdrIt;
                        {
                            this.val$hdrIt = val$hdrIt;
                        }

                        public boolean hasNext() {
                            return this.val$hdrIt.hasNext();
                        }

                        public Object next() {
                            return this.val$hdrIt.next().toString();
                        }

                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                    FitsChan chan = new FitsChan(lineIt);
                    this.wcsEncoding = chan.getEncoding();
                    AstObject aobj = chan.read();
                    if (aobj != null && aobj instanceof FrameSet) {
                        this.wcs = (FrameSet)aobj;
                        break block19;
                    }
                    this.wcsEncoding = null;
                    this.wcs = null;
                }
                catch (AstException e) {
                    this.wcsEncoding = null;
                    this.wcs = null;
                }
            } else {
                this.wcsEncoding = null;
                this.wcs = null;
            }
        }
        this.description = "(" + this.hduType + (this.shape != null ? " " + NDShape.toString((long[])this.shape.getDims()) + " " : "") + ")";
        if (this.shape == null) {
            iconID = 112;
        } else {
            int nd = this.shape.getNumPixels() == 1L ? 0 : this.shape.getNumDims();
            iconID = IconFactory.getArrayIconID(nd);
        }
        this.setIconID(iconID);
    }

    public boolean allowsChildren() {
        return this.wcs != null;
    }

    public Iterator getChildIterator() {
        ArrayList<DataNode> children = new ArrayList<DataNode>();
        if (this.wcs != null) {
            children.add(this.makeChild(this.wcs));
        }
        return children.iterator();
    }

    public void configureDetail(DetailViewer dv) {
        super.configureDetail(dv);
        dv.addSeparator();
        if (this.shape != null) {
            dv.addKeyedItem("Shape", NDShape.toString((long[])this.shape.getDims()));
        }
        if (this.dataType != null) {
            dv.addKeyedItem("Pixel type", this.dataType);
        }
        if (this.blank != null) {
            dv.addKeyedItem("Blank value", this.blank);
        }
        if (this.wcs != null) {
            dv.addSubHead("World coordinate system");
            dv.addKeyedItem("Encoding", this.wcsEncoding);
            Frame frm = this.wcs.getFrame(FrameSet.AST__CURRENT);
            dv.addKeyedItem("Naxes", frm.getNaxes());
            if (frm instanceof SkyFrame) {
                SkyFrame sfrm = (SkyFrame)frm;
                dv.addKeyedItem("Epoch", sfrm.getEpoch());
                dv.addKeyedItem("Equinox", sfrm.getEquinox());
                dv.addKeyedItem("Projection", sfrm.getProjection());
                dv.addKeyedItem("System", sfrm.getSystem());
            }
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getNodeTLA() {
        return "IMG";
    }

    public String getNodeType() {
        return "FITS Image HDU";
    }

    static long[] getDimsFromHeader(Header hdr) {
        try {
            int naxis = hdr.getIntValue("NAXIS");
            long[] dimensions = new long[naxis];
            for (int i = 0; i < naxis; ++i) {
                String key = "NAXIS" + (i + 1);
                if (!hdr.containsKey(key)) {
                    throw new FitsException("No header card + " + key);
                }
                dimensions[i] = hdr.getLongValue(key);
            }
            return dimensions;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean hasDataObject(DataType dtype) {
        if (dtype == DataType.NDX) {
            return this.shape != null;
        }
        return super.hasDataObject(dtype);
    }

    public Object getDataObject(DataType dtype) throws DataObjectException {
        if (this.hasDataObject(dtype) && dtype == DataType.NDX) {
            try {
                return this.getNdx();
            }
            catch (IOException e) {
                throw new DataObjectException(e);
            }
        }
        return super.getDataObject(dtype);
    }

    private synchronized Ndx getNdx() throws IOException {
        if (this.ndx == null) {
            ArrayDataInput data = this.hdudata.getArrayData();
            NDArray nda = FitsArrayBuilder.getInstance().makeNDArray(data, AccessMode.READ);
            if (!nda.getShape().equals((Object)this.shape)) {
                nda = new BridgeNDArray((ArrayImpl)new MouldArrayImpl(nda, this.shape));
            }
            this.ndx = new DefaultMutableNdx(nda);
            if (this.wcs != null) {
                ((DefaultMutableNdx)this.ndx).setWCS((Object)this.wcs);
            }
        }
        return this.ndx;
    }
}

