/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.datanode.nodes.ComponentMaker;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.DataType;
import uk.ac.starlink.datanode.nodes.DefaultDataNode;
import uk.ac.starlink.datanode.nodes.DetailViewer;
import uk.ac.starlink.datanode.nodes.IconFactory;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.datanode.nodes.NodeUtil;
import uk.ac.starlink.datanode.nodes.ScalarDataNode;
import uk.ac.starlink.datanode.nodes.XMLDocument;
import uk.ac.starlink.datanode.viewers.TextViewer;
import uk.ac.starlink.hds.HDSException;
import uk.ac.starlink.hds.HDSObject;
import uk.ac.starlink.hds.HDSReference;
import uk.ac.starlink.hds.NDFNdxHandler;
import uk.ac.starlink.hdx.HdxException;
import uk.ac.starlink.hdx.HdxFactory;
import uk.ac.starlink.ndx.Ndx;
import uk.ac.starlink.ndx.NdxIO;
import uk.ac.starlink.ndx.XMLNdxHandler;
import uk.ac.starlink.util.URLUtils;

public class NdxDataNode
extends DefaultDataNode {
    private Ndx ndx;
    private String name;
    private String desc;
    private URL url;

    public NdxDataNode(String loc) throws NoSuchDataException {
        try {
            this.url = new URL(new URL("file:."), loc);
        }
        catch (MalformedURLException e) {
            this.url = null;
        }
        try {
            this.ndx = new NdxIO().makeNdx(loc, AccessMode.READ);
        }
        catch (IOException e) {
            throw new NoSuchDataException("Can't make NDX", e);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchDataException("Can't make NDX", e);
        }
        if (this.ndx == null) {
            throw new NoSuchDataException("URL " + loc + " doesn't look like an NDX");
        }
        this.name = loc.replaceFirst("#.*$", "");
        this.name = this.name.replaceFirst("^.*/", "");
        this.setLabel(this.name);
        this.registerDataObject(DataType.NDX, this.ndx);
    }

    public NdxDataNode(File file) throws NoSuchDataException {
        this(file.toString());
    }

    public NdxDataNode(HDSObject hobj) throws NoSuchDataException {
        try {
            this.url = new HDSReference(hobj).getURL();
        }
        catch (HDSException e) {
            this.url = null;
        }
        try {
            this.ndx = NDFNdxHandler.getInstance().makeNdx(hobj, this.url, AccessMode.READ);
            this.name = hobj.datName();
        }
        catch (HDSException e) {
            throw new NoSuchDataException(e);
        }
        if (this.ndx == null) {
            throw new NoSuchDataException("Not an NDF structure");
        }
        this.setLabel(this.name);
    }

    public NdxDataNode(Source xsrc) throws NoSuchDataException {
        try {
            this.ndx = XMLNdxHandler.getInstance().makeNdx(xsrc, AccessMode.READ);
        }
        catch (IOException e) {
            throw new NoSuchDataException(e);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchDataException(e);
        }
        if (this.ndx == null) {
            throw new NoSuchDataException("Not an NDX");
        }
        this.name = this.ndx.hasTitle() ? this.ndx.getTitle() : "ndx";
        this.url = URLUtils.makeURL(xsrc.getSystemId());
        this.setLabel(this.name);
    }

    public NdxDataNode(XMLDocument xdoc) throws NoSuchDataException {
        this(xdoc.constructDOM(false));
    }

    public String getDescription() {
        if (this.desc == null) {
            this.desc = new NDShape((NDShape)this.ndx.getImage().getShape()).toString();
        }
        return this.desc;
    }

    public boolean allowsChildren() {
        return true;
    }

    public Iterator getChildIterator() {
        int badbits;
        ArrayList<DataNode> children = new ArrayList<DataNode>();
        if (this.ndx.hasTitle()) {
            ScalarDataNode tit = new ScalarDataNode("Title", "string", this.ndx.getTitle());
            this.getChildMaker().configureDataNode(tit, this, null);
            children.add(tit);
        }
        if (this.ndx.hasLabel()) {
            ScalarDataNode lab = new ScalarDataNode("Label", "string", this.ndx.getLabel());
            this.getChildMaker().configureDataNode(lab, this, null);
            children.add(lab);
        }
        if (this.ndx.hasUnits()) {
            ScalarDataNode uni = new ScalarDataNode("Units", "string", this.ndx.getUnits());
            this.getChildMaker().configureDataNode(uni, this, null);
            children.add(uni);
        }
        DataNode im = this.makeChild(this.ndx.getImage());
        im.setLabel("image");
        children.add(im);
        if (this.ndx.hasVariance()) {
            DataNode var = this.makeChild(this.ndx.getVariance());
            var.setLabel("variance");
            children.add(var);
        }
        if (this.ndx.hasQuality()) {
            DataNode qual = this.makeChild(this.ndx.getQuality());
            qual.setLabel("quality");
            children.add(qual);
        }
        if ((badbits = this.ndx.getBadBits()) != 0) {
            ScalarDataNode bb = new ScalarDataNode("BadBits", "int", "0x" + Integer.toHexString(badbits));
            this.getChildMaker().configureDataNode(bb, this, null);
            children.add(bb);
        }
        if (NodeUtil.hasAST() && this.ndx.hasWCS()) {
            DataNode wnode = this.makeChild(this.ndx.getAst());
            children.add(wnode);
        }
        if (this.ndx.hasEtc()) {
            DataNode etcNode = this.makeChild(this.ndx.getEtc());
            children.add(etcNode);
        }
        return children.iterator();
    }

    public String getName() {
        return this.name;
    }

    public String getNodeTLA() {
        return "NDX";
    }

    public String getNodeType() {
        return "NDX structure";
    }

    public Icon getIcon() {
        return IconFactory.getIcon((short)130);
    }

    public String getPathElement() {
        return this.getLabel();
    }

    public String getPathSeparator() {
        return ".";
    }

    public void configureDetail(DetailViewer dv) {
        if (this.ndx.hasTitle()) {
            dv.addKeyedItem("Title", this.ndx.getTitle());
        }
        dv.addPane("HDX view", new ComponentMaker(){

            public JComponent getComponent() throws TransformerException, HdxException, MalformedURLException {
                URI uri = URLUtils.urlToUri(NdxDataNode.this.url);
                Source src = HdxFactory.getInstance().newHdxContainer(NdxDataNode.this.ndx.getHdxFacade()).getSource(uri);
                return new TextViewer(src);
            }
        });
    }
}

